/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross.ui.editor.properties;

import com.indy.cross.ui.LineageTreeBuilder;
import com.indy.cross.ui.Messages;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class NodeSection
extends AbstractPropertySection {
    private Text type;
    private Text name;
    private Text fullPath;
    private Text level;
    private Text product;
    private Hyperlink modelLink;
    private URI modelURI;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite main = this.getWidgetFactory().createComposite(parent);
        main.setLayout((Layout)new GridLayout(2, false));
        Label l = this.getWidgetFactory().createLabel(main, Messages.NodeSection_0);
        this.name = this.getWidgetFactory().createText(main, "");
        this.name.setLayoutData((Object)new GridData(4, 1, true, false));
        this.name.setEditable(false);
        l = this.getWidgetFactory().createLabel(main, Messages.NodeSection_2);
        this.type = this.getWidgetFactory().createText(main, "");
        this.type.setLayoutData((Object)new GridData(4, 1, true, false));
        this.type.setEditable(false);
        l = this.getWidgetFactory().createLabel(main, Messages.NodeSection_4);
        this.level = this.getWidgetFactory().createText(main, "");
        this.level.setLayoutData((Object)new GridData(4, 1, true, false));
        this.level.setEditable(false);
        l = this.getWidgetFactory().createLabel(main, Messages.NodeSection_6);
        this.product = this.getWidgetFactory().createText(main, "");
        this.product.setLayoutData((Object)new GridData(4, 1, true, false));
        this.product.setEditable(false);
        l = this.getWidgetFactory().createLabel(main, Messages.NodeSection_8);
        this.fullPath = this.getWidgetFactory().createText(main, "");
        this.fullPath.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fullPath.setEditable(false);
        l = this.getWidgetFactory().createLabel(main, Messages.NodeSection_10);
        this.modelLink = this.getWidgetFactory().createHyperlink(main, "", 64);
        this.modelLink.setLayoutData((Object)new GridData(4, 1, true, false));
        this.modelLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new URIEditorInput(NodeSection.this.modelURI), "com.stambia.md.presentation.MdEditorID");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    public void refresh() {
        super.refresh();
        IStructuredSelection ss = (IStructuredSelection)this.getSelection();
        if (ss.getFirstElement() instanceof LineageTreeBuilder.Node) {
            LineageTreeBuilder.Node node = (LineageTreeBuilder.Node)ss.getFirstElement();
            this.name.setText(node.getLabel());
            this.level.setText(node.getLevelCode() == null ? "" : node.getLevelCode());
            this.product.setText(node.getProduct() == null ? "" : node.getProduct());
            this.fullPath.setText(node.getFullPath() == null ? "" : node.getFullPath());
            this.modelURI = node.getFileURI();
            if (this.modelURI == null) {
                this.modelLink.setText("");
            } else {
                String path = URI.decode((String)node.getFileURI().trimFragment().path());
                if (path.startsWith("/resource/")) {
                    path = path.substring(10);
                }
                this.modelLink.setText(path);
            }
        }
    }
}

