/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.edit.provider.custom;

import com.indy.gmf.map.edit.provider.custom.MapEditUtil;
import com.indy.gmf.map.edit.provider.custom.MapIconAPI;
import com.indy.map.ComputedField;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.ILogicalField;
import com.indy.map.QueryField;
import com.indy.map.SetDescriptor;
import com.indy.map.edit.provider.MapEditPlugin;
import com.indy.map.edit.provider.QueryItemProvider;
import com.indy.map.ref.RComputedField;
import com.indy.map.ref.RProblem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

public class ImageHelper {
    public static final int FIELD_ERROR = 2;
    public static final int FIELD_TYPE = 4;
    public static final int FIELD_MAPPED = 8;
    public static final int FIELD_TRG_LOCATION = 16;
    public static final int FIELD_TRG_INFORMATIONS = 32;
    public static final int FIELD_TAG = 64;
    public static final int FIELD_DEPTH = 128;
    public static final int FIELD_EXPAND = 256;
    public static final int FIELD_PROPERTY = 512;
    public static Image transparent = ExtendedImageRegistry.getInstance().getImage(MapEditUtil.getImage("full/other/transparent12x16.png"));
    public static Image collapse = ExtendedImageRegistry.getInstance().getImage(MapEditUtil.getImage("full/other/collapse12x16.png"));
    public static Image expand = ExtendedImageRegistry.getInstance().getImage(MapEditUtil.getImage("full/other/expand12x16.png"));
    public static ImageHelper INSTANCE = new ImageHelper();

    public List<Image> getFieldComposedImage(ILogicalField field, int mode, SetDescriptor desc, boolean isSrc) {
        ArrayList<Image> images = new ArrayList<Image>();
        if (field instanceof Field) {
            Image error;
            Expression exp;
            if ((mode & 0x80) != 0) {
                int i = 1;
                while (i < ((Field)field).getDepth()) {
                    images.add(transparent);
                    ++i;
                }
            }
            if ((mode & 0x100) != 0) {
                if (((Field)field).isExpand()) {
                    images.add(expand);
                } else {
                    images.add(collapse);
                }
            }
            images.add(MapIconAPI.getFieldMappedIcon(field));
            images.add(MapIconAPI.getFieldMdIcon((Field)field, ((Field)field).getRef()));
            images.add(MapIconAPI.getOnePixelTranspartentImage());
            if ((mode & 4) != 0) {
                if (isSrc) {
                    images.add(MapIconAPI.getFieldTypeIcon((Field)field, desc));
                } else {
                    images.add(MapIconAPI.getFieldTypeIcon((Field)field));
                }
            }
            if ((exp = field.getExpression(desc)) != null) {
                if ((mode & 0x10) != 0) {
                    images.add(MapIconAPI.getTrgFieldLocationIcon((Field)field, exp));
                }
                if ((mode & 0x20) != 0) {
                    images.add(MapIconAPI.getTrgFieldInfoIcon(exp));
                }
            }
            if ((mode & 0x200) != 0 && !((Field)field).getProperty().isEmpty()) {
                images.add(MapIconAPI.getPropertyIcon());
            }
            if ((mode & 0x40) != 0 && !((Field)field).getTag().isEmpty()) {
                images.add(MapIconAPI.getFieldTagIcon((Field)field));
            }
            if ((mode & 2) != 0 && (error = MapIconAPI.getFieldError((Field)field, ((Field)field).getRef())) != null) {
                images.add(error);
            }
        } else if (field instanceof QueryField) {
            Image error;
            Expression exp;
            images.add(QueryItemProvider.queryImage);
            if ((mode & 4) != 0) {
                images.add(MapIconAPI.getFieldTypeIcon((QueryField)field));
            }
            if ((mode & 0x10) != 0 && (exp = field.getExpression(desc)) != null) {
                images.add(MapIconAPI.getTrgFieldLocationIcon((QueryField)field, exp));
            }
            if ((mode & 2) != 0 && (error = MapIconAPI.getFieldError((QueryField)field)) != null) {
                images.add(error);
            }
        } else if (field instanceof ComputedField) {
            images.add(ExtendedImageRegistry.INSTANCE.getImage(MapEditPlugin.INSTANCE.getImage("full/obj16/rdbms.computedField5.png")));
            if ((mode & 2) != 0) {
                RProblem.Type type = RProblem.Type.NONE;
                for (RProblem p : ((RComputedField)((ComputedField)field).getMapReference()).getProblem()) {
                    if (p.getProblemType().ordinal() <= type.ordinal()) continue;
                    type = p.getProblemType();
                }
                switch (type) {
                    case ERROR: {
                        images.add(MapIconAPI.getImage("full/other/error_obj.gif"));
                        break;
                    }
                    case WARNING: {
                        images.add(MapIconAPI.getImage("full/other/warning_obj.gif"));
                        break;
                    }
                    case INFO: {
                        images.add(MapIconAPI.getImage("full/other/info_obj.png"));
                    }
                }
            }
        }
        return images;
    }
}

