/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.edit.provider.custom;

import com.indy.map.Constraint;
import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.IReferencable;
import com.indy.map.Inliner;
import com.indy.map.Outliner;
import com.indy.map.Template;
import com.indy.map.edit.provider.MapEditPlugin;
import com.indy.map.ref.RDatastore;
import com.indy.map.ref.RField;
import com.indy.map.ref.RItem;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class MapEditUtil {
    private static AdapterFactoryLabelProvider aflp;
    private static final int CONTAINER_NO_MODE = 0;
    private static final int CONTAINER_SOURCE_MODE = 1;
    private static final int CONTAINER_TARGET_MODE = 2;
    private static HashMap<Image, Image> offsetedDatastoreImage;

    static {
        offsetedDatastoreImage = new HashMap();
    }

    public static Object getImage(String path) {
        return MapEditPlugin.INSTANCE.getImage(path);
    }

    public static Image getImage(Object object) {
        if (aflp == null) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            aflp = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        }
        return aflp.getImage(object);
    }

    public static Image getImage(IMetaData md) {
        if (md != null && md.getRef() != null && !md.getRef().eIsProxy()) {
            if (aflp == null) {
                ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                aflp = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
            }
            return aflp.getImage((Object)md.getRef());
        }
        return null;
    }

    public static Image getConstraintImage(EObject constraint) {
        Constraint con;
        if (constraint instanceof Constraint && (con = (Constraint)constraint).getRef() != null && !con.getRef().eIsProxy()) {
            return MapEditUtil.getImage(con.getRef());
        }
        return null;
    }

    private static void addTargetSourceImage(List<Object> images) {
        images.add(MapEditUtil.getImage("full/obj38x16/MappingSourceTarget38x16.png"));
    }

    public static Image getDatastoreImage(Datastore source) {
        ArrayList<Object> images = new ArrayList<Object>();
        Object bg = null;
        if (source instanceof IMetaData && source.getRef() != null && !source.getRef().eIsProxy() && offsetedDatastoreImage.get(bg = MapEditUtil.getImage((IMetaData)source)) == null) {
            ImageData srcData = bg.getImageData();
            ImageData d = srcData.scaledTo(srcData.width + 6, srcData.height);
            if (d.transparentPixel == -1) {
                d.transparentPixel = 0;
            }
            d.type = 5;
            int i = 0;
            while (i < d.width) {
                int j = 0;
                while (j < d.height) {
                    if (i < 6) {
                        d.setPixel(i, j, d.transparentPixel);
                    } else {
                        d.setPixel(i, j, srcData.getPixel(i - 6, j));
                    }
                    ++j;
                }
                ++i;
            }
            Iterator i2 = new Image(bg.getDevice(), d);
            offsetedDatastoreImage.put((Image)bg, (Image)i2);
            bg = i2;
        }
        if (bg == null) {
            MapEditUtil.addDataStoreBackGroundImage(images);
        } else {
            images.add(bg);
        }
        int targetSourceMode = 0;
        if (!source.getSetDescriptor().isEmpty()) {
            targetSourceMode |= 2;
        }
        for (Field f : source.getField()) {
            if (((RField)f.getMapReference()).getUsage().isEmpty()) continue;
            targetSourceMode |= 1;
            break;
        }
        if ((targetSourceMode & 1) != 0 && (targetSourceMode & 2) != 0) {
            MapEditUtil.addTargetSourceImage(images);
        } else if ((targetSourceMode & 1) != 0) {
            MapEditUtil.addSourceImage(images);
        } else if ((targetSourceMode & 2) != 0) {
            MapEditUtil.addTargetImage(images);
        }
        MapEditUtil.addSourceCDCImage(source, images);
        MapEditUtil.addTargetCtrlImage(source, images);
        if (!source.getTag().isEmpty()) {
            images.add(MapEditUtil.getImage("full/obj38x16/MappingTableTag38x16.png"));
        }
        if (source.getRef() == null || source.getRef().eIsProxy()) {
            images.add(MapEditUtil.getImage("full/obj22x22/DataStoreError22x22.png"));
        } else {
            Object errImg = null;
            for (RProblem p : ((RDatastore)source.getMapReference()).getProblem()) {
                if (p.getProblemType() == RProblem.Type.ERROR) {
                    errImg = MapEditUtil.getImage("full/obj22x22/DataStoreError22x22.png");
                    break;
                }
                if (p.getProblemType() != RProblem.Type.WARNING) continue;
                errImg = MapEditUtil.getImage("full/obj22x22/DataStoreWarning22x22.png");
            }
            if (errImg != null) {
                images.add(errImg);
            }
        }
        ComposedImage obj = new ComposedImage(images);
        Image retour = ExtendedImageRegistry.getInstance().getImage((Object)obj);
        return retour;
    }

    public static Image getStageImage(IContainer source) {
        ArrayList<Object> images = new ArrayList<Object>();
        if (source instanceof Outliner) {
            images.add(MapEditUtil.getImage("full/obj16x16/deserializer16x16.png"));
        } else if (source instanceof Inliner) {
            images.add(MapEditUtil.getImage("full/obj16x16/serializer16x16.png"));
        } else {
            images.add(MapEditUtil.getImage("full/obj16x16/MappingTable16x16.png"));
        }
        int targetSourceMode = 0;
        if (!source.getSetDescriptor().isEmpty()) {
            targetSourceMode |= 2;
        }
        for (ILogicalField f : source.getLogicalField()) {
            RSourceItem refSrcIt;
            Object ref = null;
            if (f instanceof IReferencable) {
                IReferencable iref = (IReferencable)f;
                ref = iref.getMapReference();
            }
            if (!(ref instanceof RSourceItem) || (refSrcIt = (RSourceItem)ref).getUsage().isEmpty()) continue;
            targetSourceMode |= 2;
            break;
        }
        if ((targetSourceMode & 1) != 0 && (targetSourceMode & 2) != 0) {
            MapEditUtil.addTargetSourceImage(images);
        } else if ((targetSourceMode & 1) != 0) {
            MapEditUtil.addSourceImage(images);
        } else if ((targetSourceMode & 2) != 0) {
            MapEditUtil.addTargetImage(images);
        }
        if (!source.getTag().isEmpty()) {
            images.add(MapEditUtil.getImage("full/obj38x16/MappingTableTag38x16.png"));
        }
        if (((IMetaData)source).getRef() == null || ((IMetaData)source).getRef().eIsProxy()) {
            images.add(MapEditUtil.getImage("full/obj22x22/DataStoreError22x22.png"));
        } else {
            Object errImg = null;
            RItem ref = (RItem)((IReferencable)source).getMapReference();
            for (RProblem p : ref.getProblem()) {
                if (p.getProblemType() == RProblem.Type.ERROR) {
                    errImg = MapEditUtil.getImage("full/obj22x22/DataStoreError22x22.png");
                    break;
                }
                if (p.getProblemType() != RProblem.Type.WARNING) continue;
                errImg = MapEditUtil.getImage("full/obj22x22/DataStoreWarning22x22.png");
            }
            if (errImg != null) {
                images.add(errImg);
            }
        }
        if (images.isEmpty()) {
            return null;
        }
        return ExtendedImageRegistry.getInstance().getImage((Object)new ComposedImage(images));
    }

    private static void addSourceCDCImage(Datastore source, List<Object> images) {
        if (source.isUseCDC()) {
            images.add(MapEditUtil.getImage("full/obj38x16/MappingCDCBleu38x16.png"));
        }
    }

    private static void addSourceImage(List<Object> images) {
        images.add(MapEditUtil.getImage("full/obj38x16/MappingSource38x16.png"));
    }

    private static void addDataStoreBackGroundImage(List<Object> images) {
        String backGround = "full/obj28x16/MappingTable28x16.png";
        images.add(MapEditUtil.getImage(backGround));
    }

    private static void addTargetCtrlImage(Datastore target, List<Object> images) {
        if (target.isControl()) {
            images.add(MapEditUtil.getImage("full/obj38x16/MappingTableCheck38x16.png"));
        }
    }

    private static void addTargetImage(List<Object> images) {
        images.add(MapEditUtil.getImage("full/obj38x16/MappingTarget38x16.png"));
    }

    public static Image getTemplateImage(Template template) {
        ArrayList<Object> images = new ArrayList<Object>();
        Object im = null;
        if (template.getName().startsWith("IS")) {
            im = MapEditUtil.getImage("full/obj22x22/Process22x22_STG.png");
        } else if (template.getName().startsWith("I")) {
            im = ((RTemplate)template.getMapReference()).getTemplateCriteria().contains("type=IS-TP") ? MapEditUtil.getImage("full/obj22x22/Process22x22_STG.png") : MapEditUtil.getImage("full/obj22x22/Process22x22_INT.png");
        } else if (template.getName().startsWith("L")) {
            im = MapEditUtil.getImage("full/obj22x22/Process22x22_LOAD.png");
        } else if (template.getName().startsWith("R")) {
            im = MapEditUtil.getImage("full/obj22x22/Process22x22_REJ.png");
        }
        if (im == null) {
            im = MapEditUtil.getImage("full/obj32/Template.png");
        }
        images.add(im);
        if (template.getMapReference() != null) {
            RProblem.Type type = RProblem.Type.NONE;
            for (RProblem p : ((RTemplate)template.getMapReference()).getProblem()) {
                if (p.getProblemType().ordinal() <= type.ordinal()) continue;
                type = p.getProblemType();
            }
            switch (type) {
                case ERROR: {
                    images.add(MapEditUtil.getImage("full/obj22x22/InstanceError22x22.png"));
                    break;
                }
                case WARNING: {
                    images.add(MapEditUtil.getImage("full/obj22x22/DataStoreWarning22x22.png"));
                }
            }
        }
        ComposedImage obj = new ComposedImage(images);
        return ExtendedImageRegistry.getInstance().getImage((Object)obj);
    }
}

