/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLContextFactory {
    private static String defaultProtocol = "TLSv1.2";

    private SSLContextFactory() {
    }

    public static SSLContext createSSLContext(SSLContextParameters sslContextParams) throws Exception {
        FileInputStream is;
        Object var5_7;
        Throwable throwable;
        SSLContext sslContext = SSLContext.getInstance(sslContextParams.protocol);
        TrustManager[] trustManagers = null;
        KeyManager[] keyManagers = null;
        if (sslContextParams.keyStorePath != null) {
            throwable = null;
            var5_7 = null;
            try {
                is = new FileInputStream(sslContextParams.keyStorePath);
                try {
                    KeyStore ks = KeyStore.getInstance(sslContextParams.keyStoreType);
                    ks.load(is, sslContextParams.keyStorePassword);
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, sslContextParams.keyStorePassword);
                    keyManagers = kmf.getKeyManagers();
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (sslContextParams.trustStorePath != null) {
            throwable = null;
            var5_7 = null;
            try {
                is = new FileInputStream(sslContextParams.trustStorePath);
                try {
                    KeyStore ts = KeyStore.getInstance(sslContextParams.trustStoreType);
                    ts.load(is, sslContextParams.trustStorePassword);
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    tmf.init(ts);
                    trustManagers = tmf.getTrustManagers();
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        if (!sslContextParams.enableCertificateVerification) {
            X509TrustManager trustMgr = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            trustManagers = new TrustManager[]{trustMgr};
        }
        sslContext.init(keyManagers, trustManagers, sslContextParams.random);
        return sslContext;
    }

    public static class SSLContextParameters {
        String protocol;
        String keyStoreType;
        String keyStorePath;
        char[] keyStorePassword;
        String trustStoreType;
        String trustStorePath;
        char[] trustStorePassword;
        SecureRandom random;
        boolean enableCertificateVerification;

        public SSLContextParameters(boolean enableCertificateVerification) {
            this(null, null, null, null, null, null, null, null, enableCertificateVerification);
        }

        public SSLContextParameters() {
            this(true);
        }

        public SSLContextParameters(String protocol, String keyStoreType, String keyStorePath, char[] keyStorePassword, String trustStoreType, String trustStorePath, char[] trustStorePassword, SecureRandom random, boolean enableCertificateVerification) {
            this.enableCertificateVerification = enableCertificateVerification;
            this.random = random;
            String string = this.protocol = protocol == null ? defaultProtocol : protocol;
            if (keyStorePath == null) {
                this.keyStorePath = System.getProperty("javax.net.ssl.keyStore");
                String string2 = this.keyStoreType = System.getProperty("javax.net.ssl.keyStoreType") == null ? KeyStore.getDefaultType() : System.getProperty("javax.net.ssl.keyStoreType");
                this.keyStorePassword = (char[])(System.getProperty("javax.net.ssl.keyStorePassword") == null ? null : System.getProperty("javax.net.ssl.keyStorePassword").toCharArray());
            } else {
                this.keyStorePath = keyStorePath;
                this.keyStoreType = keyStoreType;
                this.keyStorePassword = keyStorePassword;
            }
            if (trustStorePath == null) {
                this.trustStorePath = System.getProperty("javax.net.ssl.trustStore");
                String string3 = this.trustStoreType = System.getProperty("javax.net.ssl.trustStoreType") == null ? KeyStore.getDefaultType() : System.getProperty("javax.net.ssl.trustStoreType");
                this.trustStorePassword = (char[])(System.getProperty("javax.net.ssl.trustStorePassword") == null ? null : System.getProperty("javax.net.ssl.trustStorePassword").toCharArray());
            } else {
                this.trustStorePath = trustStorePath;
                this.trustStoreType = trustStoreType;
                this.trustStorePassword = trustStorePassword;
            }
        }
    }
}

