/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.models;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.semarchy.xdi.designer.core.utils.IntrospectionUtils;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;

public final class IndyResourceUtil {
    public static String generateFragment(Map<EObject, String> DETACHED_EOBJECT_TO_ID_MAP, IndyResource resource, String baseFragment, EObject eObject) {
        Object _name;
        String id;
        Object fragment = new String(baseFragment);
        if (((String)fragment).startsWith("//@") && (id = DETACHED_EOBJECT_TO_ID_MAP.get(eObject)) != null) {
            fragment = id;
        }
        Object fragment2 = "";
        String fileId = resource.getId();
        if (fileId != null) {
            fragment2 = "fileId=" + fileId;
        } else {
            resource.setId(EMFResourceUtil.getFirstId(resource));
            fileId = resource.getId();
            if (fileId == null && resource.isLoaded()) {
                Logger.getLogger(IndyResourceUtil.class.getName()).warning("Impossible de trouver l'identifiant fichier dans le cache fragment:" + (String)fragment + " fichier :" + String.valueOf(resource.getURI()));
            } else {
                fragment2 = "fileId=" + fileId;
            }
        }
        if (resource.getURI() != null && resource.getURI().fileExtension() != null) {
            String type = "type=" + resource.getURI().fileExtension();
            fragment2 = ((String)fragment2).length() > 0 ? (String)fragment2 + "$" + type : type;
        }
        if ((_name = IntrospectionUtils.getMethod(eObject, "getName")) instanceof String) {
            String name = "name=" + String.valueOf(_name);
            fragment2 = ((String)fragment2).length() > 0 ? (String)fragment2 + "$" + name : name;
        }
        if (((String)fragment2).length() > 0) {
            fragment = (String)fragment + "?" + URI.encodeFragment((String)URIUtils.normalizeResourceFragment((String)fragment2), (boolean)false) + "?";
        }
        return fragment;
    }

    public static interface IndyResource
    extends Resource {
        public String getId();

        public void setId(String var1);

        public Map<String, EObject> getIntrinsicIDToEObjectMap();

        public void setIntrinsicIDToEObjectMap(Map<String, EObject> var1);

        public Map<? extends Object, ? extends Object> getDefaultSaveOptions();
    }

    public static class IndyURIHandler
    extends URIHandlerImpl {
        ICacheService cacheService = E4InjectorHelper.getService(ICacheService.class);

        public URI deresolve(URI uri) {
            if (uri.fragment().contains("fileId")) {
                URI r = URI.createURI((String)"resource");
                if ("udf".equals(uri.scheme())) {
                    return super.deresolve(uri);
                }
                return r.appendFileExtension(uri.fileExtension()).appendFragment(uri.fragment());
            }
            return URI.createURI((String)"").appendFragment(uri.fragment());
        }

        public URI resolve(URI uri) {
            String fragment = uri.fragment();
            if (fragment != null && this.matches(fragment)) {
                URI newUri = this.resolve(fragment);
                if (newUri != null) {
                    return newUri;
                }
                return uri;
            }
            return super.resolve(uri);
        }

        protected URI resolve(String fragment) {
            return this.cacheService.resolve(fragment);
        }

        public boolean matches(String fragment) {
            return fragment.contains("?") && fragment.endsWith("?");
        }
    }
}

