/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.utils;

import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.osgi.service.log.LogService;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MetaInfParserUtil {
    private static DocumentBuilder createBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
        parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return parserFactory.newDocumentBuilder();
    }

    public static NodeList parseMetaInf(String metaInf) {
        if (metaInf != null && !metaInf.isEmpty()) {
            String xml = "<root>" + metaInf + "</root>";
            try {
                DocumentBuilder parser = MetaInfParserUtil.createBuilder();
                Document document = parser.parse(new InputSource(new StringReader(xml)));
                NodeList nl = document.getElementsByTagName("metaInf");
                return nl;
            }
            catch (Exception e) {
                E4InjectorHelper.getService(LogService.class).getLogger(MetaInfParserUtil.class).warn("Failed to parse metainf", (Object)e);
            }
        }
        return null;
    }

    public static NodeList parseMetaInf(String xml, String tagName) {
        if (xml != null && !((String)xml).isEmpty()) {
            xml = "<root>" + (String)xml + "</root>";
            try {
                DocumentBuilder parser = MetaInfParserUtil.createBuilder();
                Document document = parser.parse(new InputSource(new StringReader((String)xml)));
                NodeList nl = document.getElementsByTagName(tagName);
                return nl;
            }
            catch (Exception e) {
                E4InjectorHelper.getService(LogService.class).getLogger(MetaInfParserUtil.class).warn("Failed to parse metainf", (Object)e);
            }
        }
        return null;
    }

    public static String getNonMetaInf(String metaInf) {
        StringBuilder b = new StringBuilder();
        if (metaInf != null && !metaInf.isEmpty()) {
            String xml = "<root>" + metaInf + "</root>";
            try {
                DocumentBuilder parser = MetaInfParserUtil.createBuilder();
                Document document = parser.parse(new InputSource(new StringReader(xml)));
                NodeList nl = document.getChildNodes().item(0).getChildNodes();
                Transformer transformer = null;
                int i = 0;
                while (i < nl.getLength()) {
                    if (!"metaInf".equals(nl.item(i).getNodeName())) {
                        if (transformer == null) {
                            TransformerFactory tf = TransformerFactory.newInstance();
                            try {
                                tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                            try {
                                tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                            transformer = tf.newTransformer();
                            transformer.setOutputProperty("omit-xml-declaration", "yes");
                        }
                        StringWriter sw = new StringWriter();
                        transformer.transform(new DOMSource(nl.item(i).cloneNode(true)), new StreamResult(sw));
                        if (!sw.toString().trim().isEmpty()) {
                            b.append(sw.toString());
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                E4InjectorHelper.getService(LogService.class).getLogger(MetaInfParserUtil.class).warn("Failed to parse metainf", (Object)e);
            }
        }
        return b.toString();
    }
}

