/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.text.editor.views.parsing;

import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.ActionCode;
import com.indy.gmf.proc.BindLink;
import com.indy.ui.sql.ISQLDictionary;
import com.indy.ui.sql.SQLDictionary;
import com.indy.ui.sql.editors.configuration.KeyWordRule;
import com.indy.ui.sql.editors.configuration.SQLCodeScanner;
import com.indy.ui.text.editor.Messages;
import com.indy.ui.text.editor.views.parsing.BindableCompletionProcessor;
import com.indy.ui.text.editor.views.parsing.BindingRule;
import com.indy.ui.text.editor.views.parsing.BlockDelimitedRule;
import com.indy.ui.text.editor.views.parsing.ColorHelper;
import com.indy.ui.text.editor.views.parsing.EnclosingAutoEditStrategy;
import com.indy.ui.text.editor.views.parsing.EnsemblistCompletionProcessor;
import com.indy.ui.text.editor.views.parsing.EnsemblistScanner;
import com.indy.ui.text.editor.views.parsing.LightCompletionProcessor;
import com.indy.ui.text.editor.views.parsing.MdVariableHyperlinkDetector;
import com.indy.ui.text.editor.views.parsing.MdVariableRule;
import com.indy.ui.text.editor.views.parsing.ParameterRule;
import com.indy.ui.text.editor.views.parsing.PartitionerProvider;
import com.indy.ui.text.editor.views.parsing.ScriptingRule;
import com.indy.ui.text.editor.views.parsing.StateRuleBasedScanner;
import com.indy.ui.text.editor.views.parsing.UDFRule;
import com.indy.ui.text.editor.views.parsing.XMLRule2;
import com.indy.ui.text.editor.views.parsing.XPathRule;
import com.semarchy.xdi.designer.core.CodeCapability;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.registry.ProcessToolDescriptor;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;

public class XPathViewerConfiguration
extends SourceViewerConfiguration {
    public static final String ANNOTATION_VARIABLE_USAGE = "VARIABLE";
    public static final String ANNOTATION_UDF_USAGE = "UDF";
    public static final Token STRING_TOKEN = new Token((Object)new TextAttribute(ColorHelper.getColor("com.indy.ui.text.editor.preferences.color.xpathString")));
    private static final Pattern PATTERN_VARIABLE = Pattern.compile("(\\%\\{(env:)?[a-zA-Z0-9_\\-\\$]*\\}\\%)");
    CodeCapability contextAdapter;
    boolean syntaxColoringEnabled;

    ITokenScanner getXPathScanner() {
        StateRuleBasedScanner scanner = new StateRuleBasedScanner();
        SingleLineRule string = new SingleLineRule("\"", "\"", (IToken)STRING_TOKEN, '\\');
        SingleLineRule string2 = new SingleLineRule("'", "'", (IToken)STRING_TOKEN, '\\');
        WordRule variable = new WordRule((IWordDetector)new WordDetector(), (IToken)new Token((Object)new TextAttribute(ColorHelper.getColor("com.indy.ui.text.editor.preferences.color.variable"))));
        scanner.setRules(new IRule[]{new BlockDelimitedRule("x", false, ColorHelper.getColor("com.indy.ui.text.editor.preferences.color.xpathDelimiter")), string, string2, variable, new MdVariableRule(), new ParameterRule(), new BindingRule()});
        return scanner;
    }

    ITokenScanner getXslScanner() {
        StateRuleBasedScanner scanner = new StateRuleBasedScanner();
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new BlockDelimitedRule("xsl", true, ColorHelper.getColor("com.indy.ui.text.editor.preferences.color.xslDelimiter")));
        rules.add(new XPathRule());
        rules.add(new XMLRule2());
        rules.add(new ScriptingRule());
        rules.add(new MdVariableRule());
        rules.add(new ParameterRule());
        if (this.contextAdapter.getCodingStyleInfo().supportSQL()) {
            KeyWordRule sqlWordRule = new KeyWordRule((ISQLDictionary)new SQLDictionary(), Token.UNDEFINED, (IToken)new Token((Object)new TextAttribute(ColorHelper.getColor("com.indy.ui.text.editor.preferences.color.keyword"))));
            SingleLineRule sqlStringRule = new SingleLineRule("'", "'", (IToken)STRING_TOKEN, '\\');
            rules.add(sqlStringRule);
        }
        scanner.setRules(rules.toArray(new IRule[rules.size()]));
        return scanner;
    }

    public XPathViewerConfiguration(CodeCapability contextAdapter, boolean syntaxColoringEnabled) {
        this.contextAdapter = contextAdapter;
        this.syntaxColoringEnabled = syntaxColoringEnabled && contextAdapter.getCodingStyleInfo() != CodeCapability.NONE;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant contentAssistant = new ContentAssistant();
        List<String> bindableParameters = this.getBindableParameters();
        if (this.contextAdapter.getCodingStyleInfo().supportEnsemblist()) {
            Collection keywords = (Collection)this.contextAdapter.getAdapter(Collection.class);
            if (keywords != null) {
                keywords.add("Intersect");
                keywords.add("Minus");
                keywords.add("Union");
                keywords.add("Union All");
                contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new EnsemblistCompletionProcessor(keywords), "__dftl_partition_content_type");
            }
        } else if (this.contextAdapter.getCodingStyleInfo().supportSQL()) {
            IRegistryService.IRegistry reg;
            AtomicReference<ISQLDictionary> dictionary = new AtomicReference<ISQLDictionary>((ISQLDictionary)this.contextAdapter.getAdapter(ISQLDictionary.class));
            CodeCapability.FunctionSupport functionSupports = (CodeCapability.FunctionSupport)this.contextAdapter.getAdapter(CodeCapability.FunctionSupport.class);
            ArrayList<String> l = new ArrayList<String>();
            if (this.contextAdapter.getCodingStyleInfo() == CodeCapability.MAPPING_SQL && (reg = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(UDF.class)) != null) {
                for (UDF udf : reg.getAll()) {
                    l.add(udf.getFunctionSignature());
                }
            }
            if (functionSupports == null) {
                functionSupports = new CodeCapability.StringListSupport(l);
            } else {
                for (String s : l) {
                    if (functionSupports.getAllFunctions().contains(s)) continue;
                    functionSupports.getAllFunctions().add(s);
                }
            }
            if (dictionary.get() != null) {
                p = new LightCompletionProcessor(dictionary.get(), functionSupports, bindableParameters);
                contentAssistant.setContentAssistProcessor((IContentAssistProcessor)p, "__dftl_partition_content_type");
            } else {
                dictionary.set((ISQLDictionary)new SQLDictionary());
                if (functionSupports != null && !functionSupports.getAllFunctions().isEmpty() || bindableParameters != null && !bindableParameters.isEmpty()) {
                    p = new LightCompletionProcessor(dictionary.get(), functionSupports, bindableParameters);
                    contentAssistant.setContentAssistProcessor((IContentAssistProcessor)p, "__dftl_partition_content_type");
                }
            }
        } else if (!bindableParameters.isEmpty()) {
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new BindableCompletionProcessor(bindableParameters), "__dftl_partition_content_type");
        }
        contentAssistant.setAutoActivationDelay(500);
        contentAssistant.enableAutoInsert(true);
        contentAssistant.enableAutoActivation(true);
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return contentAssistant;
    }

    private List<String> getBindableParameters() {
        Collection ad = (Collection)this.contextAdapter.getAdapter(BindLink.class);
        ArrayList<String> bindableParameters = new ArrayList<String>();
        if (ad != null && !ad.isEmpty()) {
            HashSet<Action> sources = new HashSet<Action>();
            for (BindLink b : ad) {
                if (!sources.add((Action)b.eContainer()) || !(b.eContainer() instanceof ActionCode) || ((ActionCode)b.eContainer()).getActionDefinition() == null || !((ActionCode)b.eContainer()).getActionDefinition().isBindableAsSource()) continue;
                for (ProcessToolDescriptor.BindVariableDescriptor p : ((ActionCode)b.eContainer()).getActionDefinition().getBindableVariable()) {
                    bindableParameters.add(p.getName());
                }
            }
        }
        return bindableParameters;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (!this.syntaxColoringEnabled) {
            return super.getPresentationReconciler(sourceViewer);
        }
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning("__dftl_partitioning");
        FullDocDamagerRepairer dr = new FullDocDamagerRepairer(this.getXPathScanner(), sourceViewer);
        reconciler.setRepairer((IPresentationRepairer)dr, PartitionerProvider.XPATH);
        reconciler.setDamager((IPresentationDamager)dr, PartitionerProvider.XPATH);
        dr = new FullDocDamagerRepairer(this.getXslScanner(), sourceViewer);
        reconciler.setRepairer((IPresentationRepairer)dr, PartitionerProvider.XSL);
        reconciler.setDamager((IPresentationDamager)dr, PartitionerProvider.XSL);
        dr = new FullDocDamagerRepairer(this.getSriptingScanner(), sourceViewer);
        reconciler.setRepairer((IPresentationRepairer)dr, PartitionerProvider.SCRIPTING);
        reconciler.setDamager((IPresentationDamager)dr, PartitionerProvider.SCRIPTING);
        if (this.contextAdapter.getCodingStyleInfo().supportSQL()) {
            final AtomicReference<ISQLDictionary> dictionary = new AtomicReference<ISQLDictionary>((ISQLDictionary)this.contextAdapter.getAdapter(ISQLDictionary.class));
            if (dictionary.get() == null) {
                dictionary.set((ISQLDictionary)new SQLDictionary());
            }
            SQLCodeScanner scanner = new SQLCodeScanner(dictionary.get()){

                protected synchronized List<IRule> createRules() {
                    List l = super.createRules();
                    l.add(new MdVariableRule());
                    l.add(new ParameterRule());
                    l.add(new BindingRule());
                    l.add(new MdVariableRule(){

                        @Override
                        public boolean known(String varName) {
                            ISQLDictionary.Item i = ((ISQLDictionary)dictionary.get()).getItem(varName);
                            if (i != null) {
                                return true;
                            }
                            return super.known(varName);
                        }
                    });
                    if (XPathViewerConfiguration.this.contextAdapter.getCodingStyleInfo() == CodeCapability.MAPPING_SQL) {
                        l.add(0, new UDFRule());
                    }
                    return l;
                }
            };
            FullDocDamagerRepairer sqlDr = new FullDocDamagerRepairer((ITokenScanner)scanner, sourceViewer);
            reconciler.setRepairer((IPresentationRepairer)sqlDr, "__dftl_partition_content_type");
            reconciler.setDamager((IPresentationDamager)sqlDr, "__dftl_partition_content_type");
        } else if (this.contextAdapter.getCodingStyleInfo().supportEnsemblist()) {
            Object scanner = null;
            Collection setNames = (Collection)this.contextAdapter.getAdapter(Collection.class);
            if (setNames != null) {
                scanner = new EnsemblistScanner(setNames);
            } else {
                scanner = new RuleBasedPartitionScanner();
                scanner.setRules(new IRule[]{new MdVariableRule(), new ParameterRule(), new BindingRule()});
            }
            dr = new FullDocDamagerRepairer((ITokenScanner)scanner, sourceViewer);
            reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
            reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        } else {
            RuleBasedScanner scanner = new RuleBasedScanner();
            scanner.setRules(new IRule[]{new MdVariableRule(), new ParameterRule(), new BindingRule()});
            dr = new FullDocDamagerRepairer((ITokenScanner)scanner, sourceViewer);
            reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
            reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        }
        return reconciler;
    }

    private ITokenScanner getSriptingScanner() {
        StateRuleBasedScanner scanner = new StateRuleBasedScanner();
        scanner.setRules(new IRule[]{new ScriptingRule(), new XPathRule()});
        return scanner;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__dftl_partitioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{PartitionerProvider.IGNORED, PartitionerProvider.XPATH, PartitionerProvider.XSL, "__dftl_partition_content_type"};
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{this.getAutoIndentStrategy(sourceViewer, contentType), new EnclosingAutoEditStrategy(sourceViewer)};
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            return null;
        }
        return new IHyperlinkDetector[]{new MdVariableHyperlinkDetector(this.contextAdapter)};
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        return new DefaultHyperlinkPresenter(new RGB(0, 0, 255));
    }

    private class FullDocDamagerRepairer
    extends DefaultDamagerRepairer {
        ISourceViewer sourceViewer;

        public FullDocDamagerRepairer(ITokenScanner scanner, ISourceViewer sourceViewer) {
            super(scanner);
            this.sourceViewer = sourceViewer;
        }

        public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
            Region r = new Region(0, e.fDocument.getLength());
            Iterator it = this.sourceViewer.getAnnotationModel().getAnnotationIterator();
            while (it.hasNext()) {
                Annotation a = (Annotation)it.next();
                Position p = this.sourceViewer.getAnnotationModel().getPosition(a);
                if (!p.overlapsWith(r.getOffset(), r.getLength())) continue;
                this.sourceViewer.getAnnotationModel().removeAnnotation(a);
                it.remove();
            }
            return r;
        }

        public void createPresentation(TextPresentation presentation, ITypedRegion region) {
            IToken token;
            Iterator it = this.sourceViewer.getAnnotationModel().getAnnotationIterator();
            while (it.hasNext()) {
                Annotation a = (Annotation)it.next();
                Position p = this.sourceViewer.getAnnotationModel().getPosition(a);
                if (!p.overlapsWith(region.getOffset(), region.getLength())) continue;
                this.sourceViewer.getAnnotationModel().removeAnnotation(a);
                it.remove();
            }
            if (this.fScanner == null) {
                this.addRange(presentation, region.getOffset(), region.getLength(), this.fDefaultTextAttribute);
                return;
            }
            int lastStart = region.getOffset();
            int length = 0;
            boolean firstToken = true;
            IToken lastToken = Token.UNDEFINED;
            TextAttribute lastAttribute = this.getTokenTextAttribute(lastToken);
            this.fScanner.setRange(this.fDocument, lastStart, region.getLength());
            while (!(token = this.fScanner.nextToken()).isEOF()) {
                String regionText;
                TextAttribute attribute = this.getTokenTextAttribute(token);
                if (lastAttribute != null && lastAttribute.equals((Object)attribute)) {
                    length += this.fScanner.getTokenLength();
                    firstToken = false;
                } else {
                    if (!firstToken) {
                        this.addRange(presentation, lastStart, length, lastAttribute);
                    }
                    firstToken = false;
                    lastToken = token;
                    lastAttribute = attribute;
                    lastStart = this.fScanner.getTokenOffset();
                    length = this.fScanner.getTokenLength();
                }
                if (token == MdVariableRule.token) {
                    try {
                        String s = this.fDocument.get(this.fScanner.getTokenOffset(), this.fScanner.getTokenLength());
                        String varName = s.substring(2, s.length() - 2);
                        CodeCapability.MdVariableResolver varResolver = (CodeCapability.MdVariableResolver)XPathViewerConfiguration.this.contextAdapter.getAdapter(CodeCapability.MdVariableResolver.class);
                        if (varResolver != null && !varResolver.canResolve(varName)) {
                            this.sourceViewer.getAnnotationModel().addAnnotation(new Annotation("ERROR_TYPE", false, Messages.XPathViewerConfiguration_1), new Position(lastStart, length));
                        }
                    }
                    catch (Exception s) {
                        // empty catch block
                    }
                    this.sourceViewer.getAnnotationModel().addAnnotation(new Annotation(XPathViewerConfiguration.ANNOTATION_VARIABLE_USAGE, false, "XXX"), new Position(lastStart, length));
                }
                if (token == ParameterRule.token) {
                    this.sourceViewer.getAnnotationModel().addAnnotation(new Annotation(XPathViewerConfiguration.ANNOTATION_VARIABLE_USAGE, false, "XXX"), new Position(lastStart, length));
                }
                if (token instanceof UDFRule.IUDFToken) {
                    this.sourceViewer.getAnnotationModel().addAnnotation(new Annotation(XPathViewerConfiguration.ANNOTATION_UDF_USAGE, false, ((UDFRule.IUDFToken)token).getUDF().getMdNodeSourceURI().toString()), new Position(lastStart, length));
                }
                if (token != STRING_TOKEN && attribute.getForeground() != com.indy.ui.sql.editors.configuration.ColorHelper.getColor((RGB)ColorHelper.XPATH_STRING) || !(regionText = this.sourceViewer.getTextWidget().getTextRange(lastStart, length)).contains("%{")) continue;
                Matcher m = PATTERN_VARIABLE.matcher(regionText);
                while (m.find()) {
                    this.sourceViewer.getAnnotationModel().addAnnotation(new Annotation(XPathViewerConfiguration.ANNOTATION_VARIABLE_USAGE, false, "XXX"), new Position(lastStart + m.start(0), m.end(0) - m.start(0)));
                }
            }
            this.addRange(presentation, lastStart, length, lastAttribute);
        }
    }

    private class WordDetector
    implements IWordDetector {
        private WordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        public boolean isWordStart(char c) {
            return c == '$';
        }
    }
}

