/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.build.utils;

import com.indy.libraries.build.parser.xsl.XslParser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private StringUtils() {
    }

    public static String prepareToParse1(String str) throws XslParser.XSLParseException {
        String middle;
        String start = "<indyParse:root xmlns:indyParse=\"http://www.stambia.com/indyParse\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xslo=\"http://www.example.org/xslo\" xmlns:saxono=\"http://www.example.org/saxono\">";
        String end = "</indyParse:root>";
        if (str != null && !str.isEmpty()) {
            XslParser parser = new XslParser(str);
            parser.parse();
            middle = parser.printXml();
        } else {
            middle = str;
        }
        return start + middle + end;
    }

    public static String encodeHexString(String sourceText, boolean replaceSpecialChar) {
        String tmp = null;
        if (replaceSpecialChar) {
            tmp = sourceText.replaceAll("\\\\n", "\n");
            tmp = tmp.replaceAll("\\\\t", "\t");
            tmp = tmp.replaceAll("\\\\r", "\r");
            tmp = tmp.replaceAll("\\\\f", "\f");
        } else {
            tmp = sourceText;
        }
        byte[] rawData = tmp.getBytes(StandardCharsets.UTF_8);
        StringBuilder hexText = new StringBuilder();
        String initialHex = null;
        int initHexLength = 0;
        int i = 0;
        while (i < rawData.length) {
            int positiveValue = rawData[i] & 0xFF;
            initialHex = Integer.toHexString(positiveValue);
            initHexLength = initialHex.length();
            while (initHexLength++ < 2) {
                hexText.append("0");
            }
            hexText.append(initialHex);
            ++i;
        }
        return hexText.toString().toUpperCase();
    }

    public static String decodeHexString(String hexa, boolean replaceSpecialChar) {
        if (hexa.length() % 2 == 0) {
            String txtInHex = hexa;
            byte[] txtInByte = new byte[txtInHex.length() / 2];
            int j = 0;
            int i = 0;
            while (i < txtInHex.length()) {
                txtInByte[j++] = (byte)Integer.parseInt(txtInHex.substring(i, i + 2), 16);
                i += 2;
            }
            String txt = new String(txtInByte, StandardCharsets.UTF_8);
            if (replaceSpecialChar) {
                StringBuilder result = new StringBuilder();
                int i2 = 0;
                while (i2 < txt.length()) {
                    if (txt.charAt(i2) == '\n') {
                        result.append("\\n");
                    } else if (txt.charAt(i2) == '\t') {
                        result.append("\\t");
                    } else if (txt.charAt(i2) == '\r') {
                        result.append("\\r");
                    } else if (txt.charAt(i2) == '\f') {
                        result.append("\\f");
                    } else {
                        result.append(txt.charAt(i2));
                    }
                    ++i2;
                }
                return result.toString();
            }
            return txt;
        }
        return "";
    }

    public static String[] motifList(String vExpression, String pattern) {
        if (vExpression != null) {
            Pattern pDeb = Pattern.compile(pattern);
            Matcher mDeb = pDeb.matcher(vExpression);
            ArrayList<String> vars = new ArrayList<String>();
            while (mDeb.find()) {
                int iDeb = mDeb.start();
                int iFin = mDeb.end();
                vars.add(vExpression.substring(iDeb + 1, iFin - 1));
            }
            String[] retour = new String[vars.size()];
            vars.toArray(retour);
            return retour;
        }
        return new String[0];
    }

    public static String replaceAll(String str, String target, String replacement) {
        String[] regexp = new String[]{target};
        String[] replace = new String[]{replacement};
        return StringUtils.replaceAll(str, regexp, replace);
    }

    public static String replaceAll(String src, String[] regexp, String[] replacement) {
        if (regexp.length == replacement.length) {
            Object retour = "";
            Object pattern = "";
            int i = 0;
            while (i < regexp.length) {
                pattern = (String)pattern + regexp[i];
                ++i;
            }
            Pattern pDeb = Pattern.compile((String)pattern);
            Matcher mDeb = pDeb.matcher(src);
            int lastFin = 0;
            while (mDeb.find()) {
                int iDeb = mDeb.start();
                int iFin = mDeb.end();
                retour = (String)retour + src.substring(lastFin, iDeb);
                String str = src.substring(iDeb, iFin);
                Object tmp = "";
                int i2 = 0;
                while (i2 < regexp.length) {
                    Matcher t = Pattern.compile(regexp[i2]).matcher(str);
                    t.find();
                    int size = t.end() - t.start();
                    if (size > 0) {
                        tmp = replacement[i2] == null || replacement[i2].equals("md:nullValue") ? (String)tmp + str.substring(t.start(), t.end()) : (String)tmp + replacement[i2];
                    }
                    str = str.substring(size);
                    ++i2;
                }
                retour = (String)retour + (String)tmp;
                lastFin = iFin;
            }
            retour = (String)retour + src.substring(lastFin, src.length());
            return retour;
        }
        return src;
    }
}

