/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.internal;

import com.indy.engine.core.IEngineClient;
import com.semarchy.xdi.designer.core.services.IEnvironmentConfiguration;
import com.semarchy.xdi.designer.core.services.IRuntimeService;
import com.semarchy.xdi.engine.common.EngineFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.URI;
import java.util.HashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={IRuntimeService.class}, scope=ServiceScope.SINGLETON)
public class RuntimeService
implements IRuntimeService {
    private static final String ERROR_MSG_UNEXPECTED = "Unexpected error";
    @Reference
    private IEnvironmentConfiguration environnentConfiguration;

    private IEngineClient createRuntimeConnection() throws IRuntimeService.RuntimeServiceException {
        IEnvironmentConfiguration.EngineConfiguration runtimeConfiguration = this.environnentConfiguration.getEngineConfiguration();
        HashMap<String, String> credentials = new HashMap<String, String>();
        if (runtimeConfiguration.getLogin() != null) {
            credentials.put("user", runtimeConfiguration.getLogin());
            credentials.put("password", runtimeConfiguration.getPassword());
        }
        try {
            Integer port = Integer.valueOf(runtimeConfiguration.getPort());
            return EngineFactory.getEngine((String)runtimeConfiguration.getHost(), (int)port, credentials).getRemoteObject();
        }
        catch (Exception ex) {
            throw new IRuntimeService.RuntimeServiceException("Connection failed", ex);
        }
    }

    public String prepareSession(URI deliveryURI) throws IRuntimeService.RuntimeServiceException {
        String sessionId = null;
        try {
            IEngineClient client = this.createRuntimeConnection();
            HashMap<String, String> parameters = new HashMap<String, String>();
            InetAddress localaddr = InetAddress.getLocalHost();
            String guestHost = localaddr.getHostName();
            parameters.put("guestHost", guestHost);
            parameters.put("launchMode", "DESIGNER");
            File file = new File(deliveryURI);
            parameters.put("fileName", file.getName());
            Throwable throwable = null;
            Object var9_12 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                sessionId = client.initSessionWithStream((Object)is, parameters);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return sessionId;
        }
        catch (IRuntimeService.RuntimeServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IRuntimeService.RuntimeServiceException(ERROR_MSG_UNEXPECTED, ex);
        }
    }

    public String runSession(URI deliveryURI) throws IRuntimeService.RuntimeServiceException {
        String sessionId = null;
        try {
            IEngineClient client = this.createRuntimeConnection();
            HashMap<String, String> parameters = new HashMap<String, String>();
            InetAddress localaddr = InetAddress.getLocalHost();
            String guestHost = localaddr.getHostName();
            parameters.put("guestHost", guestHost);
            parameters.put("launchMode", "DESIGNER");
            File file = new File(deliveryURI);
            parameters.put("fileName", file.getName());
            String version = client.getApiVersion();
            boolean executeCalled = false;
            if (version.compareTo("s20.2.0") >= 0) {
                parameters.put("executeAfterInit", Boolean.TRUE.toString());
                executeCalled = true;
            }
            Throwable throwable = null;
            Object var11_14 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                sessionId = client.initSessionWithStream((Object)is, parameters);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (!executeCalled) {
                client.executeSession(sessionId);
            }
            return sessionId;
        }
        catch (IRuntimeService.RuntimeServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IRuntimeService.RuntimeServiceException(ERROR_MSG_UNEXPECTED, ex);
        }
    }

    public void publish(URI deliveryURI, boolean asWebserice) throws IRuntimeService.RuntimeServiceException {
        try {
            IEngineClient client = this.createRuntimeConnection();
            HashMap<String, String> parameters = new HashMap<String, String>();
            File file = new File(deliveryURI);
            parameters.put("name", file.getName());
            if (asWebserice) {
                parameters.put("toDir", "wsdl");
            }
            Throwable throwable = null;
            Object var7_10 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                client.putDelivery((Object)is, parameters);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (asWebserice) {
                parameters = new HashMap();
                parameters.put("action", "build");
                client.soapServerAction(parameters);
            }
        }
        catch (IRuntimeService.RuntimeServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IRuntimeService.RuntimeServiceException(ERROR_MSG_UNEXPECTED, ex);
        }
    }
}

