/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.internal;

import com.indy.ui.build.Messages;
import com.indy.ui.build.internal.BuildUtil;
import com.indy.ui.build.internal.MessageConsoleRunnable;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.function.Consumer;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;

public class UILoggingConfiguration
implements IGenerationService.LoggingConfiguration {
    private int antLogLevel;
    PrintStream outputPrintStream;
    PrintStream errorPrintStream;

    UILoggingConfiguration(String actionType) {
        MessageConsole generationConsole = BuildUtil.findConsole(actionType);
        IOConsoleOutputStream outputStream = generationConsole.newOutputStream();
        this.outputPrintStream = new PrintStream((OutputStream)outputStream);
        this.errorPrintStream = new PrintStream((OutputStream)outputStream);
        this.antLogLevel = InstanceScope.INSTANCE.getNode("com.indy.ui.build").getInt("outputLevel", 4);
        if ("workspace.liteTransfo".equals(actionType)) {
            generationConsole.activate();
        }
    }

    public Writer createGenerationMessageWriter() {
        MessageConsole messageConsole = BuildUtil.findConsole(Messages.ExecuteAnt_55);
        return new OutputStreamWriter((OutputStream)messageConsole.newOutputStream());
    }

    public PrintStream getErrorPrintStream() {
        return this.outputPrintStream;
    }

    public PrintStream getOutputPrintStream() {
        return this.errorPrintStream;
    }

    public int getLogLevel() {
        return this.antLogLevel;
    }

    public Consumer<Exception> getExceptionHandler() {
        return MessageConsoleRunnable::logInConsole;
    }
}

