/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.internal;

import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.services.IXPathEvaluationService;
import com.semarchy.xdi.designer.core.utils.ParameterBuilder;
import com.semarchy.xdi.designer.generation.xsl.global.Variables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IXPathEvaluationService.class})
public class XPathEvaluationService
implements IXPathEvaluationService {
    @Reference
    private IGenerationService.ITaskSynchronizer taskSynchronizer;

    private InitializerFunction applyOption(Map<String, String> antOptions, IXPathEvaluationService.Option opt, String value) {
        if (opt.isRuntimeOption()) {
            return () -> {
                String string2 = Variables.getProperties().put(opt.getKey(), value);
            };
        }
        antOptions.put(opt.getKey(), value);
        return null;
    }

    public String evaluate(URI mdURI, String expression, ParameterBuilder<IXPathEvaluationService.Option, String> options) throws IGenerationService.SynchronizerBusyException {
        if (this.taskSynchronizer.isBusy()) {
            throw new IGenerationService.SynchronizerBusyException();
        }
        HashMap<String, String> antOptions = new HashMap<String, String>();
        antOptions.put("xPathExpression", expression);
        ArrayList functions = new ArrayList();
        if (options != null) {
            functions.addAll(options.geKeys().stream().filter(k -> k != null && options.get(k) != null).map(k -> this.applyOption((Map<String, String>)antOptions, (IXPathEvaluationService.Option)k, (String)options.get(k))).filter(f -> f != null).collect(Collectors.toList()));
        }
        IGenerationService.EnvironmentInitializer initializer = IGenerationService.EnvironmentInitializer.of(antOptions, () -> functions.stream().forEach(f -> f.init()));
        AtomicReference ref = new AtomicReference();
        this.taskSynchronizer.executeTask("workspace.liteTransfo", mdURI, initializer, (status, res) -> ref.set((String)res));
        return (String)ref.get();
    }

    private static interface InitializerFunction {
        public void init();
    }
}

