/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.launchers.navigator;

import com.indy.ui.build.launchers.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenActionProvider
extends CommonActionProvider {
    private boolean contribute = false;
    private ICommonViewerWorkbenchSite viewSite = null;
    private OpenFileAction openFileAction;

    public void init(ICommonActionExtensionSite aConfig) {
        if (aConfig.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.viewSite = (ICommonViewerWorkbenchSite)aConfig.getViewSite();
            this.openFileAction = new OpenFileAction(this.viewSite.getPage()){

                public void run() {
                    for (IResource resource : this.getSelectedResources()) {
                        if (!(resource instanceof IFile)) continue;
                        ILaunchConfiguration l = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration((IFile)resource);
                        DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)new StructuredSelection((Object)l), (String)"com.indy.ui.build.launchers.launchGroup2");
                        return;
                    }
                }
            };
            this.contribute = true;
        }
    }

    public void fillActionBars(IActionBars theActionBars) {
        if (!this.contribute) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof IFile) {
            this.openFileAction.selectionChanged(selection);
            theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openFileAction);
        }
    }

    public void fillContextMenu(IMenuManager aMenu) {
        if (!this.contribute || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.openFileAction.selectionChanged(selection);
        if (this.openFileAction.isEnabled()) {
            aMenu.insertAfter("group.open", (IAction)this.openFileAction);
        }
        if (!selection.isEmpty() && selection.getFirstElement() instanceof IFile) {
            MenuManager submenu = new MenuManager(Messages.OpenActionProvider_1, "org.eclipse.ui.OpenWithSubMenu");
            submenu.add((IContributionItem)new OpenWithMenu(this.viewSite.getPage(), (IAdaptable)((IFile)selection.getFirstElement())));
            aMenu.insertAfter(this.openFileAction.getId(), (IContributionItem)submenu);
        }
    }
}

