/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.build.launchers.ui.tabs;

import com.indy.ui.build.launchers.Messages;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class PackageOptionsTab
extends AbstractLaunchConfigurationTab {
    private final String SHARED_LAUNCH_CONFIGURATON_DIALOG = "org.eclipse.debug.ui.SHARED_LAUNCH_CONFIGURATON_DIALOG";
    private static final String BAD_CONTAINER = "bad_container_name";
    private Button fLocalRadioButton;
    private Button fSharedRadioButton;
    private Text fSharedLocationText;
    private Button fSharedLocationButton;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent evt) {
            PackageOptionsTab.this.scheduleUpdateJob();
        }
    };
    private Button includeSourcesBt;
    private Button defaultBt;
    private Button localBt;
    private Button wkspBt;
    private Button browseFS;
    private Button browseWks;
    private Button customName;
    private Text packageName;
    private Button generateDoc;
    private Text localFolder;
    private Text wksFolder;
    private Button analyticsPublication;
    private Text analyticsURL;
    private Text analyticsUser;
    private Text analyticsPassword;
    private IContainer folder;
    private boolean initializingUI = false;

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_OBJS_COMMON_TAB");
    }

    public String getId() {
        return "com.indy.ui.build.launchers.tab.main";
    }

    public void createOptions(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 1, true, false));
        comp.setLayout((Layout)new GridLayout(2, false));
        this.generateDoc = new Button(comp, 32);
        this.generateDoc.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.generateDoc.setText(Messages.PackageOptionsTab_1);
        this.generateDoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PackageOptionsTab.this.initializingUI) {
                    PackageOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.includeSourcesBt = new Button(comp, 32);
        this.includeSourcesBt.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.includeSourcesBt.setText(Messages.PackageOptionsTab_0);
        this.includeSourcesBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PackageOptionsTab.this.initializingUI) {
                    PackageOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Group outputFolderGroup = new Group(comp, 0);
        outputFolderGroup.setLayout((Layout)new GridLayout(3, false));
        outputFolderGroup.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        outputFolderGroup.setText(Messages.PackageOptionsTab_2);
        this.customName = new Button((Composite)outputFolderGroup, 32);
        this.customName.setText(Messages.PackageOptionsTab_3);
        this.customName.setLayoutData((Object)new GridData(1, 1, false, false));
        this.customName.setSelection(true);
        this.packageName = new Text((Composite)outputFolderGroup, 2048);
        this.packageName.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.packageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PackageOptionsTab.this.setDirty(true);
                PackageOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.customName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageOptionsTab.this.packageName.setEnabled(PackageOptionsTab.this.customName.getSelection());
                PackageOptionsTab.this.setDirty(true);
                PackageOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.defaultBt = new Button((Composite)outputFolderGroup, 16);
        this.defaultBt.setText(Messages.PackageOptionsTab_4);
        this.defaultBt.setLayoutData((Object)new GridData(1, 1, false, false, 3, 1));
        this.localBt = new Button((Composite)outputFolderGroup, 16);
        this.localBt.setText(Messages.PackageOptionsTab_5);
        this.localBt.setLayoutData((Object)new GridData(1, 1, false, false));
        this.localFolder = new Text((Composite)outputFolderGroup, 2048);
        this.localFolder.setLayoutData((Object)new GridData(4, 1, true, false));
        this.localFolder.setEnabled(false);
        this.browseFS = this.createPushButton((Composite)outputFolderGroup, Messages.PackageOptionsTab_6, null);
        this.browseFS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog d = new DirectoryDialog(PackageOptionsTab.this.getShell());
                d.setText(Messages.PackageOptionsTab_7);
                String base = PackageOptionsTab.this.localFolder.getText();
                d.setFilterPath(base);
                String s = d.open();
                if (s != null) {
                    PackageOptionsTab.this.localFolder.setText(s);
                    PackageOptionsTab.this.setDirty(true);
                    PackageOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.wkspBt = new Button((Composite)outputFolderGroup, 16);
        this.wkspBt.setText(Messages.PackageOptionsTab_8);
        this.wkspBt.setLayoutData((Object)new GridData(1, 1, false, false));
        this.wksFolder = new Text((Composite)outputFolderGroup, 2048);
        this.wksFolder.setLayoutData((Object)new GridData(4, 1, true, false));
        this.wksFolder.setEnabled(false);
        this.browseWks = this.createPushButton((Composite)outputFolderGroup, Messages.PackageOptionsTab_9, null);
        this.browseWks.setText(Messages.PackageOptionsTab_10);
        this.browseWks.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IContainer[] c = WorkspaceResourceDialog.openFolderSelection((Shell)PackageOptionsTab.this.getShell(), (String)Messages.PackageOptionsTab_11, (String)Messages.PackageOptionsTab_12, (boolean)false, (Object[])new IContainer[]{PackageOptionsTab.this.folder}, null);
                if (c != null && c.length != 0) {
                    PackageOptionsTab.this.folder = c[0];
                    PackageOptionsTab.this.wksFolder.setText(PackageOptionsTab.this.folder.getFullPath().toOSString());
                    PackageOptionsTab.this.setDirty(true);
                }
                PackageOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        Group publicationGroup = new Group(comp, 0);
        publicationGroup.setLayout((Layout)new GridLayout(3, false));
        publicationGroup.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        publicationGroup.setText(Messages.PackageOptionsTab_13);
        this.analyticsPublication = new Button((Composite)publicationGroup, 32);
        this.analyticsPublication.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        this.analyticsPublication.setText(Messages.PackageOptionsTab_14);
        Label l = new Label((Composite)publicationGroup, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.PackageOptionsTab_15);
        this.analyticsURL = new Text((Composite)publicationGroup, 2048);
        this.analyticsURL.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        l = new Label((Composite)publicationGroup, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.PackageOptionsTab_16);
        this.analyticsUser = new Text((Composite)publicationGroup, 2048);
        this.analyticsUser.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        l = new Label((Composite)publicationGroup, 0);
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.PackageOptionsTab_17);
        this.analyticsPassword = new Text((Composite)publicationGroup, 0x400800);
        this.analyticsPassword.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        ModifyListener txtListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!PackageOptionsTab.this.initializingUI) {
                    PackageOptionsTab.this.setDirty(true);
                    PackageOptionsTab.this.updateLaunchConfigurationDialog();
                }
            }
        };
        this.analyticsPassword.addModifyListener(txtListener);
        this.analyticsURL.addModifyListener(txtListener);
        this.analyticsUser.addModifyListener(txtListener);
        this.analyticsPublication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageOptionsTab.this.analyticsURL.setEnabled(PackageOptionsTab.this.analyticsPublication.getSelection());
                PackageOptionsTab.this.analyticsUser.setEnabled(PackageOptionsTab.this.analyticsPublication.getSelection());
                PackageOptionsTab.this.analyticsPassword.setEnabled(PackageOptionsTab.this.analyticsPublication.getSelection());
                PackageOptionsTab.this.setDirty(true);
                PackageOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.defaultBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageOptionsTab.this.browseFS.setEnabled(PackageOptionsTab.this.localBt.getSelection());
                PackageOptionsTab.this.browseWks.setEnabled(PackageOptionsTab.this.wkspBt.getSelection());
                PackageOptionsTab.this.setDirty(true);
                PackageOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.localBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageOptionsTab.this.browseFS.setEnabled(PackageOptionsTab.this.localBt.getSelection());
                PackageOptionsTab.this.browseWks.setEnabled(PackageOptionsTab.this.wkspBt.getSelection());
                PackageOptionsTab.this.setDirty(true);
                PackageOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.wkspBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageOptionsTab.this.browseFS.setEnabled(PackageOptionsTab.this.localBt.getSelection());
                PackageOptionsTab.this.browseWks.setEnabled(PackageOptionsTab.this.wkspBt.getSelection());
                PackageOptionsTab.this.setDirty(true);
                PackageOptionsTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        comp.setFont(parent.getFont());
        this.createOptions(comp);
        this.createSharedConfigComponent(comp);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setContainer(null);
        configuration.setAttribute("com.indy.launchers.attributes.hasDocumentation", true);
        configuration.setAttribute("com.indy.launchers.attributes.outputFolder", "");
    }

    public String getName() {
        return Messages.PackageOptionsTab_19;
    }

    private void createSharedConfigComponent(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.PackageOptionsTab_20, (int)3, (int)2, (int)768);
        Composite comp = SWTFactory.createComposite((Composite)group, (Font)parent.getFont(), (int)3, (int)3, (int)1808, (int)0, (int)0);
        this.fLocalRadioButton = this.createRadioButton(comp, LaunchConfigurationsMessages.CommonTab_L_ocal_3);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fLocalRadioButton.setLayoutData((Object)gd);
        this.fSharedRadioButton = this.createRadioButton(comp, LaunchConfigurationsMessages.CommonTab_S_hared_4);
        this.fSharedRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PackageOptionsTab.this.handleSharedRadioButtonSelected();
            }
        });
        this.fSharedLocationText = SWTFactory.createSingleText((Composite)comp, (int)1);
        this.fSharedLocationText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LaunchConfigurationsMessages.CommonTab_S_hared_4;
            }
        });
        this.fSharedLocationText.addModifyListener(this.fBasicModifyListener);
        this.fSharedLocationButton = this.createPushButton(comp, LaunchConfigurationsMessages.CommonTab__Browse_6, null);
        this.fSharedLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PackageOptionsTab.this.handleSharedLocationButtonSelected();
            }
        });
        this.fLocalRadioButton.setSelection(true);
        this.setSharedEnabled(false);
    }

    private void handleSharedRadioButtonSelected() {
        this.setSharedEnabled(this.isShared());
        this.updateLaunchConfigurationDialog();
    }

    private void setSharedEnabled(boolean enable) {
        this.fSharedLocationText.setEnabled(enable);
        this.fSharedLocationButton.setEnabled(enable);
    }

    private void handleSharedLocationButtonSelected() {
        String currentContainerString = this.fSharedLocationText.getText();
        IContainer currentContainer = this.getContainer(currentContainerString);
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), currentContainer, false, LaunchConfigurationsMessages.CommonTab_Select_a_location_for_the_launch_configuration_13);
        dialog.showClosedProjects(false);
        dialog.setDialogBoundsSettings(this.getDialogBoundsSettings("org.eclipse.debug.ui.SHARED_LAUNCH_CONFIGURATON_DIALOG"), 2);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.toOSString();
            this.fSharedLocationText.setText(containerName);
        }
    }

    IDialogSettings getDialogBoundsSettings(String id) {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(id);
        if (section == null) {
            section = settings.addNewSection(id);
        }
        return section;
    }

    private IContainer getContainer(String path) {
        Path containerPath = new Path(path);
        return (IContainer)this.getWorkspaceRoot().findMember((IPath)containerPath);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setMessage(null);
        this.setErrorMessage(null);
        return this.validateLocalShared() && this.validateCommon();
    }

    private boolean validateCommon() {
        if (this.defaultBt.getSelection()) {
            return true;
        }
        if (this.localBt.getSelection()) {
            File f = new File(this.localFolder.getText());
            if (!f.isAbsolute()) {
                this.setErrorMessage(Messages.PackageOptionsTab_21);
                return false;
            }
        } else if (this.wkspBt.getSelection() && this.folder == null) {
            this.setErrorMessage(Messages.PackageOptionsTab_22);
            return false;
        }
        if (this.customName.getSelection() && !this.packageName.getText().matches("[a-zA-Z0-9_]+")) {
            this.setErrorMessage(Messages.PackageOptionsTab_24);
            return false;
        }
        return true;
    }

    private boolean validateLocalShared() {
        if (this.isShared()) {
            String path = this.fSharedLocationText.getText().trim();
            IContainer container = this.getContainer(path);
            if (container == null || container.equals((Object)ResourcesPlugin.getWorkspace().getRoot())) {
                this.setErrorMessage(LaunchConfigurationsMessages.CommonTab_Invalid_shared_configuration_location_14);
                return false;
            }
            if (!container.getProject().isOpen()) {
                this.setErrorMessage(LaunchConfigurationsMessages.CommonTab_Cannot_save_launch_configuration_in_a_closed_project__1);
                return false;
            }
        }
        return true;
    }

    private boolean isShared() {
        return this.fSharedRadioButton.getSelection();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initializingUI = true;
        try {
            Boolean generateDoc = configuration.getAttribute("com.indy.launchers.attributes.hasDocumentation", Boolean.TRUE.booleanValue());
            this.generateDoc.setSelection(generateDoc.booleanValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("com.indy.ui.build");
            Boolean includeSrc = configuration.getAttribute("com.indy.launchers.attributes.includeSources", pref.getBoolean("package.generation.includeSources", false));
            this.includeSourcesBt.setSelection(includeSrc.booleanValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            String name = configuration.getAttribute("com.indy.launchers.attributes.outputName", "");
            if (name.equals("")) {
                this.packageName.setText("");
                this.packageName.setEnabled(false);
                this.customName.setSelection(false);
            } else {
                this.packageName.setText(name);
                this.packageName.setEnabled(true);
                this.customName.setSelection(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            String outputFolder = configuration.getAttribute("com.indy.launchers.attributes.outputFolder", "");
            String outputMode = configuration.getAttribute("com.indy.launchers.attributes.outputMode", "");
            if (outputMode.isEmpty()) {
                this.defaultBt.setSelection(true);
                this.localBt.setSelection(false);
                this.wkspBt.setSelection(false);
                this.folder = null;
                this.wksFolder.setText("");
                this.localFolder.setText("");
                this.browseFS.setEnabled(false);
                this.browseWks.setEnabled(false);
            } else if (outputMode.equals("fileSystem")) {
                this.defaultBt.setSelection(false);
                this.localBt.setSelection(true);
                this.wkspBt.setSelection(false);
                this.folder = null;
                this.wksFolder.setText("");
                this.localFolder.setText(outputFolder);
                this.browseFS.setEnabled(true);
                this.browseWks.setEnabled(false);
            } else if (outputMode.equals("workspace")) {
                this.defaultBt.setSelection(false);
                this.localBt.setSelection(false);
                this.wkspBt.setSelection(true);
                this.folder = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(outputFolder));
                this.wksFolder.setText(outputFolder);
                this.localFolder.setText("");
                this.browseFS.setEnabled(false);
                this.browseWks.setEnabled(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            boolean publish = configuration.getAttribute("com.indy.launchers.attributes.analytics.publish", false);
            this.analyticsPublication.setSelection(publish);
            String s = configuration.getAttribute("com.indy.launchers.attributes.analytics.http.url", "");
            this.analyticsURL.setText(s);
            this.analyticsURL.setEnabled(publish);
            s = configuration.getAttribute("com.indy.launchers.attributes.analytics.http.user", "");
            this.analyticsUser.setText(s);
            this.analyticsUser.setEnabled(publish);
            s = configuration.getAttribute("com.indy.launchers.attributes.analytics.http.password", "");
            this.analyticsPassword.setText(s);
            this.analyticsPassword.setEnabled(publish);
        }
        catch (Exception publish) {
            // empty catch block
        }
        this.setDirty(false);
        this.initializingUI = false;
        boolean isShared = !configuration.isLocal();
        this.fSharedRadioButton.setSelection(isShared);
        this.fLocalRadioButton.setSelection(!isShared);
        this.setSharedEnabled(isShared);
        this.fSharedLocationText.setText(this.getDefaultSharedConfigLocation(configuration));
        if (isShared) {
            IContainer parent;
            String containerName = "";
            IFile file = configuration.getFile();
            if (file != null && (parent = file.getParent()) != null) {
                containerName = parent.getFullPath().toOSString();
            }
            this.fSharedLocationText.setText(containerName);
        }
    }

    private String getDefaultSharedConfigLocation(ILaunchConfiguration config) {
        String path = "";
        try {
            IResource[] res = config.getMappedResources();
            if (res != null) {
                int i = 0;
                while (i < res.length) {
                    IProject proj = res[i].getProject();
                    if (proj != null && proj.isAccessible()) {
                        return proj.getFullPath().toOSString();
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log((Throwable)e);
        }
        return path;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.indy.launchers.attributes.hasDocumentation", this.generateDoc.getSelection());
        configuration.setAttribute("com.indy.launchers.attributes.includeSources", this.includeSourcesBt.getSelection());
        if (this.defaultBt.getSelection()) {
            configuration.setAttribute("com.indy.launchers.attributes.outputFolder", "");
            configuration.setAttribute("com.indy.launchers.attributes.outputMode", "");
        } else if (this.wkspBt.getSelection()) {
            configuration.setAttribute("com.indy.launchers.attributes.outputMode", "workspace");
            configuration.setAttribute("com.indy.launchers.attributes.outputFolder", this.wksFolder.getText());
        } else if (this.localBt.getSelection()) {
            configuration.setAttribute("com.indy.launchers.attributes.outputFolder", this.localFolder.getText());
            configuration.setAttribute("com.indy.launchers.attributes.outputMode", "fileSystem");
        }
        if (this.customName.getSelection()) {
            configuration.setAttribute("com.indy.launchers.attributes.outputName", this.packageName.getText());
        } else {
            configuration.setAttribute("com.indy.launchers.attributes.outputName", "");
        }
        if (this.analyticsPublication.getSelection()) {
            configuration.setAttribute("com.indy.launchers.attributes.analytics.publish", true);
            configuration.setAttribute("com.indy.launchers.attributes.analytics.http.password", this.analyticsPassword.getText());
            configuration.setAttribute("com.indy.launchers.attributes.analytics.http.url", this.analyticsURL.getText());
            configuration.setAttribute("com.indy.launchers.attributes.analytics.http.user", this.analyticsUser.getText());
        } else {
            configuration.setAttribute("com.indy.launchers.attributes.analytics.publish", false);
            configuration.setAttribute("com.indy.launchers.attributes.analytics.http.password", "");
            configuration.setAttribute("com.indy.launchers.attributes.analytics.http.url", "");
            configuration.setAttribute("com.indy.launchers.attributes.analytics.http.user", "");
        }
        if (this.isShared()) {
            String containerPathString = this.fSharedLocationText.getText();
            IContainer container = this.getContainer(containerPathString);
            if (container == null) {
                configuration.setAttribute(BAD_CONTAINER, containerPathString);
            } else {
                configuration.setContainer(container);
            }
        } else {
            configuration.setContainer(null);
        }
    }
}

