/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.action.common;

import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.engine.common.exceptions.SecretStatementException;

public class SecretValueManager {
    private SecretContextImpl secretContext = new SecretContextImpl();

    public <T> T secret(ISecretStatement<T> secret) throws EngineExceptionI {
        try {
            return this.secretContext.execute(secret);
        }
        catch (SecretStatementException e) {
            throw new EngineExceptionI(e.getMessage());
        }
        catch (Throwable e) {
            throw new EngineExceptionI(e);
        }
    }

    class SecretContextImpl
    implements ISecretContext {
        boolean secretValue;

        SecretContextImpl() {
        }

        @Override
        public boolean hasSecretValue() {
            return this.secretValue;
        }

        <T> T execute(ISecretStatement<T> st) throws Throwable {
            try {
                return st.execute(this);
            }
            catch (Throwable e) {
                if (this.secretValue) {
                    throw new SecretStatementException();
                }
                throw e;
            }
        }
    }
}

