/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core;

import com.indy.engine.core.IDecryptService;
import com.indy.engine.core.IJsonUtils;
import com.indy.engine.core.ISecretService;
import com.indy.engine.core.IXmlUtils;
import com.indy.engine.core.Messages;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.runtime.json.impl.JsonUtilsService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class UtilsService {
    static IXmlUtils xmlUtilsService;
    static IJsonUtils jsonUtilsService;
    static ISecretService secretService;
    static Map<String, IDecryptService> decryptServiceMap;

    static {
        decryptServiceMap = new HashMap<String, IDecryptService>();
    }

    private UtilsService() {
    }

    private static <T> T loadFirstService(Class<T> classS, ClassLoader cl) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(classS, cl);
        Iterator<T> it = serviceLoader.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static void initUtils(Map<Class, ClassLoader> classLoaderPerService) {
        xmlUtilsService = UtilsService.loadFirstService(IXmlUtils.class, classLoaderPerService.get(IXmlUtils.class));
        jsonUtilsService = UtilsService.loadFirstService(IJsonUtils.class, classLoaderPerService.get(IJsonUtils.class));
        secretService = UtilsService.loadFirstService(ISecretService.class, classLoaderPerService.get(ISecretService.class));
        ClassLoader cl = classLoaderPerService.get(IDecryptService.class);
        ServiceLoader<IDecryptService> serviceLoader = ServiceLoader.load(IDecryptService.class, cl);
        Iterator<IDecryptService> it = serviceLoader.iterator();
        if (it.hasNext()) {
            IDecryptService s = it.next();
            decryptServiceMap.put(s.getName(), s);
        }
    }

    public static IXmlUtils getXmlUtils() throws Exception {
        if (xmlUtilsService == null) {
            ClassLoader cl = ClassLoaderServiceProvider.instance().getClassLoader("internal");
            ServiceLoader<IXmlUtils> serviceLoader = ServiceLoader.load(IXmlUtils.class, cl);
            Iterator<IXmlUtils> it = serviceLoader.iterator();
            if (it.hasNext()) {
                xmlUtilsService = it.next();
            } else {
                throw new RuntimeException(Messages.getString("UtilsService.0"));
            }
        }
        return xmlUtilsService;
    }

    public static IJsonUtils getJsonUtils() throws Exception {
        if (jsonUtilsService == null) {
            ClassLoader cl = ClassLoaderServiceProvider.instance().getClassLoader("internal");
            ServiceLoader<IJsonUtils> serviceLoader = ServiceLoader.load(IJsonUtils.class, cl);
            Iterator<IJsonUtils> it = serviceLoader.iterator();
            if (it.hasNext()) {
                jsonUtilsService = it.next();
            } else {
                throw new RuntimeException(Messages.getString("UtilsService.1"));
            }
        }
        return jsonUtilsService;
    }

    public static ISecretService getSecretService() throws Exception {
        if (secretService == null) {
            ClassLoader cl = ClassLoaderServiceProvider.instance().getClassLoader("internal");
            ServiceLoader<ISecretService> serviceLoader = ServiceLoader.load(ISecretService.class, cl);
            Iterator<ISecretService> it = serviceLoader.iterator();
            if (it.hasNext()) {
                secretService = it.next();
            } else {
                throw new RuntimeException(Messages.getString("UtilsService.3"));
            }
        }
        return secretService;
    }

    public static IDecryptService getDecryptService(String name) throws Exception {
        IDecryptService decryptService = decryptServiceMap.get(name);
        if (decryptService == null) {
            IDecryptService service;
            ClassLoader cl = ClassLoaderServiceProvider.instance().getClassLoader("internal");
            ServiceLoader<IDecryptService> serviceLoader = ServiceLoader.load(IDecryptService.class, cl);
            Iterator<IDecryptService> it = serviceLoader.iterator();
            if (it.hasNext() && decryptServiceMap.get((service = it.next()).getName()) == null) {
                decryptServiceMap.put(service.getName(), service);
            }
            if ((decryptService = decryptServiceMap.get(name)) != null) {
                return decryptService;
            }
            throw new RuntimeException(Messages.getString("UtilsService.2"));
        }
        return decryptService;
    }

    public static void setDefaultUtilsService() {
        jsonUtilsService = new JsonUtilsService();
    }
}

