/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.actionCodes.convert;

import com.indy.engine.core.actionCodes.convert.AbstractParser;
import com.indy.engine.core.actionCodes.convert.ResultSetCellReader;
import com.indy.engine.core.api.impl.CellMapProperties;
import com.indy.engine.core.api.impl.jdbc.JdbcReaderProperties;
import com.indy.engine.core.api.impl.jdbc.JdbcWriterProperties;
import com.indy.runtime.api.ICellReader;
import com.indy.runtime.api.ICellWriter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class JdbcConverter
extends JdbcWriterProperties {
    public static final int TYPE_ORACLE_BINARY_FLOAT = 100;
    public static final int TYPE_ORACLE_BINARY_DOUBLE = 101;

    public static void convertBoolean(PreparedStatement stmt, int nColumn, boolean b, boolean wasNull, int targetColType, JdbcWriterProperties conv) throws SQLException {
        if (conv != null && conv.isDisableImplicitConversion()) {
            targetColType = 1111;
        }
        if (wasNull) {
            stmt.setNull(nColumn, targetColType);
            return;
        }
        JdbcConverter.setBooleanInStatement(stmt, nColumn, targetColType, b, conv);
    }

    private static void setBooleanInStatement(PreparedStatement stmt, int nColumn, int targetColType, boolean value, JdbcWriterProperties conv) throws SQLException {
        String trueStringValue = conv != null ? conv.getBooleanTrueStringValue() : "1";
        String falseStringValue = conv != null ? conv.getBooleanFalseStringValue() : "0";
        switch (targetColType) {
            case -7: 
            case 16: {
                stmt.setBoolean(nColumn, value);
                break;
            }
            case 4: {
                stmt.setInt(nColumn, value ? 1 : 0);
                break;
            }
            case -6: {
                stmt.setByte(nColumn, value ? (byte)1 : 0);
                break;
            }
            case 5: {
                stmt.setShort(nColumn, value ? (short)1 : 0);
                break;
            }
            case -5: {
                stmt.setLong(nColumn, value ? 1L : 0L);
                break;
            }
            case 7: {
                stmt.setFloat(nColumn, value ? 1.0f : 0.0f);
                break;
            }
            case 6: 
            case 8: {
                stmt.setDouble(nColumn, value ? 1.0 : 0.0);
                break;
            }
            case 2: 
            case 3: {
                stmt.setBigDecimal(nColumn, new BigDecimal(value ? 1 : 0));
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                if (conv == null || !conv.isNVarcharAsVarchar()) {
                    stmt.setNString(nColumn, value ? trueStringValue : falseStringValue);
                    break;
                }
                stmt.setString(nColumn, value ? trueStringValue : falseStringValue);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                stmt.setString(nColumn, value ? trueStringValue : falseStringValue);
                break;
            }
            default: {
                stmt.setBoolean(nColumn, value);
            }
        }
    }

    public static void convertString(PreparedStatement stmt, int nColumn, String str, int targetColType, boolean nString, JdbcWriterProperties conv) throws SQLException {
        if (conv != null && conv.isDisableImplicitConversion()) {
            targetColType = 1111;
        }
        if (str == null) {
            stmt.setNull(nColumn, targetColType);
            return;
        }
        try {
            block1 : switch (targetColType) {
                case 16: {
                    switch (str) {
                        case "1": 
                        case "T": 
                        case "Y": 
                        case "true": {
                            stmt.setBoolean(nColumn, true);
                            break block1;
                        }
                        case "0": 
                        case "F": 
                        case "N": 
                        case "false": {
                            stmt.setBoolean(nColumn, false);
                            break block1;
                        }
                    }
                    throw new SQLException("Error value " + str + "is not a boolean value");
                }
                case 4: {
                    stmt.setInt(nColumn, Integer.valueOf(str));
                    break;
                }
                case 5: {
                    stmt.setShort(nColumn, Short.valueOf(str));
                    break;
                }
                case -6: {
                    stmt.setByte(nColumn, Byte.valueOf(str));
                    break;
                }
                case 2: 
                case 3: {
                    stmt.setBigDecimal(nColumn, new BigDecimal(str));
                    break;
                }
                default: {
                    if (nString && (conv == null || !conv.isNVarcharAsVarchar())) {
                        stmt.setNString(nColumn, str);
                        break;
                    }
                    stmt.setString(nColumn, str);
                    break;
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private static void setNumberInStatement(PreparedStatement stmt, int nColumn, Number i, boolean wasNull, int targetColType, JdbcWriterProperties conv, Function defaultFunction) throws SQLException {
        if (conv != null && conv.isDisableImplicitConversion()) {
            targetColType = 1111;
        }
        if (wasNull || i == null) {
            stmt.setNull(nColumn, targetColType);
            return;
        }
        switch (targetColType) {
            case -7: 
            case 16: {
                long val = i.longValue();
                if (val == 0L) {
                    stmt.setBoolean(nColumn, false);
                    break;
                }
                if (val == 1L) {
                    stmt.setBoolean(nColumn, true);
                    break;
                }
                throw new SQLException("Error value " + val + "is not a boolean value");
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                stmt.setString(nColumn, i.toString());
                break;
            }
            case 4: {
                stmt.setInt(nColumn, i.intValue());
                break;
            }
            case -6: {
                stmt.setByte(nColumn, i.byteValue());
                break;
            }
            case 5: {
                stmt.setShort(nColumn, i.shortValue());
                break;
            }
            case -5: {
                stmt.setLong(nColumn, i.longValue());
                break;
            }
            case 7: {
                stmt.setFloat(nColumn, i.floatValue());
                break;
            }
            case 6: 
            case 8: {
                stmt.setDouble(nColumn, JdbcConverter.getDoubleFromNumber(i));
                break;
            }
            case 2: 
            case 3: {
                stmt.setBigDecimal(nColumn, new BigDecimal(i.toString()));
                break;
            }
            default: {
                defaultFunction.apply();
            }
        }
    }

    private static double getDoubleFromNumber(Number i) {
        if (i instanceof Double || i instanceof BigDecimal) {
            return i.doubleValue();
        }
        BigDecimal bd = new BigDecimal(i.toString());
        return bd.doubleValue();
    }

    public static void convertInteger(PreparedStatement stmt, int nColumn, int i, boolean wasNull, int targetColType, JdbcWriterProperties conv) throws SQLException {
        JdbcConverter.setNumberInStatement(stmt, nColumn, i, wasNull, targetColType, conv, () -> stmt.setInt(nColumn, i));
    }

    public static void convertShort(PreparedStatement stmt, int nColumn, short i, boolean wasNull, int targetColType, JdbcWriterProperties conv) throws SQLException {
        JdbcConverter.setNumberInStatement(stmt, nColumn, i, wasNull, targetColType, conv, () -> stmt.setShort(nColumn, i));
    }

    public static void convertLong(PreparedStatement stmt, int nColumn, long i, boolean wasNull, int targetColType, JdbcWriterProperties conv) throws SQLException {
        JdbcConverter.setNumberInStatement(stmt, nColumn, i, wasNull, targetColType, conv, () -> stmt.setLong(nColumn, i));
    }

    public static void convertDouble(PreparedStatement stmt, int nColumn, double i, boolean wasNull, int targetColType, JdbcWriterProperties conv) throws SQLException {
        JdbcConverter.setNumberInStatement(stmt, nColumn, i, wasNull, targetColType, conv, () -> stmt.setDouble(nColumn, i));
    }

    public static void convertFloat(PreparedStatement stmt, int nColumn, float i, boolean wasNull, int targetColType, JdbcWriterProperties conv) throws SQLException {
        JdbcConverter.setNumberInStatement(stmt, nColumn, Float.valueOf(i), wasNull, targetColType, conv, () -> stmt.setFloat(nColumn, i));
    }

    public static void convertNumber(PreparedStatement stmt, int nColumn, Number i, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
        JdbcConverter.setNumberInStatement(stmt, nColumn, i, wasNull, targetColType, converter, () -> stmt.setBigDecimal(nColumn, new BigDecimal(i.toString())));
    }

    public static void convertTimeStamp(PreparedStatement stmt, int nColumn, Timestamp ts, int targetColType, JdbcWriterProperties converter) throws SQLException {
        if (converter != null && converter.isDisableImplicitConversion()) {
            targetColType = 1111;
        }
        if (ts == null) {
            stmt.setNull(nColumn, targetColType);
            return;
        }
        switch (targetColType) {
            case 91: {
                stmt.setDate(nColumn, new Date(ts.getTime()));
                break;
            }
            case 92: {
                stmt.setTime(nColumn, new Time(ts.getTime()));
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                stmt.setString(nColumn, ts.toString());
                break;
            }
            default: {
                stmt.setTimestamp(nColumn, ts);
            }
        }
    }

    public static void convertDate(PreparedStatement stmt, int nColumn, Date dt, int targetColType, JdbcWriterProperties conv) throws SQLException {
        if (conv != null && conv.isDisableImplicitConversion()) {
            targetColType = 1111;
        }
        if (dt == null) {
            stmt.setNull(nColumn, targetColType);
            return;
        }
        switch (targetColType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                stmt.setString(nColumn, dt.toString());
                break;
            }
            default: {
                if (targetColType == 93 || conv != null && conv.isDateAsTimestamp()) {
                    stmt.setTimestamp(nColumn, new Timestamp(dt.getTime()));
                    break;
                }
                stmt.setDate(nColumn, dt);
            }
        }
    }

    public static void setJavaObjectToJdbc(PreparedStatement ps, ParameterMetaData metadata, int index, Object value, AbstractParser parser, JdbcWriterProperties conv) throws SQLException {
        int targetColType = 1111;
        if (metadata != null) {
            try {
                targetColType = metadata.getParameterType(index);
            }
            catch (Exception e) {
                targetColType = 1111;
            }
        }
        JdbcConverter.setJavaObjectToJdbc(ps, targetColType, index, value, parser, conv);
    }

    public static void setJavaObjectToJdbc(PreparedStatement ps, int targetColType, int index, Object value, JdbcWriterProperties conv) throws SQLException {
        if (value == null) {
            ps.setNull(index, targetColType);
            return;
        }
        if (value instanceof String) {
            JdbcConverter.convertString(ps, index, (String)value, targetColType, false, conv);
        } else if (value instanceof Timestamp) {
            JdbcConverter.convertTimeStamp(ps, index, (Timestamp)value, targetColType, conv);
        } else if (value instanceof Time) {
            JdbcConverter.convertTime(ps, index, (Time)value, targetColType);
        } else if (value instanceof Date) {
            JdbcConverter.convertDate(ps, index, (Date)value, targetColType, conv);
        } else if (value instanceof Boolean) {
            JdbcConverter.convertBoolean(ps, index, (Boolean)value, false, targetColType, conv);
        } else if (value instanceof Double) {
            JdbcConverter.convertDouble(ps, index, (Double)value, false, targetColType, conv);
        } else if (value instanceof Integer) {
            JdbcConverter.convertInteger(ps, index, (Integer)value, false, targetColType, conv);
        } else if (value instanceof BigInteger) {
            JdbcConverter.convertNumber(ps, index, (BigInteger)value, false, targetColType, conv);
        } else if (value instanceof BigDecimal) {
            JdbcConverter.convertNumber(ps, index, (BigDecimal)value, false, targetColType, conv);
        } else {
            JdbcConverter.convertObject(ps, index, value, targetColType);
        }
    }

    public static void setJavaObjectToJdbc(PreparedStatement ps, ParameterMetaData metadata, int index, Object value, JdbcWriterProperties conv) throws SQLException {
        int targetColType = 1111;
        if (metadata != null) {
            try {
                targetColType = metadata.getParameterType(index);
            }
            catch (Exception e) {
                targetColType = 1111;
            }
        }
        JdbcConverter.setJavaObjectToJdbc(ps, targetColType, index, value, conv);
    }

    public static void convertTime(PreparedStatement stmt, int nColumn, Time time, Integer targetColType) throws SQLException {
        if (time == null) {
            stmt.setNull(nColumn, targetColType);
            return;
        }
        switch (targetColType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                stmt.setString(nColumn, time.toString());
                break;
            }
            default: {
                stmt.setTime(nColumn, time);
            }
        }
    }

    public static void convertClob(PreparedStatement stmt, int nColumn, Clob clob, Integer targetColType) throws SQLException {
        if (clob == null) {
            stmt.setNull(nColumn, targetColType);
            return;
        }
        try {
            stmt.setCharacterStream(nColumn, clob.getCharacterStream());
        }
        catch (SQLException e) {
            String tmp = clob.getSubString(1L, (int)clob.length());
            stmt.setString(nColumn, tmp);
        }
    }

    public static void convertNClob(PreparedStatement stmt, int nColumn, NClob clob, Integer targetColType) throws SQLException {
        if (clob == null) {
            stmt.setNull(nColumn, targetColType);
            return;
        }
        try {
            stmt.setNCharacterStream(nColumn, clob.getCharacterStream());
        }
        catch (SQLException e) {
            String tmp = clob.getSubString(1L, (int)clob.length());
            stmt.setNString(nColumn, tmp);
        }
    }

    public static void convertBlob(PreparedStatement stmt, int nColumn, Blob blob, Integer targetColType) throws SQLException {
        if (blob == null) {
            stmt.setNull(nColumn, targetColType);
            return;
        }
        try {
            stmt.setBinaryStream(nColumn, blob.getBinaryStream());
        }
        catch (SQLException e) {
            stmt.setBytes(nColumn, blob.getBytes(1L, (int)blob.length()));
        }
    }

    public static void convertBytes(PreparedStatement stmt, int nColumn, byte[] bytes, Integer targetColType) throws SQLException {
        if (bytes == null) {
            stmt.setNull(nColumn, targetColType);
        } else {
            stmt.setBytes(nColumn, bytes);
        }
    }

    public static void convertObject(PreparedStatement stmt, int nColumn, Object object, Integer targetColType) throws SQLException {
        if (object == null) {
            stmt.setNull(nColumn, targetColType);
        } else {
            stmt.setObject(nColumn, object, targetColType);
        }
    }

    public static void convertByte(PreparedStatement ps, int index, Byte value, boolean wasNull, int targetColType) throws SQLException {
        if (wasNull) {
            ps.setNull(index, targetColType);
        } else {
            ps.setByte(index, value);
        }
    }

    public static void setJavaObjectToJdbc(PreparedStatement ps, int targetColType, int index, Object value, AbstractParser parser, JdbcWriterProperties conv) throws SQLException {
        if (value == null) {
            ps.setNull(index, targetColType);
        } else {
            parser.setJdbcStatement(ps, index, value, false, targetColType, conv);
        }
    }

    public static ICellReader<ResultSet> getResultSetCellReader(CellMapProperties mapProperties, JdbcReaderProperties sourceProperties) throws Exception {
        return (ICellReader)JdbcConverter.getReadWrite(true, mapProperties, sourceProperties, null);
    }

    public static ICellWriter<PreparedStatement> getPreparedStatementCellWriter(CellMapProperties mapProperties, JdbcWriterProperties targetProperties) throws Exception {
        return (ICellWriter)JdbcConverter.getReadWrite(false, mapProperties, null, targetProperties);
    }

    private static Object getReadWrite(boolean reader, final CellMapProperties mapProperties, final JdbcReaderProperties sourceProperties, final JdbcWriterProperties targetProperties) throws Exception {
        try {
            switch (mapProperties.sourceType) {
                case -7: 
                case 16: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> resultSet.getBoolean(cellMapProperties.sourceIndex));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertBoolean(statement, mapProperties.targetIndex, Boolean.TRUE == value, value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case -16: 
                case -15: 
                case -9: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getNString(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertString(statement, mapProperties.targetIndex, (String)value, mapProperties.targetType, true, targetProperties);
                        }
                    };
                }
                case -1: 
                case 1: 
                case 12: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getString(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertString(statement, mapProperties.targetIndex, (String)value, mapProperties.targetType, false, targetProperties);
                        }
                    };
                }
                case 91: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                if (!sourceProperties.isDateAsTimestamp()) {
                                    return resultSet.getDate(mapProperties.sourceIndex);
                                }
                                return resultSet.getTimestamp(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            if (sourceProperties != null) {
                                if (sourceProperties.isDateAsTimestamp()) {
                                    JdbcConverter.convertTimeStamp(statement, mapProperties.targetIndex, (Timestamp)value, mapProperties.targetType, targetProperties);
                                } else {
                                    JdbcConverter.convertDate(statement, mapProperties.targetIndex, (Date)value, mapProperties.targetType, targetProperties);
                                }
                            } else if (value instanceof Timestamp) {
                                JdbcConverter.convertTimeStamp(statement, mapProperties.targetIndex, (Timestamp)value, mapProperties.targetType, targetProperties);
                            } else {
                                JdbcConverter.convertDate(statement, mapProperties.targetIndex, (Date)value, mapProperties.targetType, targetProperties);
                            }
                        }
                    };
                }
                case 92: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getTime(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertTime(statement, mapProperties.targetIndex, (Time)value, mapProperties.targetType);
                        }
                    };
                }
                case 93: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getTimestamp(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertTimeStamp(statement, mapProperties.targetIndex, (Timestamp)value, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 2: 
                case 3: {
                    if (reader) {
                        return new ICellReader<ResultSet>(){

                            @Override
                            public Object read(ResultSet resultSet) throws SQLException {
                                return resultSet.getBigDecimal(mapProperties.sourceIndex);
                            }
                        };
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertNumber(statement, mapProperties.targetIndex, (Number)value, false, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 6: 
                case 8: 
                case 101: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> resultSet.getDouble(cellMapProperties.sourceIndex));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertDouble(statement, mapProperties.targetIndex, value == null ? 0.0 : (Double)value, value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 7: 
                case 100: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> Float.valueOf(resultSet.getFloat(cellMapProperties.sourceIndex)));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertFloat(statement, mapProperties.targetIndex, value == null ? 0.0f : ((Float)value).floatValue(), value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 4: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> resultSet.getInt(cellMapProperties.sourceIndex));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertInteger(statement, mapProperties.targetIndex, value == null ? 0 : (Integer)value, value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case -5: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> resultSet.getLong(cellMapProperties.sourceIndex));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertLong(statement, mapProperties.targetIndex, value == null ? 0L : (Long)value, value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case 5: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> resultSet.getShort(cellMapProperties.sourceIndex));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertShort(statement, mapProperties.targetIndex, value == null ? (short)0 : (Short)value, value == null, mapProperties.targetType, targetProperties);
                        }
                    };
                }
                case -6: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> resultSet.getByte(cellMapProperties.sourceIndex));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertByte(statement, mapProperties.targetIndex, value == null ? (byte)0 : (Byte)value, value == null, mapProperties.targetType);
                        }
                    };
                }
                case 2011: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> resultSet.getNClob(cellMapProperties.sourceIndex));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertNClob(statement, mapProperties.targetIndex, (NClob)value, mapProperties.targetType);
                        }
                    };
                }
                case 2005: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> resultSet.getClob(cellMapProperties.sourceIndex));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertClob(statement, mapProperties.targetIndex, (Clob)value, mapProperties.targetType);
                        }
                    };
                }
                case 2004: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> {
                            try {
                                return resultSet.getBlob(cellMapProperties.sourceIndex);
                            }
                            catch (SQLException ex) {
                                return resultSet.getBytes(cellMapProperties.sourceIndex);
                            }
                        });
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException, IOException {
                            switch (mapProperties.targetType) {
                                case -4: 
                                case -3: 
                                case -2: {
                                    if (value == null) {
                                        JdbcConverter.convertBytes(statement, mapProperties.targetIndex, null, mapProperties.targetType);
                                        break;
                                    }
                                    Throwable throwable = null;
                                    Object var4_5 = null;
                                    try (InputStream inputStream = ((Blob)value).getBinaryStream();){
                                        JdbcConverter.convertBytes(statement, mapProperties.targetIndex, inputStream.readAllBytes(), mapProperties.targetType);
                                        break;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                default: {
                                    JdbcConverter.convertBlob(statement, mapProperties.targetIndex, (Blob)value, mapProperties.targetType);
                                }
                            }
                        }
                    };
                }
                case 2006: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> resultSet.getRef(cellMapProperties.sourceIndex));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            statement.setRef(mapProperties.targetIndex, (Ref)value);
                        }
                    };
                }
                case 2003: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> resultSet.getArray(cellMapProperties.sourceIndex));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            statement.setArray(mapProperties.targetIndex, (Array)value);
                        }
                    };
                }
                case -4: 
                case -3: 
                case -2: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> resultSet.getBytes(cellMapProperties.sourceIndex));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertBytes(statement, mapProperties.targetIndex, (byte[])value, mapProperties.targetType);
                        }
                    };
                }
                case 1111: 
                case 2000: {
                    if (reader) {
                        return ResultSetCellReader.of(resultSet -> resultSet.getObject(cellMapProperties.sourceIndex));
                    }
                    return new ICellWriter<PreparedStatement>(){

                        @Override
                        public void write(PreparedStatement statement, Object value) throws SQLException {
                            JdbcConverter.convertObject(statement, mapProperties.targetIndex, value, mapProperties.targetType);
                        }
                    };
                }
            }
            if (reader) {
                return ResultSetCellReader.of(resultSet -> {
                    Object o = resultSet.getObject(cellMapProperties.sourceIndex);
                    if (o != null && (o.getClass().getName().equals("oracle.sql.TIMESTAMPTZ") || o.getClass().getName().equals("oracle.sql.TIMESTAMPLTZ"))) {
                        return resultSet.getTimestamp(cellMapProperties.sourceIndex);
                    }
                    return o;
                });
            }
            return new ICellWriter<PreparedStatement>(){

                @Override
                public void write(PreparedStatement statement, Object value) throws SQLException {
                    boolean isTimeStamp;
                    boolean bl = isTimeStamp = value != null && (value.getClass().getName().equals("oracle.sql.TIMESTAMPTZ") || value.getClass().getName().equals("oracle.sql.TIMESTAMPLTZ") || value.getClass().getName().equals("java.sql.Timestamp"));
                    if (isTimeStamp) {
                        JdbcConverter.convertTimeStamp(statement, mapProperties.targetIndex, (Timestamp)value, mapProperties.targetType, targetProperties);
                    } else {
                        JdbcConverter.convertObject(statement, mapProperties.targetIndex, value, mapProperties.targetType);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new Exception("Exception for source column " + mapProperties.sourceIndex, e);
        }
    }

    @FunctionalInterface
    private static interface Function {
        public void apply() throws SQLException;
    }
}

