/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.actionCodes.convert;

import com.indy.engine.core.IDatatypeConverter;
import com.indy.engine.core.UtilsService;
import com.indy.engine.core.actionCodes.convert.AbstractDataTypeConverter;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public abstract class Unparser {
    AbstractDataTypeConverter dataTypeProvider;
    protected IDatatypeConverter datatypeConverter;
    Object currentValue;

    public Unparser(AbstractDataTypeConverter dataTypeProvider) throws EngineExceptionI {
        this.dataTypeProvider = dataTypeProvider;
        try {
            this.datatypeConverter = UtilsService.getXmlUtils().getDatatypeConverter();
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
    }

    public abstract String printBoolean(boolean var1, int var2);

    public abstract String printDateTime(Calendar var1, int var2);

    public abstract String printDecimal(BigDecimal var1, int var2);

    public abstract String printDouble(Double var1, int var2);

    public abstract String printFloat(Float var1, int var2);

    public abstract String printString(String var1, int var2);

    public abstract String printBytes(byte[] var1, int var2);

    public abstract String print(Object var1, int var2);

    public static Object jdbcToObject(int colType, ResultSet rSet, int index, boolean isGetDateHasTimeStamp) throws SQLException {
        switch (colType) {
            case -7: 
            case 16: {
                boolean b = rSet.getBoolean(index);
                try {
                    if (rSet.wasNull()) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return b;
            }
            case 91: {
                Date d = null;
                d = isGetDateHasTimeStamp ? rSet.getTimestamp(index) : rSet.getDate(index);
                return d;
            }
            case 92: {
                Time t = rSet.getTime(index);
                return t;
            }
            case 93: {
                Timestamp ts = rSet.getTimestamp(index);
                return ts;
            }
            case 2: 
            case 3: {
                BigDecimal dec = rSet.getBigDecimal(index);
                return dec;
            }
            case 8: {
                double dbl = rSet.getDouble(index);
                try {
                    if (rSet.wasNull()) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return dbl;
            }
            case 6: 
            case 7: {
                float flt = rSet.getFloat(index);
                try {
                    if (rSet.wasNull()) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return Float.valueOf(flt);
            }
            case 4: {
                int _int = rSet.getInt(index);
                try {
                    if (rSet.wasNull()) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return _int;
            }
            case -6: 
            case 5: {
                short _short = rSet.getShort(index);
                try {
                    if (rSet.wasNull()) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return _short;
            }
            case -5: {
                long _long = rSet.getLong(index);
                try {
                    if (rSet.wasNull()) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return _long;
            }
            case 2004: {
                Blob blob = rSet.getBlob(index);
                return blob;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] bytes = rSet.getBytes(index);
                return bytes;
            }
        }
        return rSet.getString(index);
    }

    public Object getCurrentValue() {
        return this.currentValue;
    }

    public String jdbcToString(int colType, ResultSet rSet, int index) throws SQLException {
        return this.jdbcToString(colType, rSet, index, -1);
    }

    private String jdbcToString(int colType, ResultSet rSet, int index, int type) throws SQLException {
        this.currentValue = null;
        switch (colType) {
            case -7: 
            case 16: {
                Boolean b = (Boolean)Unparser.jdbcToObject(colType, rSet, index, false);
                this.currentValue = b;
                if (b != null) {
                    return this.printBoolean(b, type);
                }
                return null;
            }
            case 91: {
                Date d = (Date)Unparser.jdbcToObject(colType, rSet, index, this.dataTypeProvider.isGetDateHasTimestamp());
                this.currentValue = d;
                if (d != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(d);
                    return this.printDateTime(cal, type);
                }
                return null;
            }
            case 92: {
                Time t = (Time)Unparser.jdbcToObject(colType, rSet, index, false);
                this.currentValue = t;
                if (t != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(t);
                    return this.printDateTime(cal, type);
                }
                return null;
            }
            case 93: {
                Timestamp ts = (Timestamp)Unparser.jdbcToObject(colType, rSet, index, false);
                this.currentValue = ts;
                if (ts != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(ts);
                    return this.printDateTime(cal, type);
                }
                return null;
            }
            case 2: 
            case 3: {
                BigDecimal dec = (BigDecimal)Unparser.jdbcToObject(colType, rSet, index, false);
                this.currentValue = dec;
                if (dec != null) {
                    return this.printDecimal(dec, type);
                }
                return null;
            }
            case 8: {
                Double dbl = (Double)Unparser.jdbcToObject(colType, rSet, index, false);
                this.currentValue = dbl;
                if (dbl != null) {
                    return this.printDouble(dbl, type);
                }
                return null;
            }
            case 6: 
            case 7: {
                Float flt = (Float)Unparser.jdbcToObject(colType, rSet, index, false);
                this.currentValue = flt;
                if (flt != null) {
                    return this.printFloat(flt, type);
                }
                return null;
            }
            case 4: {
                Integer in = (Integer)Unparser.jdbcToObject(colType, rSet, index, false);
                this.currentValue = in;
                if (in != null) {
                    return this.printString(in.toString(), type);
                }
                return null;
            }
            case -6: 
            case 5: {
                Short sho = (Short)Unparser.jdbcToObject(colType, rSet, index, false);
                this.currentValue = sho;
                if (sho != null) {
                    return this.printString(sho.toString(), type);
                }
                return null;
            }
            case -5: {
                Long lon = (Long)Unparser.jdbcToObject(colType, rSet, index, false);
                this.currentValue = lon;
                if (lon != null) {
                    return this.printString(lon.toString(), type);
                }
                return null;
            }
            case 2004: {
                Blob blob = (Blob)Unparser.jdbcToObject(colType, rSet, index, false);
                this.currentValue = blob;
                if (blob != null) {
                    return this.printBytes(blob.getBytes(1L, (int)blob.length()), type);
                }
                return null;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] bytes = (byte[])Unparser.jdbcToObject(colType, rSet, index, false);
                this.currentValue = bytes;
                if (bytes != null) {
                    return this.printBytes(bytes, type);
                }
                return null;
            }
        }
        String tmp = (String)Unparser.jdbcToObject(colType, rSet, index, false);
        this.currentValue = tmp;
        if (tmp != null) {
            return this.printString(tmp, type);
        }
        return null;
    }
}

