/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.actionCodes.json.internal;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLWriterContentHandler
implements ContentHandler {
    private XMLStreamWriter writer;
    private String encoding;
    private String version;

    public XMLWriterContentHandler(XMLStreamWriter writer, String encoding, String version) {
        this.writer = writer;
        this.encoding = encoding != null ? encoding : "UTF-8";
        this.version = version != null ? version : "1.0";
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.writer.writeStartDocument(this.encoding, this.version);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.writer.writeEndDocument();
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.writer.writeStartElement(localName);
            int i = 0;
            while (i < atts.getLength()) {
                this.writer.writeAttribute(atts.getLocalName(i), atts.getValue(i));
                ++i;
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.writer.writeCharacters(ch, start, length);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

