/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.api.impl;

import com.indy.engine.core.actionCodes.convert.JdbcConverter;
import com.indy.engine.core.api.impl.CellMapProperties;
import com.indy.engine.core.api.impl.Messages;
import com.indy.engine.core.api.impl.jdbc.JdbcReaderProperties;
import com.indy.runtime.api.IBindReader;
import com.indy.runtime.api.ICellReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class JdbcBindReader
implements IBindReader {
    public static final String JDBC_RESULT_SET = "resultSet";
    public static final String JDBC_FETCH_SIZE = "fetchSize";
    public static final String JDBC_DATE_AS_TIMESTAMPS = "getDateHasTimeStamp";
    public static final String JDBC_TARGET_DATATYPES = "targetDatatypes";
    private ResultSet resultSet;
    private Integer fetchSize;
    private boolean getDateHasTimeStamp = false;
    JdbcReaderProperties jrp;
    boolean prepare = false;
    boolean readFirst = false;
    int[] sourceDatatypes;
    private int[] targetDatatypes;
    private ICellReader<ResultSet>[] cells;

    @Override
    public void setParameter(String key, Object value) throws Exception {
        if (JDBC_RESULT_SET.equals(key)) {
            this.resultSet = (ResultSet)value;
        }
        if (JDBC_FETCH_SIZE.equals(key)) {
            this.fetchSize = (Integer)value;
        }
        if (JDBC_DATE_AS_TIMESTAMPS.equals(key)) {
            this.getDateHasTimeStamp = (Boolean)value;
        }
        if (JDBC_TARGET_DATATYPES.equals(key)) {
            this.targetDatatypes = (int[])value;
        }
    }

    @Override
    public Object getValue(int index) throws Exception {
        if (!this.readFirst) {
            throw new SQLException(Messages.getString("JdbcBindReader.0"));
        }
        return this.cells[index].read(this.resultSet);
    }

    @Override
    public void prepare() throws Exception {
        if (this.prepare) {
            throw new SQLException(Messages.getString("JdbcBindReader.1"));
        }
        if (this.resultSet == null) {
            throw new SQLException(Messages.getString("JdbcBindReader.2"));
        }
        if (this.targetDatatypes == null) {
            throw new Exception(Messages.getString("JdbcBindReader.3") + JDBC_TARGET_DATATYPES + Messages.getString("JdbcBindReader.4"));
        }
        if (this.fetchSize != null) {
            this.resultSet.setFetchSize(this.fetchSize);
        }
        ResultSetMetaData rmd = this.resultSet.getMetaData();
        this.sourceDatatypes = new int[rmd.getColumnCount()];
        int i = 0;
        while (i < rmd.getColumnCount()) {
            this.sourceDatatypes[i] = rmd.getColumnType(i + 1);
            ++i;
        }
        if (this.targetDatatypes.length != this.sourceDatatypes.length) {
            throw new Exception(Messages.getString("JdbcBindReader.5") + this.sourceDatatypes.length + Messages.getString("JdbcBindReader.6") + this.targetDatatypes.length + Messages.getString("JdbcBindReader.7"));
        }
        JdbcReaderProperties jrp = new JdbcReaderProperties();
        jrp.setDateAsTimestamp(this.getDateHasTimeStamp);
        this.cells = new ICellReader[this.sourceDatatypes.length];
        int i2 = 0;
        while (i2 < this.targetDatatypes.length) {
            CellMapProperties cmp = new CellMapProperties();
            cmp.sourceIndex = i2 + 1;
            cmp.sourceType = this.sourceDatatypes[i2];
            cmp.targetIndex = i2 + 1;
            cmp.targetType = this.targetDatatypes[i2];
            this.cells[i2] = JdbcConverter.getResultSetCellReader(cmp, jrp);
            ++i2;
        }
        this.prepare = true;
    }

    @Override
    public boolean readNext() throws Exception {
        if (!this.readFirst) {
            this.readFirst = true;
        }
        if (this.prepare) {
            return this.resultSet.next();
        }
        throw new SQLException(Messages.getString("JdbcBindReader.8"));
    }

    @Override
    public void close() throws Exception {
        this.prepare = false;
        this.resultSet = null;
    }

    @Override
    public int[] getDataType() throws Exception {
        if (this.prepare) {
            return this.sourceDatatypes;
        }
        throw new SQLException(Messages.getString("JdbcBindReader.9"));
    }

    @Override
    public int getDataType(int index) throws Exception {
        if (this.prepare) {
            return this.sourceDatatypes[index];
        }
        throw new SQLException(Messages.getString("JdbcBindReader.10"));
    }
}

