/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.delivery.impl;

import com.indy.engine.common.tools.ProcessWrapper;
import com.indy.engine.core.common.GlobalVarI;
import com.indy.engine.core.delivery.IDeliveryExecutor;
import com.indy.engine.core.delivery.impl.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;

public class DeliveryCommandLineExecutor
implements IDeliveryExecutor {
    private OutputStream standarOutput;
    private OutputStream errorOutput;
    private int erroutOutputLimit;

    protected String getModuleFolderPath() {
        String folder = System.getProperty("xdi.designer.module.path.v1");
        if (folder == null) {
            folder = System.getProperty("stambia.module.path.v1");
        }
        return folder;
    }

    @Override
    public DeliveryExecutorResponse execute(IDeliveryExecutor.IConfiguration conf) throws Exception {
        DeliveryExecutorResponse der = new DeliveryExecutorResponse();
        Process proc = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        String str1 = System.getProperty("java.system.class.loader");
        if (str1 != null && str1.equals("com.indy.engine.StambiaSystemClassLoader")) {
            command.add("-Djava.system.class.loader=com.indy.engine.StambiaSystemClassLoader");
        }
        if ((str1 = System.getProperty("stambia.classpath.v1.core")) != null && !str1.isEmpty()) {
            command.add("-Dstambia.classpath.v1.core=" + str1);
        }
        if ((str1 = System.getProperty("stambia.classpath.v1.internal")) != null && !str1.isEmpty()) {
            command.add("-Dstambia.classpath.v1.internal=" + str1);
        }
        if ((str1 = this.getModuleFolderPath()) != null && !str1.isEmpty()) {
            command.add("-xdi.designer.module.path.v1=" + str1);
        }
        if ((str1 = System.getProperty("stambia.default.classpath.name")) != null && !str1.isEmpty()) {
            command.add("-Dstambia.default.classpath.name=" + str1);
        }
        command.add("-classpath");
        command.add(System.getProperty("java.class.path"));
        command.add("com.indy.engine.launcher.MainLauncher");
        command.add("-mainclass");
        command.add("com.indy.engine.StartDelivery");
        command.add("-name");
        command.add(conf.getDeliveryName());
        if (conf.getLaunchMode() != null) {
            command.add("-launchMode");
            command.add(conf.getLaunchMode());
        }
        if (conf.getSessionName() != null && !conf.getSessionName().isEmpty()) {
            command.add("-sessionname");
            command.add(conf.getSessionName());
        }
        if (GlobalVarI.getGlobalProperties() != null && GlobalVarI.getGlobalProperties().geConfFilePath() != null) {
            command.add("-conf");
            command.add(GlobalVarI.getGlobalProperties().geConfFilePath());
        }
        if (conf.getConfiguration() != null) {
            command.add("-configuration");
            command.add(conf.getConfiguration());
        }
        if (conf.getSessionId() != null) {
            command.add("-sessionId");
            command.add(conf.getSessionId());
        }
        if (conf.getParentSessionId() != null) {
            command.add("-parentSessionId");
            command.add(conf.getParentSessionId());
        }
        if (conf.getRepository() != null) {
            command.add("-repository");
            command.add("\"" + conf.getRepository() + "\"");
        }
        if (conf.getVariables() != null) {
            for (Map.Entry<String, String> var : conf.getVariables().entrySet()) {
                command.add("-var");
                command.add(var.getKey());
                command.add(var.getValue());
            }
        }
        if (conf.getSessionId() == null) {
            command.add("-outputFormat");
            command.add("####SESSIONID:%id####");
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        proc = pb.start();
        ProcessWrapper pw = ProcessWrapper.wrap(proc);
        if (this.standarOutput != null) {
            pw.setInputOutputStream(this.standarOutput, -1);
        }
        if (this.errorOutput != null) {
            if (this.erroutOutputLimit != 0) {
                pw.setErrorOutputStream(this.errorOutput, this.erroutOutputLimit);
            } else {
                pw.setErrorOutputStream(this.errorOutput, -1);
            }
        }
        if (conf.getSessionId() == null) {
            InputStreamReader isr = new InputStreamReader(proc.getInputStream());
            int i = 0;
            StringBuilder sb = new StringBuilder();
            boolean start = false;
            do {
                i = isr.read();
                char c = (char)i;
                if (start && c == '#') break;
                sb.append(c);
                if (!sb.toString().endsWith("####SESSIONID:")) continue;
                sb = new StringBuilder();
                start = true;
            } while (i != -1);
            der.sessionId = sb.toString();
        } else {
            der.sessionId = conf.getSessionId();
        }
        if (conf.isSynch()) {
            pw.startReaderThreads();
            pw.waitForAndEndThreads();
            if (der.sessionId != null && new File("sessions/" + der.sessionId + ".session").exists()) {
                throw new EngineExceptionI(Messages.getString("DeliveryCommandLineExecutor.0") + der.sessionId + Messages.getString("DeliveryCommandLineExecutor.1"));
            }
            int retCode = proc.exitValue();
            if (retCode == 0) {
                der.retCode = 1;
                retCode = 1;
            }
            if (retCode != 1 && retCode != 0) {
                throw new EngineExceptionI(Messages.getString("DeliveryCommandLineExecutor.2") + conf.getDeliveryName() + Messages.getString("DeliveryCommandLineExecutor.3"));
            }
            der.retCode = retCode;
        }
        return der;
    }

    public void setStandarOutput(OutputStream standarOutput) {
        this.standarOutput = standarOutput;
    }

    public void setErrorOutput(OutputStream errorOutput) {
        this.errorOutput = errorOutput;
    }

    public void setErroutOutputLimit(int i) {
        this.erroutOutputLimit = i;
    }

    class DeliveryExecutorResponse
    implements IDeliveryExecutor.IResponse {
        String sessionId;
        private int retCode = -99;

        DeliveryExecutorResponse() {
        }

        @Override
        public int getRetCode() {
            return this.retCode;
        }

        @Override
        public String getSessionId() {
            return this.sessionId;
        }
    }
}

