/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.hierarchy;

import com.indy.runtime.hierarchy.event.EndDocumentEvent;
import com.indy.runtime.hierarchy.event.EndElementEvent;
import com.indy.runtime.hierarchy.event.StartDocumentEvent;
import com.indy.runtime.hierarchy.event.StartElementEvent;

public abstract class HierarchyEvent {
    protected EventType eventType;

    public boolean isStartElementEvent() {
        return this.eventType == EventType.startElement || this.eventType == EventType.startDataElement;
    }

    public boolean isStartElementContainerEvent() {
        return this.eventType == EventType.startElement;
    }

    public boolean isEndElementEvent() {
        return this.eventType == EventType.endElement;
    }

    public boolean isStartDataElementEvent() {
        return this.eventType == EventType.startDataElement;
    }

    public boolean isStartDocumentEvent() {
        return this.eventType == EventType.startDocument;
    }

    public boolean isEndDocumentEvent() {
        return this.eventType == EventType.endDocument;
    }

    public StartDocumentEvent asStartDocumentEvent() {
        HierarchyEvent o = this;
        return (StartDocumentEvent)o;
    }

    public EndDocumentEvent asEndDocumentEvent() {
        HierarchyEvent o = this;
        return (EndDocumentEvent)o;
    }

    public StartElementEvent asStartElementEvent() {
        HierarchyEvent o = this;
        return (StartElementEvent)o;
    }

    public EndElementEvent asEndElementEvent() {
        HierarchyEvent o = this;
        return (EndElementEvent)o;
    }

    public static boolean objectEquals(Object name, Object name2) {
        if (name == null) {
            return name2 == null;
        }
        if (name2 == null) {
            return false;
        }
        if (name instanceof byte[]) {
            byte[] one = (byte[])name;
            if (name2 instanceof byte[]) {
                byte[] two = (byte[])name2;
                if (one.length != two.length) {
                    return false;
                }
                int i = 0;
                while (i < one.length) {
                    if (one[i] != two[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return name.equals(name2);
    }

    protected static enum EventType {
        startDocument,
        endDocument,
        startElement,
        endElement,
        startDataElement;

    }
}

