/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.hierarchy;

import com.indy.runtime.hierarchy.HierarchyEvent;
import com.indy.runtime.hierarchy.HierarchyEventFactory;
import com.indy.runtime.hierarchy.IXMLConverter;
import com.indy.runtime.hierarchy.Messages;
import com.indy.runtime.hierarchy.event.StartElementEvent;
import com.indy.runtime.json.JsonConstants;
import com.indy.runtime.json.JsonUtils;
import java.io.IOException;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class HierarchyEventWriter {
    Stack<HierarchyEvent> stack = new Stack();
    boolean currentValueIsNull;
    HierarchyEventFactory factory = HierarchyEventFactory.newFactory();
    boolean disableFirstRoot = true;
    boolean firstRootIsReaded = false;
    boolean bsonStyle = false;

    public abstract void handle(HierarchyEvent var1) throws Exception;

    public void add(XMLEvent paramXMLEvent, IXMLConverter converter) throws XMLStreamException {
        this._add(paramXMLEvent, converter);
    }

    public void setDisableFirstRoot(boolean disableFirstRoot) {
        this.disableFirstRoot = disableFirstRoot;
    }

    private void _add(XMLEvent paramXMLEvent, IXMLConverter converter) throws XMLStreamException {
        try {
            switch (paramXMLEvent.getEventType()) {
                case 7: {
                    this.handle(this.factory.createStartDocument());
                    break;
                }
                case 8: {
                    this.handle(this.factory.createEndDocument());
                    break;
                }
                case 1: {
                    Attribute type;
                    if (this.disableFirstRoot && !this.firstRootIsReaded) {
                        this.firstRootIsReaded = true;
                        break;
                    }
                    StartElement se = paramXMLEvent.asStartElement();
                    String name = se.getName().getLocalPart();
                    if (name.startsWith("_.") && name.endsWith("._")) {
                        name = name.substring(2, name.length() - 2);
                        name = JsonUtils.decodeHexString(name);
                    }
                    if ((type = se.getAttributeByName(JsonConstants.XML_TYPE)) != null) {
                        String lower = type.getValue().toLowerCase();
                        int dt = converter.getTypeCode(lower);
                        boolean data = converter.isDataType(dt);
                        if (data) {
                            StartElementEvent currentDataEvent = this.factory.createData(name, dt, null);
                            Attribute nil = se.getAttributeByName(JsonConstants.XML_NIL);
                            if (nil != null && nil.getValue().equals("true")) {
                                currentDataEvent.setIsNull(true);
                            }
                            this.stack.add(currentDataEvent);
                            this.handle(currentDataEvent);
                            break;
                        }
                        StartElementEvent event = this.factory.createStartElement(name, dt);
                        this.stack.add(event);
                        this.handle(event);
                        break;
                    }
                    StartElementEvent event = this.factory.createStartElement(name, Integer.MIN_VALUE);
                    this.stack.add(event);
                    this.handle(event);
                    break;
                }
                case 4: 
                case 12: {
                    HierarchyEvent he = this.stack.peek();
                    if (he.isStartDataElementEvent()) {
                        StartElementEvent _current = this.stack.peek().asStartElementEvent();
                        if (!_current.isNull()) {
                            _current.setStringData(paramXMLEvent.asCharacters().getData());
                        }
                    } else if (!he.isStartElementEvent() || !he.asStartElementEvent().name.startsWith("rec_")) {
                        throw new IOException(Messages.getString("HierarchyEventWriter.0"));
                    }
                    break;
                }
                case 2: {
                    if (this.stack.size() == 0 && this.disableFirstRoot && this.firstRootIsReaded) {
                        this.firstRootIsReaded = false;
                        break;
                    }
                    StartElementEvent current = (StartElementEvent)this.stack.pop();
                    if (current == null) {
                        throw new XMLStreamException(Messages.getString("HierarchyEventWriter.1"));
                    }
                    String name = paramXMLEvent.asEndElement().getName().getLocalPart();
                    if (name.startsWith("_.") && name.endsWith("._")) {
                        name = name.substring(2, name.length() - 2);
                        name = JsonUtils.decodeHexString(name);
                    }
                    if (!HierarchyEvent.objectEquals(current.name, name)) {
                        throw new XMLStreamException(Messages.getString("HierarchyEventWriter.2"));
                    }
                    if (current.isStartElementEvent()) {
                        if (current.isStartDataElementEvent() && current.getData() == null && current.getStringData() == null && !current.isNull()) {
                            current.setStringData("");
                        }
                        this.handle(this.factory.createEndElement(name));
                        break;
                    }
                    throw new XMLStreamException();
                }
            }
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    public abstract void close() throws Exception;

    public XMLEventWriter createXMLEventWriter(final IXMLConverter converter) {
        return new XMLEventWriter(){

            @Override
            public void add(XMLEventReader xmlReader) throws XMLStreamException {
                try {
                    while (xmlReader.hasNext()) {
                        XMLEvent event = xmlReader.nextEvent();
                        this.add(event);
                    }
                }
                catch (Exception ex) {
                    throw new XMLStreamException(ex);
                }
            }

            @Override
            public void flush() throws XMLStreamException {
            }

            @Override
            public NamespaceContext getNamespaceContext() {
                return null;
            }

            @Override
            public String getPrefix(String uri) throws XMLStreamException {
                return null;
            }

            @Override
            public void setDefaultNamespace(String uri) throws XMLStreamException {
            }

            @Override
            public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
            }

            @Override
            public void setPrefix(String prefix, String uri) throws XMLStreamException {
            }

            @Override
            public void add(XMLEvent event) throws XMLStreamException {
                HierarchyEventWriter.this.add(event, converter);
            }

            @Override
            public void close() throws XMLStreamException {
                try {
                    HierarchyEventWriter.this.close();
                }
                catch (Exception e) {
                    throw new XMLStreamException(e);
                }
            }
        };
    }
}

