/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.xml.internal;

import com.indy.runtime.xml.NewLineCharacter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;

public class XmlStreamWriter2XmlEventWriter
implements XMLStreamWriter {
    XMLEventWriter xew;
    XMLEventFactory xef;
    LinkedList<QName> stack = new LinkedList();
    QName currentQname = null;
    List<Attribute> currentAttributes;

    public XmlStreamWriter2XmlEventWriter(XMLEventWriter xew) {
        this.xew = xew;
        this.xef = XMLEventFactory.newInstance();
    }

    @Override
    public void writeStartElement(String local) throws XMLStreamException {
        this.openPrevious();
        this.currentQname = new QName(local);
        this.stack.add(this.currentQname);
    }

    @Override
    public void writeStartElement(String uri, String local) throws XMLStreamException {
        this.openPrevious();
        this.currentQname = new QName(uri, local);
        this.stack.add(this.currentQname);
    }

    private void openPrevious() throws XMLStreamException {
        if (this.currentQname != null) {
            this.xew.add(this.xef.createStartElement(this.currentQname, this.currentAttributes.iterator(), null));
        }
        this.currentQname = null;
        this.currentAttributes = new ArrayList<Attribute>();
    }

    @Override
    public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
        this.openPrevious();
        this.currentQname = new QName(uri, local, prefix);
        this.stack.add(this.currentQname);
    }

    @Override
    public void writeEmptyElement(String paramString1, String paramString2) throws XMLStreamException {
        this.writeStartElement(paramString1, paramString2);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String paramString1, String paramString2, String paramString3) throws XMLStreamException {
        this.writeStartElement(paramString1, paramString2, paramString3);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String paramString) throws XMLStreamException {
        this.writeStartElement(paramString);
        this.writeEndElement();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.openPrevious();
        this.xew.add(this.xef.createEndElement(this.stack.removeLast(), null));
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.xew.add(this.xef.createEndDocument());
    }

    @Override
    public void close() throws XMLStreamException {
        this.xew.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.xew.flush();
    }

    @Override
    public void writeAttribute(String local, String value) throws XMLStreamException {
        this.currentAttributes.add(this.xef.createAttribute(local, value));
    }

    @Override
    public void writeAttribute(String prefix, String uri, String local, String value) throws XMLStreamException {
        this.currentAttributes.add(this.xef.createAttribute(prefix, uri, local, value));
    }

    @Override
    public void writeAttribute(String uri, String local, String value) throws XMLStreamException {
        this.currentAttributes.add(this.xef.createAttribute("", uri, local, value));
    }

    @Override
    public void writeNamespace(String paramString1, String paramString2) throws XMLStreamException {
        this.xew.add(this.xef.createNamespace(paramString1, paramString2));
    }

    @Override
    public void writeDefaultNamespace(String paramString) throws XMLStreamException {
    }

    @Override
    public void writeComment(String paramString) throws XMLStreamException {
        this.openPrevious();
        this.xew.add(this.xef.createComment(paramString));
    }

    @Override
    public void writeProcessingInstruction(String paramString) throws XMLStreamException {
        this.xew.add(this.xef.createProcessingInstruction(paramString, null));
    }

    @Override
    public void writeProcessingInstruction(String paramString1, String paramString2) throws XMLStreamException {
        this.xew.add(this.xef.createProcessingInstruction(paramString1, paramString2));
    }

    @Override
    public void writeCData(String paramString) throws XMLStreamException {
        this.openPrevious();
        this.xew.add(this.xef.createCData(paramString));
    }

    @Override
    public void writeDTD(String paramString) throws XMLStreamException {
    }

    @Override
    public void writeEntityRef(String paramString) throws XMLStreamException {
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.xew.add(this.xef.createStartDocument());
    }

    @Override
    public void writeStartDocument(String paramString) throws XMLStreamException {
        this.xew.add(this.xef.createStartDocument(paramString));
    }

    @Override
    public void writeStartDocument(String paramString1, String paramString2) throws XMLStreamException {
        this.xew.add(this.xef.createStartDocument(paramString1, paramString2));
    }

    @Override
    public void writeCharacters(String paramString) throws XMLStreamException {
        this.openPrevious();
        this.xew.add(this.xef.createCharacters(paramString));
    }

    @Override
    public void writeCharacters(char[] paramArrayOfChar, int paramInt1, int paramInt2) throws XMLStreamException {
        this.openPrevious();
        this.xew.add(this.xef.createCharacters(new String(paramArrayOfChar, paramInt1, paramInt2)));
    }

    public void writeNewLineCharacter() throws XMLStreamException {
        this.openPrevious();
        NewLineCharacter newLineCharacter = new NewLineCharacter();
        this.xew.add(newLineCharacter);
    }

    @Override
    public String getPrefix(String paramString) throws XMLStreamException {
        return null;
    }

    @Override
    public void setPrefix(String paramString1, String paramString2) throws XMLStreamException {
    }

    @Override
    public void setDefaultNamespace(String paramString) throws XMLStreamException {
    }

    @Override
    public void setNamespaceContext(NamespaceContext paramNamespaceContext) throws XMLStreamException {
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return null;
    }

    @Override
    public Object getProperty(String paramString) throws IllegalArgumentException {
        return null;
    }

    public static void main(String[] args) {
    }
}

