/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.tech;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FileType implements Enumerator
{
    TRUE(0, "true", "true"),
    FALSE(1, "false", "false"),
    ADVANCED(2, "advanced", "advanced");

    public static final int TRUE_VALUE = 0;
    public static final int FALSE_VALUE = 1;
    public static final int ADVANCED_VALUE = 2;
    private static final FileType[] VALUES_ARRAY;
    public static final List<FileType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FileType[]{TRUE, FALSE, ADVANCED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FileType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FileType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FileType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FileType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FileType get(int value) {
        switch (value) {
            case 0: {
                return TRUE;
            }
            case 1: {
                return FALSE;
            }
            case 2: {
                return ADVANCED;
            }
        }
        return null;
    }

    private FileType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

