/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.tech;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MappingInfo implements Enumerator
{
    MANDATORY(0, "Mandatory", "Mandatory"),
    TYPE(1, "Type", "Type"),
    SIZE(2, "Size", "Size"),
    PRECISION(3, "Precision", "Precision"),
    UPDATE_KEY(4, "UpdateKey", "UpdateKey"),
    SRC_REF(5, "SrcRef", "SrcRef");

    public static final int MANDATORY_VALUE = 0;
    public static final int TYPE_VALUE = 1;
    public static final int SIZE_VALUE = 2;
    public static final int PRECISION_VALUE = 3;
    public static final int UPDATE_KEY_VALUE = 4;
    public static final int SRC_REF_VALUE = 5;
    private static final MappingInfo[] VALUES_ARRAY;
    public static final List<MappingInfo> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MappingInfo[]{MANDATORY, TYPE, SIZE, PRECISION, UPDATE_KEY, SRC_REF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MappingInfo get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MappingInfo result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MappingInfo getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MappingInfo result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MappingInfo get(int value) {
        switch (value) {
            case 0: {
                return MANDATORY;
            }
            case 1: {
                return TYPE;
            }
            case 2: {
                return SIZE;
            }
            case 3: {
                return PRECISION;
            }
            case 4: {
                return UPDATE_KEY;
            }
            case 5: {
                return SRC_REF;
            }
        }
        return null;
    }

    private MappingInfo(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

