/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.tech;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ParameterType implements Enumerator
{
    STRING(0, "String", "String"),
    XPATH(1, "XPath", "XPath");

    public static final int STRING_VALUE = 0;
    public static final int XPATH_VALUE = 1;
    private static final ParameterType[] VALUES_ARRAY;
    public static final List<ParameterType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParameterType[]{STRING, XPATH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParameterType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return XPATH;
            }
        }
        return null;
    }

    private ParameterType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

