/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.tech;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PropertyType implements Enumerator
{
    STRING(0, "string", "string"),
    INTEGER(1, "integer", "integer"),
    BOOLEAN(2, "boolean", "boolean"),
    PASSWORD(3, "password", "password"),
    DATE(4, "date", "date"),
    LIST(5, "list", "list"),
    REFERENCE(6, "reference", "reference"),
    FILE(7, "file", "file");

    public static final int STRING_VALUE = 0;
    public static final int INTEGER_VALUE = 1;
    public static final int BOOLEAN_VALUE = 2;
    public static final int PASSWORD_VALUE = 3;
    public static final int DATE_VALUE = 4;
    public static final int LIST_VALUE = 5;
    public static final int REFERENCE_VALUE = 6;
    public static final int FILE_VALUE = 7;
    private static final PropertyType[] VALUES_ARRAY;
    public static final List<PropertyType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PropertyType[]{STRING, INTEGER, BOOLEAN, PASSWORD, DATE, LIST, REFERENCE, FILE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PropertyType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PropertyType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PropertyType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PropertyType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PropertyType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return BOOLEAN;
            }
            case 3: {
                return PASSWORD;
            }
            case 4: {
                return DATE;
            }
            case 5: {
                return LIST;
            }
            case 6: {
                return REFERENCE;
            }
            case 7: {
                return FILE;
            }
        }
        return null;
    }

    private PropertyType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

