/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.editors;

import com.indy.ui.sql.IResultModel;
import com.indy.ui.sql.internal.QueryResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class QueryExecutor {
    private Statement stmt;

    public IResultModel executeQuery(Connection connection, IQuery query, int maxRow) throws SQLException {
        long startTime = System.currentTimeMillis();
        this.stmt = connection.createStatement();
        try {
            if (query.isSelect() && maxRow > 0) {
                try {
                    this.stmt.setMaxRows(maxRow);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            boolean status = this.stmt.execute(query.getSQL());
            QueryResult res = null;
            do {
                try (ResultSet rs = null;){
                    if (status) {
                        rs = this.stmt.getResultSet();
                        res = new QueryResult(rs, maxRow);
                        continue;
                    }
                    res = new QueryResult(this.stmt.getUpdateCount());
                }
            } while ((status = this.stmt.getMoreResults()) || this.stmt.getUpdateCount() != -1);
            res.setExecutionTime(System.currentTimeMillis() - startTime);
            QueryResult queryResult = res;
            return queryResult;
        }
        finally {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
        }
    }

    public void cancel() throws SQLException {
        if (this.stmt != null) {
            this.stmt.cancel();
            this.stmt.close();
            this.stmt = null;
        }
    }

    static interface IQuery {
        public String getSQL();

        public boolean isSelect();
    }
}

