/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.editors;

import com.indy.ui.sql.IResultModel;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableColumnViewerComparator
extends ViewerComparator {
    public static final int ASC = 1;
    public static final int NONE = 0;
    public static final int DESC = -1;
    private int sortOrder = 0;
    private TableColumn column = null;
    private int columnIndex = 0;
    private final TableViewer viewer;
    private final SelectionListener selectionHandler = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableColumn selectedColumn = (TableColumn)e.widget;
            TableColumnViewerComparator.this.setColumn(selectedColumn);
        }
    };

    public TableColumnViewerComparator(TableViewer viewer) {
        this.viewer = viewer;
        viewer.setComparator((ViewerComparator)this);
        TableColumn[] tableColumnArray = viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.addSelectionListener(this.selectionHandler);
            ++n2;
        }
    }

    public void setColumn(TableColumn selectedColumn) {
        if (this.column == selectedColumn) {
            switch (this.sortOrder) {
                case 1: {
                    this.sortOrder = -1;
                    break;
                }
                case -1: {
                    this.sortOrder = 1;
                    break;
                }
                default: {
                    this.sortOrder = 1;
                    break;
                }
            }
        } else {
            this.column = selectedColumn;
            this.sortOrder = 1;
        }
        Table table = this.viewer.getTable();
        switch (this.sortOrder) {
            case 1: {
                table.setSortColumn(selectedColumn);
                table.setSortDirection(128);
                break;
            }
            case -1: {
                table.setSortColumn(selectedColumn);
                table.setSortDirection(1024);
                break;
            }
            default: {
                table.setSortColumn(null);
                table.setSortDirection(0);
            }
        }
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            TableColumn theColumn = columns[i];
            if (theColumn == this.column) {
                this.columnIndex = i;
            }
            ++i;
        }
        this.viewer.setComparator(null);
        this.viewer.setComparator((ViewerComparator)this);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.sortOrder * this.doCompare(viewer, e1, e2);
    }

    protected int doCompare(Viewer v, Object e1, Object e2) {
        Object t1 = ((IResultModel.Row)e1).getColumnValue(this.columnIndex);
        Object t2 = ((IResultModel.Row)e2).getColumnValue(this.columnIndex);
        if (t1 instanceof String && t2 instanceof String) {
            return ((String)t1).compareTo((String)t2);
        }
        if (t1 instanceof Long && t2 instanceof Long) {
            return ((Long)t1).compareTo((Long)t2);
        }
        if (t1 instanceof Double && t2 instanceof Double) {
            return ((Double)t1).compareTo((Double)t2);
        }
        if (t1 instanceof BigDecimal && t2 instanceof BigDecimal) {
            return ((BigDecimal)t1).compareTo((BigDecimal)t2);
        }
        if (t1 instanceof Timestamp && t2 instanceof Timestamp) {
            return ((Timestamp)t1).compareTo((Timestamp)t2);
        }
        if (t1 instanceof Time && t2 instanceof Time) {
            return ((Time)t1).compareTo((Time)t2);
        }
        if (t1 instanceof Date && t2 instanceof Date) {
            return ((Date)t1).compareTo((Date)t2);
        }
        return 0;
    }
}

