/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.editors.export;

import com.indy.ui.custom.out.patch.FileDialogPatch;
import com.indy.ui.sql.editors.export.ExportOptions;
import com.indy.ui.sql.editors.export.IExporter;
import com.indy.ui.sql.editors.export.Messages;
import com.indy.ui.sql.internal.IConstant;
import java.nio.charset.Charset;
import java.util.SortedMap;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportDialog
extends TitleAreaDialog {
    private Combo charsetCombo;
    private Combo separatorCombo;
    private Text nullValue;
    private Button includeHeadersButton;
    private Button quoteTextButton;
    private Text fileNameText;
    private String file;
    private IExporter exporter;
    private ExportOptions options;

    public ExportDialog(Shell parentShell, IExporter exporter, ExportOptions exportOptions) {
        super(parentShell);
        this.exporter = exporter;
        this.options = exportOptions;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        String title = Messages.ExportDialog_Title;
        this.setTitle(title);
        this.getShell().setText(title);
        ExportDialog.setDialogHelpAvailable((boolean)false);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout(512));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        Group formatGroup = new Group(composite, 0);
        formatGroup.setText(Messages.ExportDialog_Format);
        formatGroup.setLayout((Layout)new GridLayout(2, false));
        int i = 0;
        int defaultCharsetIndex = 0;
        Label label = new Label((Composite)formatGroup, 0);
        label.setText(Messages.ExportDialog_CharacterSet);
        this.charsetCombo = new Combo((Composite)formatGroup, 8);
        SortedMap<String, Charset> charsetsMap = Charset.availableCharsets();
        for (Charset charset : charsetsMap.values()) {
            this.charsetCombo.add(charset.displayName());
            if (charset.displayName().equalsIgnoreCase(this.options.getCharacterSet())) {
                defaultCharsetIndex = i;
            }
            ++i;
        }
        this.charsetCombo.select(defaultCharsetIndex);
        label = new Label((Composite)formatGroup, 0);
        label.setText(Messages.ExportDialog_Delimiter);
        this.separatorCombo = new Combo((Composite)formatGroup, 0);
        String[] separatorList = IConstant.CSV_EXPORT_DIALOG_SEPARATOR_LIST;
        i = 0;
        int defaultColumnSeparator = 0;
        while (i < separatorList.length) {
            this.separatorCombo.add(separatorList[i]);
            if (separatorList[i].toLowerCase().equals(this.options.getColumnSeparator())) {
                defaultColumnSeparator = i;
            }
            ++i;
        }
        this.separatorCombo.select(defaultColumnSeparator);
        label = new Label((Composite)formatGroup, 0);
        label.setText(Messages.ExportDialog_NullValue);
        this.nullValue = new Text((Composite)formatGroup, 2052);
        this.nullValue.setText(this.options.getNullValue());
        this.nullValue.setLayoutData((Object)new GridData(50, -1));
        Group optionsGroup = new Group(composite, 0);
        optionsGroup.setText(Messages.ExportDialog_Options);
        optionsGroup.setLayout((Layout)new GridLayout(1, true));
        this.includeHeadersButton = new Button((Composite)optionsGroup, 32);
        this.includeHeadersButton.setText(Messages.ExportDialog_IncludeHeaders);
        this.includeHeadersButton.setSelection(this.options.isIncludeColumnNames());
        this.quoteTextButton = new Button((Composite)optionsGroup, 32);
        this.quoteTextButton.setText(Messages.ExportDialog_QuoteTextValues);
        this.quoteTextButton.setSelection(this.options.isQuote());
        Group fileGroup = new Group(composite, 0);
        fileGroup.setText(Messages.ExportDialog_Destination);
        fileGroup.setLayout((Layout)new GridLayout(2, false));
        this.fileNameText = new Text((Composite)fileGroup, 2052);
        this.fileNameText.setLayoutData((Object)new GridData(300, -1));
        this.fileNameText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ExportDialog.this.updateButtons();
            }

            public void keyReleased(KeyEvent e) {
                ExportDialog.this.updateButtons();
            }
        });
        Button chooseButton = new Button((Composite)fileGroup, 0);
        chooseButton.setText(Messages.ExportDialog_Choose);
        chooseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ExportDialog.this.chooseFilename();
            }
        });
        composite.pack();
        this.updateButtons();
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.updateButtons();
        return control;
    }

    private void updateButtons() {
        String filename = this.fileNameText.getText();
        if (filename == null || filename.trim().length() == 0) {
            this.setErrorMessage(Messages.ExportDialog_DestinationRequired);
        } else {
            this.setErrorMessage(null);
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(filename != null && filename.trim().length() != 0);
        }
    }

    private void chooseFilename() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setFilterExtensions(this.exporter.getFileFilter());
        String fileName = fileDialog.open();
        fileName = FileDialogPatch.addFileExtensionIfRequired((String)fileName, (FileDialog)fileDialog);
        if (fileName != null && fileName.trim().length() != 0) {
            this.fileNameText.setText(fileName);
        }
        this.updateButtons();
    }

    protected void okPressed() {
        this.options.setCharacterSet(this.charsetCombo != null ? this.charsetCombo.getText() : null);
        this.options.setColumnSeparator(this.separatorCombo != null ? this.separatorCombo.getText() : null);
        if (this.options.getColumnSeparator() != null && this.options.getColumnSeparator().startsWith("\\t")) {
            this.options.setColumnSeparator("\t");
        }
        this.options.setIncludeColumnNames(this.includeHeadersButton != null && this.includeHeadersButton.getSelection());
        this.options.setQuote(this.quoteTextButton != null && this.quoteTextButton.getSelection());
        this.file = this.fileNameText != null ? this.fileNameText.getText() : null;
        this.options.setNullValue(this.nullValue != null ? this.nullValue.getText() : null);
        super.okPressed();
    }

    public String getFilename() {
        return this.file;
    }
}

