/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.indy.engine.Global;
import com.indy.engine.MemoryCleanerI;
import com.indy.engine.common.monitoring.DeliveryStepContent;
import com.indy.engine.core.common.RemoteSessionInfo;
import com.indy.engine.core.common.objects2.ActionDataExchange;
import com.indy.engine.core.common.objects2.ActionDataExchangeExt;
import com.indy.engine.core.common.objects2.IActionDataExchange;
import com.indy.engine.core.common.objects2.IActionDataExchangeExt;
import com.indy.engine.core.common.objects2.IEngineScheduleDetail;
import com.indy.engine.core.common.objects2.IIdDataExchange;
import com.indy.engine.core.common.objects2.ISessionDataExchange;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.main.ActionGraphLinkI;
import com.indy.engine.main.MainEngineEnv;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.action.IAction;
import com.indy.engine.main.action.statics.ActionStaticCode;
import com.indy.engine.main.action.statics.SessionStatic;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.main.repository.IMemoryDelivery;
import com.indy.engine.main.repository.internal.MemoryDelivery;
import com.indy.engine.manager.Action;
import com.indy.engine.manager.ActionCode;
import com.indy.engine.manager.ActionProcess;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.engine.rmi.EngineServerAPI_V1_2_temp;
import com.indy.engine.rmi.SessionFilterCriteria;
import com.indy.engine.scheduler.EngineSchedulerI;
import com.indy.engine.scheduler.impl.EngineSchedulerVersionI;
import com.indy.engine.service.Service;
import com.indy.engine.service.ServiceManager;
import com.indy.engine.service.ServiceState;
import com.indy.engine.userLog.IUserLogI;
import com.indy.engine.userLog.UserLogI;
import com.indy.engine.userLog.UserLogManagerI;
import com.indy.engine.userLog.reportLog.MemorySessionReportLogI;
import com.indy.engine.userLog.reportLog.ReportLogEngineI;
import com.indy.engine.wsdl.SoapService;
import com.indy.engine.wsdl.WsdlAPI;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import com.semarchy.xdi.engine.common.exceptions.SchedulerNotStartedExceptionI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;

public class EngineServerI {
    Map<String, MainEngineI> lstEngines = new ConcurrentHashMap<String, MainEngineI>();
    Map<String, ISessionDataExchange> lstLogSessions = new ConcurrentHashMap<String, ISessionDataExchange>();
    ReportLogEngineI reportLogEngine = null;
    MemoryCleanerI memoryCleaner = null;
    private ThreadPoolExecutor threadPool = null;
    SemaphoreManagerI semaphoreManager = null;
    String semaphore = null;
    public Object lock = new Object();
    private static String runtimeTechnicalVersion = "";
    private static String runtimeBrandingVersion = "";
    private final Logger logger = LogManager.getLogger(this.getClass());
    private CacheLoader<String, Optional<MainEngineI>> mainEngineLoader = new CacheLoader<String, Optional<MainEngineI>>(){

        public Optional<MainEngineI> load(String key) {
            return EngineServerI.this.loadMainEngineFromReport(key);
        }
    };
    private LoadingCache<String, Optional<MainEngineI>> mainEngineCache = EngineServerI.cacheBuilderSpecProperty("xdi.runtime.mainEngineCacheSpec", (CacheBuilder<Object, Object>)CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS)).build(this.mainEngineLoader);
    Thread stoppingThread;
    Object stoppingThreadLock = new Object();
    private static Map<String, EngineServerAPI_V1_2_temp.LogRMI> mapUser;

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("engineVersions", Global.locale);
        try {
            runtimeTechnicalVersion = bundle.getString("engineVersion");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            runtimeBrandingVersion = bundle.getString("engineBrandingVersion");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        mapUser = Collections.synchronizedMap(new HashMap());
    }

    private static CacheBuilder<Object, Object> cacheBuilderSpecProperty(String propName, CacheBuilder<Object, Object> defaultValue) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return defaultValue;
        }
        try {
            CacheBuilderSpec cacheBuilderSpec = CacheBuilderSpec.parse((String)propValue);
            return CacheBuilder.from((CacheBuilderSpec)cacheBuilderSpec);
        }
        catch (IllegalArgumentException e) {
            Global.dLog.write("EngineServerI", "System property " + propName + " is not a valid CacheBuilderSpec " + propValue + ". Using default value instead", 0, 0, "WARNING");
            return defaultValue;
        }
    }

    public EngineServerI() throws EngineExceptionI {
        try {
            this.semaphoreManager = new SemaphoreManagerI();
            if (Global.soapServerThreadPoolSize != null && !Global.soapServerThreadPoolSize.isEmpty()) {
                this.threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(Integer.parseInt(Global.soapServerThreadPoolSize));
            }
        }
        catch (OtherExceptionI e1) {
            throw new EngineExceptionI("Password managment exception, contact your supplier...", (Throwable)e1);
        }
    }

    void startMemoryCleaner() {
        this.memoryCleaner = new MemoryCleanerI(this);
        Thread t = new Thread(this.memoryCleaner);
        t.setDaemon(true);
        t.setName("MemoryCleaner");
        t.start();
    }

    void startReportEngine() throws EngineExceptionI {
        Global.dLog.write("EngineServerI()", "Starting report engine...", 0, 0, "INFO");
        this.reportLogEngine = new ReportLogEngineI();
        int ret = 0;
        try {
            ret = this.reportLogEngine.fillLstLogManager();
        }
        catch (Exception e) {
            throw new EngineExceptionI("Error initializing the report log manager list", (Throwable)e);
        }
        if (ret != 0) {
            throw new EngineExceptionI("Error initializing the session list");
        }
        Global.dLog.write("EngineServerI()", "Report engine started", 0, 0, "INFO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEngine(int type, int mode) throws Exception {
        Object object = this.stoppingThreadLock;
        synchronized (object) {
            if (this.stoppingThread != null) {
                throw new Exception("Runtime is already stopping");
            }
            Runnable runnable = () -> {
                try {
                    SoapService soap;
                    if (mode > 0) {
                        Service service = ServiceManager.INSTANCE.getService("scheduler");
                        if (service != null && service.getState() == ServiceState.Running) {
                            service.stop();
                        }
                        if ((service = ServiceManager.INSTANCE.getService("execution")) != null && service.getState() == ServiceState.Running) {
                            service.stop();
                        }
                    }
                    boolean sessionToStop = true;
                    while (sessionToStop) {
                        sessionToStop = false;
                        if (mode == 0) {
                            if (type == 0) {
                                System.exit(0);
                            } else if (type == 1) {
                                System.exit(-1111);
                            }
                        }
                        for (MainEngineI me : this.lstEngines.values()) {
                            if (me.getSessionStatus() != 2) continue;
                            sessionToStop = true;
                            if (mode == 1) {
                                me.stopSession(false);
                            }
                            me.getThread().join();
                        }
                    }
                    this.reportLogEngine.clean();
                    Service scheduler = ServiceManager.INSTANCE.getService("scheduler");
                    if (scheduler != null && scheduler.getState() == ServiceState.Running) {
                        scheduler.stop();
                    }
                    if ((soap = (SoapService)ServiceManager.INSTANCE.getService("http")) != null && soap.getState() == ServiceState.Running) {
                        soap.stop();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.warn("Unexpected", (Throwable)e);
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
                if (type == 1) {
                    System.exit(-1111);
                }
            };
            this.stoppingThread = new Thread(runnable);
            this.stoppingThread.setName("Stopping Runtime");
            this.stoppingThread.start();
        }
    }

    public boolean existDelivery(String pDelivName, String repo) throws Exception {
        return Global.getRepository(repo).exists(pDelivName);
    }

    public List<String> getLstDeliveries(String dir, Long maxlastModifiedDate) throws Exception {
        return Global.getRepository(dir).getLstDeliveries(maxlastModifiedDate);
    }

    public List<Delivery> getDeliveries(String dir, Long maxlastModifiedDate, List<String> ids) throws Exception {
        IDeliveryRepository dr = Global.getRepository(dir);
        return dr.getDeliveries(ids, maxlastModifiedDate);
    }

    public JobDetail getJobDetail(String name, String group) throws SchedulerException, EngineExceptionI {
        return this.getEngineScheduler().getJobDetail(name, group);
    }

    public boolean getIsSemaphore(String str) {
        return this.semaphoreManager.getIsSemaphore(str);
    }

    public String setSemaphore(boolean b, String str) throws OtherExceptionI {
        return this.semaphoreManager.setSemaphore(b, str);
    }

    public String getStringAsciiInfo(String str) throws OtherExceptionI {
        return this.semaphoreManager.getStringAsciiInfo(str);
    }

    public boolean getBooleanSemaphore(String str) throws OtherExceptionI {
        return this.semaphoreManager.getBooleanSemaphore(str);
    }

    public byte[] setByteSemaphore(byte[] in) throws OtherExceptionI {
        return this.semaphoreManager.setByteSemaphore(in);
    }

    public byte[] unsetByteSemaphore(byte[] in) throws OtherExceptionI {
        return this.semaphoreManager.unsetByteSemaphore(in);
    }

    public static Map<String, EngineServerAPI_V1_2_temp.LogRMI> getMapUser() {
        return mapUser;
    }

    public String initSession(String deliveryName, Map<String, Object> parameters, Map<String, String> variables) throws EngineExceptionI {
        MainEngineI m;
        String sessName;
        long l = System.currentTimeMillis();
        String vmid = null;
        if (Global.launchExecutionEngine) {
            String repoName;
            String configuration = parameters != null ? (String)parameters.get("configuration") : null;
            String string = repoName = parameters != null ? (String)parameters.get("dir") : null;
            if (repoName == null) {
                repoName = parameters != null ? (String)parameters.get("repository") : null;
            }
            String fullName = deliveryName;
            String string2 = sessName = parameters != null ? (String)parameters.get("sessName") : null;
            if (sessName == null) {
                sessName = parameters != null ? (String)parameters.get("sessionName") : null;
            }
            String parentSessionId = parameters != null ? (String)parameters.get("parentSessionId") : null;
            Integer parentSessionIter = parameters != null && parameters.get("parentSessionIter") != null ? (Integer)parameters.get("parentSessionIter") : 1;
            Integer logLevel = null;
            try {
                logLevel = parameters != null && parameters.get("logLevel") != null ? Integer.valueOf(parameters.get("logLevel") instanceof Integer ? (Integer)parameters.get("logLevel") : Integer.parseInt((String)parameters.get("logLevel"))) : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            Integer parentLogLevel = null;
            try {
                parentLogLevel = parameters != null && parameters.get("parentLogLevel") != null ? (Integer)parameters.get("parentLogLevel") : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            sessName = sessName == null ? fullName.replaceAll("\\\\", "/") : sessName;
            try {
                if (!this.existDelivery(deliveryName, repoName)) {
                    throw new EngineExceptionI("Delivery doesn't exists");
                }
            }
            catch (Exception e1) {
                throw new EngineExceptionI(e1.getMessage());
            }
            m = new MainEngineI(sessName, false, false);
            m.setExecutor(this.threadPool);
            m.setAsynchroneLog((UserLogManagerI.SynchMode)((Object)parameters.get("synchLogMode")));
            m.useDeliveryConfiguration(configuration);
            if (logLevel != null) {
                m.setLogLevel(logLevel);
            }
            if (parentLogLevel != null) {
                m.setParentLogLevel(parentLogLevel);
            }
            m.setParentSessionId(parentSessionId);
            m.setParentSessionIter(parentSessionIter);
            Object handlers = parameters.get("handlers");
            if (handlers != null && handlers instanceof List) {
                List list = (List)handlers;
                for (MainEngineI.EngineHandler handler : list) {
                    m.addHandler(handler);
                }
            }
            m.setLaunchMode((String)parameters.get("launchMode"));
            m.setExecutionMode((String)parameters.get("executionMode"));
            m.setGuestHost((String)parameters.get("guestHost"));
            vmid = MainEngineEnv.createId();
            IDeliveryRepository repo = Global.getRepository(repoName);
            try {
                m.initSession(repo.getMemoryDelivery(fullName, configuration), fullName, vmid);
            }
            catch (Exception e) {
                if (e instanceof EngineExceptionI) {
                    throw (EngineExceptionI)((Object)e);
                }
                throw new EngineExceptionI((Throwable)e);
            }
            if (variables != null && variables.size() > 0) {
                m.initVariables(variables);
            }
        } else {
            throw new EngineExceptionI("This engine can't execute sessions");
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.lstEngines.put(vmid, m);
        Global.dLog.write(sessName, "MainEngine->initSession", "Prepare duration: " + l3, 0, 0, "DEBUG");
        return vmid;
    }

    public String initSessionWithStream(Object inFile, String sessName, String fileName, boolean pDebugMode, String startMode, String guestHost, String parentSessionId, Integer parentSessionIter, String guestRuntimeHost, Integer guestRuntimePort, String configuration, Integer logLevel, Integer parentLogLevel) throws EngineExceptionI {
        String vmid;
        block19: {
            boolean forceStartSession = false;
            if (parentSessionId != null && startMode != null && guestRuntimeHost != null && guestRuntimePort != null && startMode.equals("ACTION") && Global.HTTP_HOST.equals(guestRuntimeHost) && guestRuntimePort.equals(Global.HTTP_PORT)) {
                forceStartSession = true;
            }
            long l = System.currentTimeMillis();
            vmid = null;
            if (Global.launchExecutionEngine) {
                try {
                    MainEngineI m = sessName != null ? new MainEngineI(sessName, pDebugMode, forceStartSession) : new MainEngineI(pDebugMode, forceStartSession);
                    if (logLevel != null) {
                        m.setLogLevel(logLevel);
                    }
                    if (parentLogLevel != null) {
                        m.setParentLogLevel(parentLogLevel);
                    }
                    m.setParentSessionId(parentSessionId);
                    if (parentSessionIter != null) {
                        m.setParentSessionIter(parentSessionIter);
                    } else {
                        m.setParentSessionIter(1);
                    }
                    m.setLaunchMode(startMode);
                    m.setExecutor(this.threadPool);
                    m.setExecutionMode("MEMORY");
                    m.setGuestHost(guestHost);
                    m.setSessionId();
                    m.setFileName(fileName);
                    if (configuration != null) {
                        m.useDeliveryConfiguration(configuration);
                    }
                    vmid = m.getSessionID();
                    InputStream io = (InputStream)inFile;
                    try {
                        String tmp;
                        String string = tmp = fileName != null ? new File(fileName).getName() : null;
                        if (tmp != null) {
                            tmp = tmp.substring(0, tmp.lastIndexOf(".deliv"));
                        }
                        if (m.initSession((IMemoryDelivery)new MemoryDelivery(io, tmp, configuration), tmp, vmid) != 0) {
                            throw new EngineExceptionI("The session couldn't be initialized");
                        }
                        m.getMemoryDelivery().getSessionStatic().setLogLevel(m.getLogLevel());
                        this.lstEngines.put(vmid, m);
                        long l2 = System.currentTimeMillis();
                        long l3 = l2 - l;
                        Global.dLog.write(sessName, "MainEngine->initSessionWithStream", "Prepare duration: " + l3, 0, 0, "DEBUG");
                        break block19;
                    }
                    finally {
                        if (io != null) {
                            try {
                                io.close();
                            }
                            catch (IOException e) {
                                this.logger.warn("unexpected", (Throwable)e);
                            }
                        }
                    }
                }
                catch (EngineExceptionI e) {
                    throw new EngineExceptionI("The session couldn't be initialized ", (Throwable)e);
                }
            }
            throw new EngineExceptionI("This engine can't execute sessions");
        }
        return vmid;
    }

    public void setProgressivesConnections(String sessionId, boolean b) {
        MainEngineI m;
        if (Global.launchExecutionEngine && (m = this.getMemoryEngine(sessionId)) != null) {
            m.setProgressivesConnections(b);
        }
    }

    public int getSessionStatus(String sessionId) {
        if (Global.launchExecutionEngine) {
            MainEngineI m = this.getMemoryEngine(sessionId);
            if (m != null) {
                return m.getSessionStatus();
            }
            return -99;
        }
        return -82;
    }

    public int executeSession(String sessionId, RemoteSessionInfo sessionInfo) throws EngineExceptionI {
        if (sessionInfo == null) {
            throw new RuntimeException("Null " + String.valueOf(RemoteSessionInfo.class) + " is not allowed");
        }
        if (Global.launchExecutionEngine) {
            try {
                MainEngineI m = this.getMemoryEngine(sessionId);
                if (m != null) {
                    m.setRemoteSessionInfo(sessionInfo);
                    if (Global.getXdgHarvestedManager().getXdgPublisher() != null) {
                        m.addHandler(Global.getXdgHarvestedManager().getXdgPublisher().createSessionHandler());
                    }
                    m.runMainEngine(false, false);
                    return m.getSessionStatus();
                }
                throw new EngineExceptionI("the session doesn't exist");
            }
            catch (NullPointerException e) {
                throw new EngineExceptionI("The session couldn't be initialized: " + e.getMessage());
            }
            catch (EngineExceptionI e) {
                throw new EngineExceptionI("The session couldn't be initialized: " + e.getMessage());
            }
        }
        throw new EngineExceptionI("This engine can't execute sessions");
    }

    public String getVersions() {
        Object ret = "";
        ret = (String)ret + "Engine : " + EngineServerI.getEngineTechnicalVersion() + System.getProperty("line.separator");
        ret = (String)ret + "Sheduler : " + EngineSchedulerVersionI.getVersion() + System.getProperty("line.separator");
        return ret;
    }

    public EngineSchedulerI getEngineScheduler() throws SchedulerNotStartedExceptionI {
        EngineSchedulerI scheduler = (EngineSchedulerI)ServiceManager.INSTANCE.getService("scheduler");
        if (scheduler != null && scheduler.getState() == ServiceState.Running) {
            return scheduler;
        }
        throw new SchedulerNotStartedExceptionI();
    }

    public IEngineScheduleDetail scheduleDelivery(String pDeliveryName, List pScheduleList) throws Exception {
        return this.getEngineScheduler().scheduleDelivery(pDeliveryName, pDeliveryName, 1, pScheduleList);
    }

    public IEngineScheduleDetail scheduleDelivery(String pDeliveryName, int executionMode, List<Map<String, Object>> pScheduleList) throws Exception {
        return this.getEngineScheduler().scheduleDelivery(pDeliveryName, pDeliveryName, executionMode, pScheduleList);
    }

    public IEngineScheduleDetail schedulePurgeLog(String pJobName, List<Map<String, Object>> pScheduleList, Map<String, Object> rules) throws Exception {
        return this.getEngineScheduler().schedulePurgeLog(pJobName, pScheduleList, rules);
    }

    public IEngineScheduleDetail scheduleDelivery(String pJobName, String pDeliveryName, int executionMode, List pScheduleList) throws Exception {
        return this.getEngineScheduler().scheduleDelivery(pJobName, pDeliveryName, executionMode, pScheduleList);
    }

    public IEngineScheduleDetail scheduleDelivery(String pDeliveryName, int executionMode, String httpHost, int httpPort, List pScheduleList) throws Exception {
        return this.getEngineScheduler().scheduleDelivery(pDeliveryName, pDeliveryName, executionMode, httpHost, httpPort, pScheduleList);
    }

    public IEngineScheduleDetail scheduleDelivery(String pJobName, String pDeliveryName, int executionMode, String httpHost, int httpPort, List<Map<String, Object>> pScheduleList, Map<String, Object> mapParameters, Integer logLevel) throws Exception {
        Global.getLogger().info("schedule delivery: " + pDeliveryName + " host: " + httpHost + " port: " + httpPort + " parameters: " + String.valueOf(mapParameters) + " logLevel: " + String.valueOf(logLevel));
        if (mapParameters != null) {
            return this.getEngineScheduler().scheduleDelivery(pJobName, pDeliveryName, executionMode, httpHost, httpPort, pScheduleList, mapParameters, logLevel);
        }
        return this.getEngineScheduler().scheduleDelivery(pJobName, pDeliveryName, executionMode, httpHost, httpPort, pScheduleList, null, logLevel);
    }

    public List<String> getLstTriggers() throws EngineExceptionI {
        return this.getEngineScheduler().getLstTriggers();
    }

    public IEngineScheduleDetail getTriggerDetail(String triggerName) throws EngineExceptionI {
        return this.getEngineScheduler().getTriggerDetail(triggerName);
    }

    public int removeJobTrigger(String triggerName) throws EngineExceptionI {
        return this.getEngineScheduler().removeJobTrigger(triggerName);
    }

    public int removeJobAndTriggers(String jobName) throws EngineExceptionI {
        return this.getEngineScheduler().removeJobAndTriggers(jobName);
    }

    public List<IEngineScheduleDetail> getLstSchedules(String jobName) throws EngineExceptionI {
        return this.getEngineScheduler().getLstSchedules(jobName);
    }

    public int deleteLog(String logName, Date untilDate) {
        int ret = 0;
        return ret;
    }

    public int deleteLogs(Date untilDate) {
        int ret = 0;
        return ret;
    }

    public int purgeLog(String logName, Date untilDate, List<String> filters, List<Integer> statusList) {
        int ret = 0;
        try {
            this.reportLogEngine.purgeLog(logName, untilDate, filters, statusList);
        }
        catch (EngineExceptionI e) {
            ret = -1;
        }
        return ret;
    }

    public int purgeLogs(Date untilDate, List<String> filters, List<Integer> statusList, boolean currentRuntime) {
        int ret = 0;
        SimpleDateFormat dateFormat = new SimpleDateFormat(Global.GLOBAL_DATE_FORMAT);
        try {
            this.reportLogEngine.purgeLogs(untilDate, filters, statusList, currentRuntime);
        }
        catch (EngineExceptionI e) {
            System.out.println("PurgeLogs : " + e.getMessage());
            System.out.println(e.getStackTraceString());
            ret = -1;
        }
        return ret;
    }

    public int purgeLogs(int nbSessions, List<String> filters, List<Integer> statusList, boolean currentRuntime) {
        int ret = 0;
        SimpleDateFormat dateFormat = new SimpleDateFormat(Global.GLOBAL_DATE_FORMAT);
        try {
            this.reportLogEngine.purgeLogs(nbSessions, filters, statusList, currentRuntime);
        }
        catch (EngineExceptionI e) {
            System.out.println("PurgeLogs : " + e.getMessage());
            System.out.println(e.getStackTraceString());
            ret = -1;
        }
        return ret;
    }

    int deleteMemorySession(String sessionId) {
        int ret = 0;
        MainEngineI m = null;
        try {
            if (sessionId != null && this.lstEngines.containsKey(sessionId) && (m = this.getMemoryEngine(sessionId)).getSessionStatus() != 9 && m.getSessionStatus() != 2 && m.getSessionStatus() != 6) {
                this.lstEngines.remove(sessionId);
                m.clear();
                m = null;
            }
        }
        catch (Exception e) {
            this.logger.info("deleteMemorySession : ", (Throwable)e);
            ret = -1;
        }
        return ret;
    }

    int deleteLogSession(String sessionId, int logLevel) {
        int ret = 0;
        ISessionDataExchange sde = null;
        try {
            if (this.lstLogSessions.containsKey(sessionId)) {
                sde = this.lstLogSessions.get(sessionId);
                this.reportLogEngine.deleteSession(sessionId, sde.getLogName(), logLevel);
                this.lstLogSessions.remove(sessionId);
            }
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public int deleteSession(String sessionId, int logLevel) {
        int ret = 0;
        try {
            this.deleteMemorySession(sessionId);
            this.deleteLogSession(sessionId, logLevel);
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public int cleanMemoryClosedSessions() {
        int ret = 1;
        ArrayList<String> toDel = new ArrayList<String>();
        try {
            for (MainEngineI me : this.lstEngines.values()) {
                if (me.isClosing() || me.getSessionStatus() == 6 || me.getSessionStatus() == 2 || me.getSessionStatus() == 9 || me.getSessionStatus() == 10 || me.getDebugMode()) continue;
                toDel.add(new String(me.getSessionID()));
            }
            Iterator<MainEngineI> it = null;
            for (String strME : toDel) {
                MainEngineI me;
                me = this.lstEngines.get(strME);
                this.lstEngines.remove(strME);
                ISessionDataExchange sde = me.getSessionDataExchange();
                sde.setLogType("log");
                sde.setLogClassName(me.lstLogProperties.get("userLogClass"));
                sde.setLogName(me.lstLogProperties.get("userLogName"));
                sde.setConfiguration(me.getConfiguration());
                sde.setGuestHost(me.getGuestHost());
                sde.setLaunchMode(me.getLaunchMode());
                sde.setLaunchUser(me.getLaunchUser());
                this.lstLogSessions.put(strME, sde);
            }
            Iterator it2 = null;
            toDel.clear();
            toDel = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public int restartSession(String sessionId, RemoteSessionInfo remoteSessionInfo) throws EngineExceptionI {
        MainEngineI m = null;
        if (Global.launchExecutionEngine) {
            try {
                m = this.getMemoryEngine(sessionId);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (m == null) {
                block18: {
                    try {
                        if (this.lstLogSessions != null && !this.lstLogSessions.containsKey(sessionId)) {
                            ArrayList<SessionFilterCriteria> list = new ArrayList<SessionFilterCriteria>();
                            ArrayList<String> _list = new ArrayList<String>();
                            _list.add(sessionId);
                            HashMap<String, Object> criteria = new HashMap<String, Object>();
                            criteria.put("sessionList", _list);
                            list.add(new SessionFilterCriteria(criteria));
                            this.getLstSession(1, list);
                        }
                        m = this.getMainEngineFromReport(sessionId);
                        if (m.uLog.isConnected()) break block18;
                        try {
                            if (m.uLog != null) {
                                m.uLog.initLog(m.lstLogProperties, Global.USERLOG_DEFAULT_NAME, "u");
                            }
                        }
                        catch (EngineExceptionI e) {
                            return -1;
                        }
                    }
                    catch (NullPointerException e) {}
                }
                this.lstEngines.put(sessionId, m);
                this.lstLogSessions.remove(sessionId);
            } else {
                try {
                    m.uLog.initLog(m.lstLogProperties, Global.USERLOG_DEFAULT_NAME, "u");
                }
                catch (EngineExceptionI e) {
                    return -1;
                }
            }
            if (m != null) {
                if (m.getSessionStatus() != 1) {
                    try {
                        m.setSessionStatus(10);
                        m.setRemoteSessionInfo(remoteSessionInfo);
                        m.runMainEngine(true, false);
                        return 2;
                    }
                    catch (EngineExceptionI e) {
                        this.logger.warn("unexpected", (Throwable)e);
                        return -1;
                    }
                }
                throw new EngineExceptionI("This session can't be restart by engine");
            }
            throw new EngineExceptionI("Could not retrieve session " + sessionId + " (session does not exist or there was an issue while retrieving it)");
        }
        throw new EngineExceptionI("This engine can't execute sessions");
    }

    public int stopSession(String sessionId, boolean waitMode) throws InterruptedException {
        int ret = 0;
        File ctrlFile = new File("sessions" + File.separator + sessionId + ".session");
        if (ctrlFile.exists()) {
            ctrlFile.delete();
        }
        if (Global.launchExecutionEngine) {
            MainEngineI m = this.getMemoryEngine(sessionId);
            ret = m != null ? m.stopSession(waitMode) : -1;
        }
        return ret;
    }

    public boolean isRunningSession(String sessionId) {
        Boolean ret = false;
        if (Global.launchExecutionEngine) {
            MainEngineI m = this.getMemoryEngine(sessionId);
            ret = m != null ? Boolean.valueOf(m.getIsRunning()) : Boolean.valueOf(false);
        }
        return ret;
    }

    public int markInactiveSessionsAsDead() {
        int inactiveSessionsCounter = 0;
        Map<String, ISessionDataExchange> sessionDataExchangeMap = this.reportLogEngine.getAllInactiveSessions();
        if (sessionDataExchangeMap != null) {
            for (String sessionId : sessionDataExchangeMap.keySet()) {
                ISessionDataExchange sde;
                if (this.existsSessionInMemoryEngine(sessionId) || (sde = sessionDataExchangeMap.get(sessionId)) == null || sde.getEndDate() != null || sde.getStatus() != 0) continue;
                try {
                    MainEngineI mEngine = new MainEngineI(0, sde.getLogName(), false, sde.getName(), sessionId);
                    mEngine.setSessionStatic(new SessionStatic());
                    mEngine.setBeginDate(sde.getBeginDate());
                    mEngine.setEndDate(new Date());
                    mEngine.setSessionStatus(-4);
                    mEngine.setSessionMsg("Session is DEAD");
                    mEngine.closeLogSession();
                    mEngine.clear();
                    mEngine = null;
                    ++inactiveSessionsCounter;
                }
                catch (Exception e) {
                    Global.dLog.write(sde.getName(), "EngineServerI::markInactiveSessionsAsDead()", "EngineExceptionI : " + e.getMessage(), 0, 0, "ERROR");
                }
            }
        }
        return inactiveSessionsCounter;
    }

    protected MainEngineI getMainEngineFromReport(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        return ((Optional)this.mainEngineCache.getUnchecked((Object)sessionId)).orElse(null);
    }

    private Optional<MainEngineI> loadMainEngineFromReport(String sessionId) {
        MainEngineI m;
        block9: {
            m = null;
            MemorySessionReportLogI mSRL = null;
            ISessionDataExchange sde = null;
            if (sessionId != null) {
                try {
                    if (this.lstLogSessions == null || !this.lstLogSessions.containsKey(sessionId)) break block9;
                    sde = this.lstLogSessions.get(sessionId);
                    try {
                        Global.dLog.write("ReportEngineServer", "ReportLogEngineI->loadReportSession", "Loading session report : " + sessionId, 0, 0, "DEBUG");
                        mSRL = new MemorySessionReportLogI(sessionId);
                        try {
                            mSRL.loadSession(sessionId, sde.getLogName(), sde.getName());
                        }
                        catch (Throwable t) {
                            mSRL.setStatus(-1);
                            mSRL.setMainEngine(null);
                            mSRL.setLastAccess(new Date());
                            throw t;
                        }
                        Global.dLog.write("ReportEngineServer", "ReportLogEngineI->loadReportSession", "Session report : " + sessionId + " loaded", 0, 0, "DEBUG");
                        if (mSRL != null) {
                            m = mSRL.getMainEngine();
                            if (sde.getStatus() == -4) {
                                m.setEndDate(new Date());
                                m.setSessionStatus(sde.getStatus());
                                m.setSessionMsg("Session is DEAD");
                                m.closeLogSession();
                            }
                        }
                    }
                    catch (Throwable e) {
                        Global.getLogger().error("getMainEngineFromReport, sessionId: " + sessionId, e);
                        m = null;
                    }
                }
                catch (NullPointerException e2) {
                    Global.getLogger().error("Error", (Throwable)e2);
                    m = null;
                }
            }
        }
        return Optional.ofNullable(m);
    }

    public Map<String, IIdDataExchange> getLstInstanciatedIds(String sessionId, String altId) {
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            return m.getLstIds(altId);
        }
        m = null;
        return null;
    }

    public String getEngineName(String sessionId) {
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            return m.getMainEngineName();
        }
        return null;
    }

    public Date getEngineDate(String sessionId) {
        Date ret = null;
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            return m.getMainEngineDate();
        }
        return ret;
    }

    public int getActionStatus(String sessionId, String actionId) {
        int retCode = 0;
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            retCode = m.lstActionsId.get(actionId).getActionState();
            if (retCode == 4 || retCode == 3) {
                retCode = 2;
            }
            Object aName = null;
            m = null;
        }
        return retCode;
    }

    private MainEngineI getMemoryEngine(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        return this.lstEngines.get(sessionId);
    }

    public String getActionName(String sessionId, String actionId) {
        MainEngineI m = this.getMainEngine(sessionId);
        String aName = null;
        if (m != null) {
            aName = m.lstActionsId.get(actionId).getActionName();
            m = null;
        }
        return aName;
    }

    public String getActionId(String sessionId, String actionName) {
        MainEngineI m = this.getMainEngine(sessionId);
        String aID = null;
        if (m != null) {
            aID = m.getActionId(actionName);
            m = null;
        }
        return aID;
    }

    public List getLstChildIds(String sessionId, String actionId) {
        MainEngineI m = this.getMainEngine(sessionId);
        List tm = null;
        if (m != null && actionId != null) {
            IAction act = m.lstActionsId.get(actionId);
            if (act != null && act.isProcess()) {
                tm = ((ActionProcess)act).getLstChildIds();
            }
            m = null;
        }
        return tm;
    }

    public MainEngineI getMainEngine(String sessionId) {
        MainEngineI m = this.getMemoryEngine(sessionId);
        if (m == null) {
            m = this.getMainEngineFromReport(sessionId);
        }
        return m;
    }

    public String getActionFatherId(String sessionId, String actionId) {
        MainEngineI m = this.getMainEngine(sessionId);
        String aId = null;
        if (m != null) {
            aId = m.lstActionsId.get(actionId).getActionFatherId();
            m = null;
        }
        return aId;
    }

    public String getActionCode(String sessionId, String actionId) {
        Object aName = null;
        String ret = null;
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            ret = ((ActionCode)m.lstActionsId.get(actionId)).getActionTxtCode();
            aName = null;
            m = null;
        }
        return ret;
    }

    public String getActionExecutedCode(String sessionId, String actionId) {
        MainEngineI m = this.getMainEngine(sessionId);
        Object aName = null;
        String ret = null;
        if (m != null) {
            ret = ((ActionCode)m.lstActionsId.get(actionId)).getActionExecutedCode();
            aName = null;
            m = null;
        }
        return ret;
    }

    @Deprecated
    public String getActionTxtCode(String sessionId, String actionId) {
        return this.getActionCode(sessionId, actionId);
    }

    public long getActionDuration(String sessionId, String actionId) {
        MainEngineI m = this.getMainEngine(sessionId);
        Object aName = null;
        Date deb = null;
        Date fin = null;
        long ret = -1L;
        if (m != null) {
            IAction act = m.lstActionsId.get(actionId);
            deb = act.getBeginDate();
            fin = act.getEndDate();
            if (deb != null && fin != null) {
                ret = fin.getTime() - deb.getTime();
                deb = null;
                fin = null;
                aName = null;
                m = null;
            }
        }
        return ret;
    }

    public Variable getActionVariable(String sessionId, String actionId, String variableName) {
        IAction act;
        Variable aVariable = null;
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null && (act = (IAction)m.lstActionsId.get(actionId)) != null) {
            aVariable = act.getActionVariable(variableName);
        }
        return aVariable;
    }

    @Deprecated
    public Variable getActionParameter(String sessionId, String actionId, String variableName) {
        return this.getActionVariable(sessionId, actionId, variableName);
    }

    public IActionDataExchange getActionInfo(String sessionId, String actionId) {
        ActionDataExchange ade = null;
        MainEngineI m = this.getMainEngine(sessionId);
        IAction act = null;
        if (m != null) {
            try {
                act = m.lstActionsId.get(actionId);
                ade = new ActionDataExchange(act.getActionName(), act.getActionRuntimeName(), act.getActionId(), act.getActionState(), act.getBeginDate(), act.getEndDate(), new Date());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return ade;
    }

    public DeliveryStepContent getProcessContent(String sessionId, String processId) throws Exception {
        MainEngineI m = this.getMainEngine(sessionId);
        if (m == null) {
            this.getLstSession(-1, Collections.emptyList());
            m = this.getMainEngine(sessionId);
            if (m == null) {
                return null;
            }
        }
        IAction act = m.lstActionsId.get(processId);
        String mainIterationGroup = null;
        for (String k : act.getActionStatic().getAltIds().keySet()) {
            String v = act.getActionStatic().getAltIds().get(k);
            if (!v.equals("iterationGroup")) continue;
            mainIterationGroup = k;
            break;
        }
        if (act instanceof ActionProcess) {
            DeliveryStepContent content = new DeliveryStepContent(sessionId, act.getActionId(), act.getActionName());
            ArrayList<DeliveryStepContent.Link> links = new ArrayList<DeliveryStepContent.Link>();
            for (Action a : ((ActionProcess)act).getChildren().values()) {
                DeliveryStepContent.Step s = null;
                s = new DeliveryStepContent.Step(a.getActionName(), a.getActionId(), "Process".equals(a.getActionType()), !"Process".equals(a.getActionType()) ? ((ActionStaticCode)a.getActionStatic()).getActionTechnology() : null, a.getActionState());
                content.getSteps().add(s);
                s.getAltIds().putAll(a.getActionStatic().getAltIds());
                if (mainIterationGroup != null) {
                    s.getAltIds().remove(mainIterationGroup);
                }
                try {
                    if (a.getBeginDate() != null) {
                        s.getProperties().put("beginDate", "" + a.getBeginDate().getTime());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (a.getEndDate() != null) {
                        s.getProperties().put("endDate", "" + a.getEndDate().getTime());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Enumeration<ActionGraphLinkI> e = a.getActionChildGraphLink();
                while (e.hasMoreElements()) {
                    ActionGraphLinkI link = e.nextElement();
                    links.add(new DeliveryStepContent.Link(link.getActionSource().getActionId(), link.getActionTarget().getActionId(), link.getState()));
                }
            }
            content.getLinks().addAll(links);
            return content;
        }
        return null;
    }

    public IActionDataExchangeExt getActionExtInfo(String sessionId, String actionId) {
        ActionDataExchangeExt ade = null;
        MainEngineI m = this.getMainEngine(sessionId);
        IAction act = null;
        if (m != null) {
            try {
                act = m.lstActionsId.get(actionId);
                ade = new ActionDataExchangeExt(act.getActionName(), act.getActionId());
                ade.setState(act.getActionState());
                ade.setBeginDate(act.getBeginDate());
                ade.setEndDate(act.getEndDate());
                ade.setModifDate(new Date());
                if (act.getEndDate() != null) {
                    ade.setIter(act.getNbExecution());
                } else {
                    ade.setIter(act.getNbExecution() + 1);
                }
                ade.setTolerated(act.getActionStatic().getToleratedError());
                ade.setType(act.getActionStatic().getActionType());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return ade;
    }

    public ISessionDataExchange getSessionInfo(String sessionId) {
        ISessionDataExchange sde = null;
        MainEngineI m = null;
        String lType = "Memory";
        try {
            m = this.getMemoryEngine(sessionId);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (m == null) {
            try {
                sde = this.lstLogSessions.get(sessionId);
                lType = "Log";
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            sde = m.getSessionDataExchange();
            sde.setEngineHost(Global.HTTP_HOST);
            sde.setEnginePort(Integer.valueOf(Global.HTTP_PORT));
            sde.setLogClassName(m.lstLogProperties.get("userLogClass"));
            sde.setProcessId(m.getSessionStatic().getProcId());
            sde.setLogType(lType);
        }
        return sde;
    }

    private boolean existsSessionInMemoryEngine(String sessionId) {
        return this.lstEngines.containsKey(sessionId);
    }

    Map<String, ISessionDataExchange> getLstLogSessions(int nbSessions, List<SessionFilterCriteria> lstfilters) {
        Global.dLog.write("EngineServerI::getLstLogSessions()", "Getting LOG sessions with criteria...", 0, 0, "DEBUG");
        Map<String, ISessionDataExchange> sessionMap = this.reportLogEngine.getAllSessions(nbSessions, lstfilters);
        for (Map.Entry<String, ISessionDataExchange> entry : sessionMap.entrySet()) {
            if (this.existsSessionInMemoryEngine(entry.getKey())) continue;
            ISessionDataExchange sde = entry.getValue();
            if (sde.getEngineHost().equals(Global.HTTP_HOST) && sde.getEnginePort().intValue() == Global.HTTP_PORT.intValue() && !sde.isStartByCommand() && !this.isRootSessiontStartByCommand(sessionMap, sde.getParentSessionId()) && sde.getEndDate() == null && sde.getStatus() == 2 || sde.getStatus() == 9) {
                sde.setStatus(-4);
            }
            this.lstLogSessions.put(entry.getKey(), entry.getValue());
        }
        Global.dLog.write("EngineServerI::getLstSessions()", "LOG Sessions OK", 0, 0, "DEBUG");
        return sessionMap;
    }

    private boolean isRootSessiontStartByCommand(Map<String, ISessionDataExchange> sessionMap, String sessionId) {
        ISessionDataExchange currentSession;
        if (sessionId != null && (currentSession = sessionMap.get(sessionId)) != null) {
            return currentSession.isStartByCommand() || this.isRootSessiontStartByCommand(sessionMap, currentSession.getParentSessionId());
        }
        return false;
    }

    public Map<String, ISessionDataExchange> getLstSession(int nbSessions, List<SessionFilterCriteria> lstfilters) {
        if (nbSessions == -1) {
            nbSessions = Global.DEFAULT_SESSION_REPORT_NUMBER;
        }
        if (nbSessions == -2) {
            nbSessions = 0x7FFFFFFE;
        }
        boolean realTimeOnly = false;
        if (lstfilters != null && !lstfilters.isEmpty()) {
            realTimeOnly = true;
            for (SessionFilterCriteria sfc : lstfilters) {
                if (sfc.isCurrentEngine() && sfc.getLstStatus() != null && sfc.getLstStatus().size() == 1 && sfc.getLstStatus().contains(2)) continue;
                realTimeOnly = false;
            }
        }
        Global.dLog.write("EngineServerI::getLstSessions()", "Getting sessions with criteria...", 0, 0, "DEBUG");
        TreeMap<String, ISessionDataExchange> tm = new TreeMap<String, ISessionDataExchange>();
        for (String sess : new HashSet<String>(this.lstEngines.keySet())) {
            MainEngineI m = this.getMemoryEngine(sess);
            if (m != null) {
                ISessionDataExchange sde = m.getSessionDataExchange();
                sde.setLogType("Memory");
                sde.setLogClassName(m.lstLogProperties.get("userLogClass"));
                sde.setEngineHost(Global.HTTP_HOST);
                sde.setEnginePort(Global.HTTP_PORT);
                sde.setLogName(m.lstLogProperties.get("userLogName"));
                if (!UserLogI.verifFilters(sde, lstfilters)) continue;
                tm.put(m.getSessionID(), sde);
                continue;
            }
            this.lstEngines.remove(sess);
        }
        if (!realTimeOnly) {
            Map<String, ISessionDataExchange> tm2 = this.getLstLogSessions(nbSessions, lstfilters);
            for (String key2 : tm2.keySet()) {
                ISessionDataExchange sde2 = tm2.get(key2);
                if (key2 == null || sde2 == null) continue;
                try {
                    if (tm.containsKey(key2) || !UserLogI.verifFilters(sde2, lstfilters)) continue;
                    tm.put(key2, sde2);
                }
                catch (Exception e) {
                    Global.dLog.write("EngineServerI::getLstSessions()", "Error during verifing filters for the session " + key2, 0, 0, "DEBUG");
                }
            }
            tm2.clear();
        }
        Global.dLog.write("EngineServerI::getLstSessions()", "Lst Sessions with criteria OK", 0, 0, "DEBUG");
        return tm;
    }

    public Variable aggregateVariable(String sessionId, String actionId, String variableName, int function, String startingPath, String valueFilter) {
        Variable var = null;
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            try {
                var = m.aggregateVariable(m.lstActionsId.get(actionId).getActionName(), variableName, function, startingPath, valueFilter);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return var;
    }

    public Map<String, Variable> getLstRootSessionVariables(String sessionId) {
        Map<String, Variable> lstVar = null;
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            try {
                lstVar = m.getLstRootSessionVariables();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return lstVar;
    }

    public Map<String, Variable> getLstSessionErrors(String sessionId) {
        Map<String, Variable> lstVar = null;
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            try {
                lstVar = m.getLstSessionErrors();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return lstVar;
    }

    public Map<String, Variable> getLstSessionWarnings(String sessionId) {
        Map<String, Variable> lstVar = null;
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            try {
                lstVar = m.getLstSessionWarnings();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return lstVar;
    }

    public Map<String, Variable> getActionLstVariables(String sessionId, String actionId) {
        MainEngineI m = this.getMainEngine(sessionId);
        Object aName = null;
        Map<String, Variable> lstVar = null;
        if (m != null) {
            try {
                lstVar = m.lstActionsId.get(actionId).getActionLstVariables();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return lstVar;
    }

    public Map<String, Variable> getSessionLstVariables(String sessionId) {
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            return m.getEngineContext().getRootContainer().getAllCopiedVariables(null);
        }
        return null;
    }

    public Map<String, String> getLstChildSession(String sessionId) {
        TreeMap<String, String> tm = null;
        String sess2 = null;
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            tm = new TreeMap<String, String>();
            try {
                for (String sess2 : m.lstChildSessions.keySet()) {
                    tm.put(sess2, m.lstChildSessions.get(sess2));
                }
                Iterator<String> it = null;
            }
            catch (NullPointerException e) {
                tm = null;
            }
        }
        return tm;
    }

    public void setActionStatus(String sessionId, String actionId, int actionStatus) {
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            m.lstActionsId.get(actionId).setActionState(actionStatus);
        }
    }

    public void setActionVariableByName(String sessionId, String variableName, Variable actionVariable) {
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            m.engineContext.addVariable(actionVariable);
        }
    }

    public Variable aggregateVariable(String pSessionId, String pIActiond, String pVvariableName, int pFunction, String pStartingPath) {
        return this.aggregateVariable(pSessionId, pIActiond, pVvariableName, pFunction, pStartingPath, "$NO_SCRIPT$");
    }

    public SoapService getSoapService() throws EngineExceptionI {
        SoapService service = (SoapService)ServiceManager.INSTANCE.getService("http");
        if (service != null && service.getState() == ServiceState.Running) {
            return service;
        }
        throw new EngineExceptionI("Scheduler is not started", -180);
    }

    public WsdlAPI getWsdlAPI() {
        return SoapService.getWsdlApi();
    }

    public void pauseTrigger(String triggerName, String triggerGroup) throws Exception {
        this.getEngineScheduler().pauseTrigger(triggerName, triggerGroup);
    }

    public void resumeTrigger(String triggerName, String triggerGroup) throws Exception {
        this.getEngineScheduler().resumeTrigger(triggerName, triggerGroup);
    }

    public Map<String, IIdDataExchange> getActionAltIds(String sessionId, String actionId) {
        MainEngineI m = this.getMainEngine(sessionId);
        if (m != null) {
            return m.getSessionStatic().getAltIds(actionId);
        }
        return null;
    }

    public IUserLogI getULog() {
        return this.reportLogEngine.getuLog();
    }

    public static String getEngineBrandingVersion() {
        return runtimeBrandingVersion;
    }

    public static String getEngineTechnicalVersion() {
        return runtimeTechnicalVersion;
    }
}

