/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine;

import com.indy.engine.EngineServerI;
import com.indy.engine.Global;
import com.indy.engine.InternalDatabase;
import com.indy.engine.compiler.CompileAndLoad;
import com.indy.engine.service.ServiceManager;
import com.indy.engine.userLog.reportLog.ReportLogManagerI;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EngineStartI {
    private static Logger logger = LogManager.getLogger(EngineStartI.class);
    static EngineStartI INSTANCE = new EngineStartI();

    public static void writeUsage() {
        System.out.println("Usage : ");
        System.out.println("\tcommand [-port httpPort] [-conf propertyFileName]");
        System.out.println("");
        System.out.println("Parameters : ");
        System.out.println("\t-usage -> some help on the command");
        System.out.println("\t-port <httpPort> -> the HTTP TCP/IP port on wich the engine can be accessed");
        System.out.println("\t-conf <propertyFileName> -> an engine parameters file");
        System.out.println("\t-updatedb");
    }

    private static int init(String[] args) throws EngineExceptionI {
        String port = null;
        String fileConf = null;
        int i = 0;
        while (i < args.length) {
            block18: {
                if (args[i].equalsIgnoreCase("-wait")) {
                    if (i == args.length - 1) {
                        System.err.println("The -wait argument must be followed by a number of millisecond");
                        EngineStartI.writeUsage();
                        System.exit(-1);
                    }
                    try {
                        Thread.sleep(++i);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new EngineExceptionI((Throwable)e);
                    }
                }
                if (args[i].equalsIgnoreCase("-usage")) {
                    EngineStartI.writeUsage();
                    System.exit(-1);
                } else if (args[i].equalsIgnoreCase("-port")) {
                    if (i == args.length - 1) {
                        System.err.println("The -port argument must be followed by a file port number");
                        EngineStartI.writeUsage();
                        System.exit(-1);
                    }
                    port = args[++i];
                } else {
                    if (args[i].equalsIgnoreCase("-conf")) {
                        if (i == args.length - 1) {
                            System.err.println("The -conf argument must be followed by an engine configuration file path");
                            EngineStartI.writeUsage();
                            System.exit(-1);
                        }
                        fileConf = args[++i];
                        try {
                            File f = new File(fileConf);
                            if (!f.exists()) {
                                throw new EngineExceptionI("Engine parameters file not found");
                            }
                            break block18;
                        }
                        catch (Exception e) {
                            throw new EngineExceptionI("Problems accessing the engine parameters file", (Throwable)e);
                        }
                    }
                    if (args[i].equalsIgnoreCase("-updatedb")) {
                        Global.onlylogupdate = true;
                    }
                }
            }
            ++i;
        }
        if (fileConf != null) {
            Global.XML_ENGINE_REPOSITORY = fileConf;
        }
        int res = Global.InitRessources(false);
        if (port != null) {
            Global.HTTP_PORT = Integer.parseInt(port);
        }
        return res;
    }

    public static void main(String[] args) throws Throwable {
        Global.args = args;
        try {
            int ret = EngineStartI.init(args);
            if (ret != 0) {
                logger.error("Fatal error ! Ressource initialization not possible...");
                System.exit(-3);
            }
            if (Global.onlylogupdate) {
                EngineStartI.updatingDatabaseOnly();
            } else {
                EngineStartI.initMainServer();
                InternalDatabase db = new InternalDatabase();
                db.prepareSystemDatabase();
                Global.engineServer.startReportEngine();
                Global.engineServer.startMemoryCleaner();
                Global.dLog.write("EngineServerI()", "Engine Started !", 0, 0, "INFO");
                ServiceManager.INSTANCE.startService("listener");
                ServiceManager.INSTANCE.startService("execution");
                if (Global.engineServer != null) {
                    if (Global.launchSchedulerEngine) {
                        ServiceManager.INSTANCE.startService("scheduler");
                    }
                    EngineStartI.startHttpService();
                }
            }
        }
        catch (Throwable e) {
            logger.error("An error occured during runtime startup", e);
            throw e;
        }
    }

    private static void startHttpService() {
        try {
            ServiceManager.INSTANCE.startService("http");
        }
        catch (Throwable e) {
            logger.warn("an error occured while starting the Http Service", e);
        }
    }

    private static void initMainServer() throws Throwable {
        Global.engineServer = new EngineServerI();
        Thread.currentThread().setName("RuntimeMainThread");
        Global.getConsoleLogger().info("Runtime version: " + EngineServerI.getEngineBrandingVersion());
        String version = System.getProperty("java.version");
        String vendor = System.getProperty("java.vendor");
        String home = System.getProperty("java.home");
        String jvm = (String)(version != null ? "version: " + version : "") + (String)(vendor != null ? " vendor: " + vendor : "") + (String)(home != null ? " home: " + home : "");
        Global.getConsoleLogger().info("Java " + jvm);
        Global.dLog.write("Engine Server", "main : starting engine", 0, 0, "INFO");
        if (Global.javaExtensionpath != null && !Global.javaExtensionpath.isEmpty() && new File(Global.javaExtensionpath).exists()) {
            CompileAndLoad compileAndLoad = new CompileAndLoad(Global.javaExtensionpath);
            compileAndLoad.compile();
            try {
                compileAndLoad.loadClassPath((URLClassLoader)ClassLoader.getSystemClassLoader());
            }
            catch (Exception e) {
                Global.getConsoleLogger().info("Error when loading Java extension");
                Global.getLogger().error("Error", (Throwable)e);
            }
        }
    }

    private static void updatingDatabaseOnly() {
        Global.getConsoleLogger().info("Updating Database...");
        try {
            try {
                Global.logRetryNumber = 1;
                Global.getLstLogParametersInRepository(Global.USERLOG_DEFAULT_NAME);
                ReportLogManagerI rep = new ReportLogManagerI(Global.USERLOG_DEFAULT_NAME);
                rep.init();
                Global.getConsoleLogger().info("Connection...");
                rep.connect();
                Global.getConsoleLogger().info("Connected, version: " + rep.getVesion());
                Global.getConsoleLogger().info("Updating...");
                rep.updateLog(true);
                Global.getConsoleLogger().info("Updated to: " + rep.getVesion());
            }
            catch (Exception e) {
                Global.getConsoleLogger().error("Error during updating", (Throwable)e);
                System.exit(0);
            }
        }
        finally {
            System.exit(0);
        }
    }

    public static final class JavaProcess {
        private JavaProcess() {
        }

        public static int exec(Class klass, String[] args) throws IOException, InterruptedException {
            String javaHome = System.getProperty("java.home");
            String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
            String classpath = System.getProperty("java.class.path");
            String className = klass.getCanonicalName();
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(javaBin);
            list.add("-cp");
            list.add(classpath);
            list.add(className);
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (!arg.equals("-separate")) {
                    list.add(arg);
                }
                ++n2;
            }
            list.add("-wait");
            list.add("1000");
            ProcessBuilder builder = new ProcessBuilder(javaBin, "-cp", classpath, className);
            Process process = builder.start();
            return 0;
        }
    }
}

