/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine;

import com.indy.engine.Global;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class WrapperServerSocket
extends ServerSocket {
    private ServerSocket base;
    private Map<Socket, Date> mapUser;

    public WrapperServerSocket(ServerSocket b, Map<Socket, Date> mapUser) throws IOException {
        this.base = b;
        this.mapUser = mapUser;
    }

    @Override
    public int getLocalPort() {
        return this.base.getLocalPort();
    }

    @Override
    public Socket accept() throws IOException {
        Socket baseSocket = this.base.accept();
        System.out.println("ACCEPTING CLIENT:" + String.valueOf(baseSocket));
        InetAddress local = Global.getLocalHost();
        InetAddress remote = baseSocket.getInetAddress();
        if (!local.equals(remote)) {
            this.checkSocket(baseSocket);
            this.mapUser.put(baseSocket, new Date());
        }
        return baseSocket;
    }

    private void checkSocket(Socket sock) {
        Iterator<Socket> it = this.mapUser.keySet().iterator();
        while (it.hasNext()) {
            Socket sockTemp = it.next();
            if (sockTemp.getRemoteSocketAddress() != null && !sock.getInetAddress().equals(sockTemp.getInetAddress())) continue;
            it.remove();
        }
    }

    public Map<Socket, Date> getMapUser() {
        return this.mapUser;
    }
}

