/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.remote;

import com.indy.engine.EngineServerI;
import com.indy.engine.Global;
import com.indy.engine.LocalService;
import com.indy.engine.common.security.PrivilegeException;
import com.indy.engine.common.security.SecurityConfiguration;
import com.indy.engine.core.common.RemoteSessionInfo;
import com.indy.engine.core.security.PrivilegeAnnotation;
import com.indy.engine.core.security.Role;
import com.indy.engine.delivery.Utils;
import com.indy.engine.rmi.EngineServerAPI_V1_2_temp;
import com.semarchy.xdi.engine.common.IRemoteSessionV01;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RemoteSessionManagement {
    private static final int CLEANUP_TIME = 600000;
    private static final int IDLE_TIME = 2000;
    Map<String, RemoteHolder> activeSessions = Collections.synchronizedMap(new HashMap());
    public static RemoteSessionManagement INSTANCE = new RemoteSessionManagement();
    private Date lastCleanupCheck = new Date();

    private IRemoteSessionV01 createRemote(String sessionUUID, String clientHost, String principal) {
        RemoteHolder holder = this.activeSessions.get(sessionUUID);
        if (holder != null) {
            return holder.getRemote();
        }
        RemoteSessionInfo info = new RemoteSessionInfo(sessionUUID, clientHost, principal);
        RemoteSession remoteSession = new RemoteSession(Global.engineServer, info);
        IRemoteSessionV01 remote = this.createPrivileged(remoteSession);
        this.activeSessions.put(info.getRemoteSessionId(), new RemoteHolder(info, remote));
        return remote;
    }

    public IRemoteSessionV01 createPrivileged(final IRemoteSessionV01 toWrapp) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RemoteSessionInfo info = null;
                info = toWrapp instanceof RemoteSession ? ((RemoteSession)toWrapp).getSessionInfo() : RemoteSessionInfo.parse((Map)toWrapp.getRemoteSessionInfo());
                info.updateLastAccess();
                PrivilegeAnnotation o = method.getAnnotation(PrivilegeAnnotation.class);
                if (o == null) {
                    try {
                        return method.invoke((Object)toWrapp, args);
                    }
                    catch (InvocationTargetException ite) {
                        throw ite.getCause();
                    }
                }
                Role role = o.role();
                boolean allowed = false;
                boolean isScheduler = LocalService.SCHEDULER_REMOTE_SESSION_ID.equals(info.getRemoteSessionId());
                if (isScheduler) {
                    allowed = true;
                } else {
                    SecurityConfiguration.User userToCheck = Global.getUser(info.getUser());
                    if (userToCheck == null && info.getUser() == null) {
                        userToCheck = Global.getAnonymousUser();
                    }
                    if (userToCheck != null) {
                        boolean bl = allowed = userToCheck.isAdmin() || userToCheck.getRoles() != null && userToCheck.getRoles().contains(role);
                    }
                }
                if (allowed) {
                    try {
                        return method.invoke((Object)toWrapp, args);
                    }
                    catch (InvocationTargetException ite) {
                        throw ite.getCause();
                    }
                }
                throw new PrivilegeException(role.name());
            }
        };
        IRemoteSessionV01 remote = (IRemoteSessionV01)Proxy.newProxyInstance(IRemoteSessionV01.class.getClassLoader(), new Class[]{IRemoteSessionV01.class}, handler);
        return remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RemoteSessionInfo> getActiveSessions() {
        HashSet<RemoteSessionInfo> res = null;
        Map<String, RemoteHolder> map = this.activeSessions;
        synchronized (map) {
            res = new HashSet<RemoteSessionInfo>(this.activeSessions.size());
            for (RemoteHolder h : this.activeSessions.values()) {
                res.add(h.getSessionInfo());
            }
        }
        return res;
    }

    public IRemoteSessionV01 getRemote(String sessionUUID, String clientHost, String principal) {
        RemoteHolder r;
        if (sessionUUID == null) {
            try {
                sessionUUID = Utils.checkSum("oldies|" + clientHost + "|" + principal);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        if ((r = this.activeSessions.get(sessionUUID)) == null) {
            return this.createRemote(sessionUUID, clientHost, principal);
        }
        this.invalidateIdleSessions();
        return r.getRemote();
    }

    public RemoteSessionInfo getRemoteSessionInfo(String sessionUUID) {
        RemoteHolder r = this.activeSessions.get(sessionUUID);
        if (r == null) {
            return null;
        }
        return r.getSessionInfo();
    }

    public IRemoteSessionV01 getRemote(RemoteSessionInfo info) {
        RemoteHolder r = this.activeSessions.get(info.getRemoteSessionId());
        if (r == null) {
            this.createRemote(info.getRemoteSessionId(), info.getClientHost(), info.getUser());
            r = this.activeSessions.get(info.getRemoteSessionId());
        } else {
            this.invalidateIdleSessions();
        }
        return r.getRemote();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateIdleSessions() {
        Date cur = new Date();
        if (cur.getTime() > this.lastCleanupCheck.getTime() + 600000L) {
            Map<String, RemoteHolder> map = this.activeSessions;
            synchronized (map) {
                cur = new Date();
                if (cur.getTime() > this.lastCleanupCheck.getTime() + 600000L) {
                    HashSet<String> toRemove = new HashSet<String>();
                    for (RemoteHolder h : this.activeSessions.values()) {
                        RemoteSessionInfo info = h.getSessionInfo();
                        if (info.getLastAccess() == null || info.getLastAccess().getTime() <= cur.getTime() + 2000L) continue;
                        toRemove.add(info.getRemoteSessionId());
                    }
                    for (String s : toRemove) {
                        this.activeSessions.remove(s);
                    }
                    this.lastCleanupCheck.setTime(new Date().getTime());
                }
            }
        }
    }

    public class RemoteHolder {
        private RemoteSessionInfo sessionInfo;
        private IRemoteSessionV01 remote;

        private RemoteHolder(RemoteSessionInfo sessionInfo, IRemoteSessionV01 remote) {
            this.sessionInfo = sessionInfo;
            this.remote = remote;
        }

        public IRemoteSessionV01 getRemote() {
            return this.remote;
        }

        public RemoteSessionInfo getSessionInfo() {
            return this.sessionInfo;
        }
    }

    final class RemoteSession
    extends EngineServerAPI_V1_2_temp
    implements IRemoteSessionV01 {
        private RemoteSessionInfo info;

        protected void finalize() throws Throwable {
            super.finalize();
            RemoteSessionManagement.INSTANCE.activeSessions.remove(this.info.getRemoteSessionId());
        }

        private RemoteSession(EngineServerI pEngineServer, RemoteSessionInfo info) {
            super(pEngineServer, true);
            this.info = info;
        }

        public void logout() throws Exception {
        }

        public Map<String, Object> getRemoteSessionInfo() throws Exception {
            if (this.getSessionInfo() != null) {
                return this.getSessionInfo().toMap();
            }
            return null;
        }

        @Override
        protected RemoteSessionInfo getSessionInfo() {
            return this.info;
        }
    }
}

