/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.userLog;

import com.indy.engine.Global;
import com.indy.engine.userLog.IRecordWriter;
import com.indy.engine.userLog.SessionRecorder;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AsynchRecordWriter
implements IRecordWriter {
    IRecordWriter writer;
    Exception exception;
    SessionRecorder.Record currentRecord;
    AsynchroneThread asynchronuousThread = new AsynchroneThread();
    private String threadName;
    boolean synchFirstRecord = true;
    Object waitObject = new Object();

    public AsynchRecordWriter(IRecordWriter writer, String threadName, boolean synchFirstRecord) {
        this.writer = writer;
        this.threadName = threadName;
        this.synchFirstRecord = synchFirstRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRecord(SessionRecorder.Record o) throws EngineExceptionI {
        this.asynchronuousThread.startThreadIfNeeded();
        if (this.synchFirstRecord && o instanceof SessionRecorder.SessionEndRecord) {
            while (this.currentRecord == null && this.exception == null) {
                try {
                    AsynchRecordWriter asynchRecordWriter = this;
                    synchronized (asynchRecordWriter) {
                        this.wait(10L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
        if (this.exception != null) {
            Global.dLog.getLogger().error("Error on previous event sent to asynch queue, session:{}", (Object)o.getSessionID(), (Object)this.exception);
        }
        this.asynchronuousThread.queue.add(o);
    }

    final class AsynchroneThread
    implements Runnable {
        Thread thread;
        Queue<SessionRecorder.Record> queue = new ConcurrentLinkedQueue<SessionRecorder.Record>();

        AsynchroneThread() {
        }

        @Override
        public synchronized void run() {
            boolean stop = false;
            try {
                do {
                    SessionRecorder.Record tempCurrentRecord;
                    if ((tempCurrentRecord = this.queue.peek()) != null) {
                        AsynchRecordWriter.this.currentRecord = tempCurrentRecord;
                        AsynchRecordWriter.this.writer.writeRecord(AsynchRecordWriter.this.currentRecord);
                        if (AsynchRecordWriter.this.currentRecord instanceof SessionRecorder.SessionEndRecord) {
                            stop = true;
                        }
                        this.queue.poll();
                        continue;
                    }
                    this.wait(10L);
                } while (!Thread.interrupted() && !stop);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (AsynchRecordWriter.this.currentRecord != null) {
                    Global.dLog.getLogger().error("Error during asynch log, session:{}", (Object)AsynchRecordWriter.this.currentRecord.getSessionID(), (Object)e);
                }
                AsynchRecordWriter.this.exception = e;
            }
        }

        private synchronized void startThreadIfNeeded() {
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.setName(AsynchRecordWriter.this.threadName);
                this.thread.start();
            }
        }
    }
}

