/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.Global;
import com.indy.engine.core.security.Role;
import com.semarchy.xdi.runtime.httpserver.LegacyBasicAuthenticationProvider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;

public class LegacyAnonymousAuthenticationFilter
extends AnonymousAuthenticationFilter {
    public LegacyAnonymousAuthenticationFilter() {
        super("legacyAnonymous");
        if (Global.getAnonymousUser() != null) {
            for (Role r : Global.getAnonymousUser().getRoles()) {
                this.getAuthorities().add(new SimpleGrantedAuthority(r.name()));
            }
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            super.doFilter(req, res, chain);
        }
        catch (LegacyBasicAuthenticationProvider.ForbiddenException ex) {
            ((HttpServletResponse)res).setStatus(403);
            ((HttpServletResponse)res).getWriter().write(String.format("Http Error %s:%s", 403, ex.getMessage()));
        }
    }
}

