/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.scheduler.EngineSchedulerI;
import com.indy.engine.service.ServiceManager;
import com.indy.engine.service.ServiceState;
import com.semarchy.xdi.runtime.httpserver.NullableHealthIndicator;
import java.sql.Connection;
import java.sql.SQLException;
import org.quartz.utils.DBConnectionManager;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;

@Component
public class SchedulerHealthIndicator
extends NullableHealthIndicator {
    private final EngineSchedulerI scheduler;

    public SchedulerHealthIndicator() {
        this((EngineSchedulerI)ServiceManager.INSTANCE.getService("scheduler"));
    }

    SchedulerHealthIndicator(EngineSchedulerI scheduler) {
        this.scheduler = scheduler;
    }

    public Health health() {
        if (this.scheduler != null && this.scheduler.getState() == ServiceState.Running) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (Connection con = DBConnectionManager.getInstance().getConnection(this.scheduler.getDataSourceName());){
                    if (con.isValid(60)) {
                        return Health.up().build();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                return Health.down((Throwable)e).build();
            }
            return Health.down().build();
        }
        return this.none();
    }
}

