/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management;

import com.indy.engine.core.module.IModuleService;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class ModuleInstallationInfo
implements IModuleService.IModuleInstallationInfo {
    private IModuleService.IBaseModule baseModule;
    protected Properties moduleProperties = new Properties();
    protected Map<String, URL> filesURL;
    protected IModuleService.IBaseModuleExtension extensionInfo;
    protected List<String> fNames = new ArrayList<String>();
    protected List<String> extensionfNames = new ArrayList<String>();

    protected ModuleInstallationInfo(IModuleService.IBaseModule baseModule, Map<String, URL> filesURL, IModuleService.IBaseModuleExtension extensionInfo, Map<String, URL> extensionfilesURL, Map<String, URL> userFilesURL) {
        this.baseModule = baseModule;
        this.extensionInfo = extensionInfo;
        this.filesURL = filesURL;
        this.fNames = new ArrayList<String>();
        this.fNames.addAll(filesURL.keySet());
        if (extensionInfo != null) {
            this.filesURL.putAll(extensionfilesURL);
            this.extensionfNames = new ArrayList<String>();
            this.extensionfNames.addAll(extensionfilesURL.keySet());
            Collections.sort(this.extensionfNames);
        }
        if (userFilesURL != null) {
            this.filesURL.putAll(userFilesURL);
        }
    }

    public IModuleService.IBaseModule getBaseModule() {
        return this.baseModule;
    }

    public Map<String, InputStream> getFilesInputStreams() throws IOException {
        HashMap<String, InputStream> res = new HashMap<String, InputStream>();
        for (String k : this.filesURL.keySet()) {
            res.put(k, new BufferedInputStream(this.filesURL.get(k).openStream()));
        }
        return res;
    }

    protected Collection<String> getFileNamesToInstall() {
        return this.filesURL.keySet();
    }

    public Properties getModuleDescriptorProperties() {
        return this.moduleProperties;
    }

    public List<String> getBaseModuleFileNames() {
        return this.fNames;
    }

    public IModuleService.IBaseModuleExtension getBaseModuleExtension() {
        return this.extensionInfo;
    }

    public List<String> getBaseModuleExtensionFileNames() {
        return this.extensionfNames;
    }
}

