/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management;

import com.indy.engine.core.module.IModuleService;
import com.indy.libraries.management.Messages;
import com.semarchy.xdi.designer.core.services.IBaseModuleProvider;
import com.semarchy.xdi.designer.core.services.IModuleProblemProvider;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={IModuleProblemProvider.class}, scope=ServiceScope.SINGLETON, immediate=true)
public class ModuleProblemProvider
implements IModuleProblemProvider {
    private static final Pattern PATTERN_LIBRARY_FILE_NAME = Pattern.compile("((?:(?!-\\d)\\S)+)[-|_]([\\d\\.]*)((.*)).jar$");
    @Reference
    private IBaseModuleProvider baseModuleProvider;
    @Reference
    private IModuleService moduleService;
    private final Logger logger = LogManager.getLogger(this.getClass());

    @Activate
    public void activate() {
        for (IModuleService.IModule m : this.moduleService.getModules()) {
            List<IModuleProblemProvider.Problem> problems = this.getProblems(m);
            if (problems.isEmpty()) continue;
            MultiStatus ms = new MultiStatus(this.getClass(), 0, String.format("Libraries conflict detected on module %s", m.getName()));
            problems.stream().forEach(p -> ms.add((IStatus)new Status(p.getStatus() == IModuleProblemProvider.Status.ERROR ? 4 : 2, this.getClass(), p.getMessage())));
            this.logger.info((Object)ms);
        }
    }

    public List<IModuleProblemProvider.Problem> getProblems(IModuleService.IModule module) {
        ArrayList<IModuleProblemProvider.Problem> problems = new ArrayList<IModuleProblemProvider.Problem>();
        String baseModuleId = module.getDescriptor().getBaseModuleInfo().getId();
        IModuleService.IBaseModule bm = this.baseModuleProvider.findBaseModule(baseModuleId);
        if (bm == null) {
            problems.add(IModuleProblemProvider.Problem.of((IModuleProblemProvider.Status)IModuleProblemProvider.Status.ERROR, (String)String.format("Base module %s not found. The required component must be installed.", baseModuleId)));
        } else {
            try {
                for (String conflict : this.detectConflictingLibs(module)) {
                    problems.add(IModuleProblemProvider.Problem.of((IModuleProblemProvider.Status)IModuleProblemProvider.Status.WARNING, (String)conflict));
                }
            }
            catch (Exception ex) {
                problems.add(IModuleProblemProvider.Problem.of((IModuleProblemProvider.Status)IModuleProblemProvider.Status.ERROR, (String)ex.getMessage()));
            }
        }
        return problems;
    }

    public IModuleProblemProvider.Status getStatus(IModuleService.IModule module) {
        List<IModuleProblemProvider.Problem> problems = this.getProblems(module);
        if (problems.isEmpty()) {
            return IModuleProblemProvider.Status.VALID;
        }
        for (IModuleProblemProvider.Problem p : problems) {
            if (p.getStatus() != IModuleProblemProvider.Status.ERROR) continue;
            return IModuleProblemProvider.Status.ERROR;
        }
        return IModuleProblemProvider.Status.WARNING;
    }

    private List<String> detectConflictingLibs(IModuleService.IModule m) throws Exception {
        boolean extensionRemoved;
        Optional<IModuleService.IBaseModuleExtension> ext;
        List moduleFiles = Arrays.stream(m.getInstallationFolder().listFiles()).filter(f -> f.isFile() && f.getName().endsWith(".jar")).collect(Collectors.toList());
        HashMap<CallSite, String> versionPerNameToInstall = new HashMap<CallSite, String>();
        ArrayList<String> moduleLibrariesIssues = new ArrayList<String>();
        IModuleService.IModuleDescriptor moduleDescriptor = m.getDescriptor();
        IModuleService.IBaseModule baseModule = this.baseModuleProvider.findBaseModule(moduleDescriptor.getBaseModuleInfo().getId());
        IModuleService.IBaseModuleExtension extension = null;
        if (moduleDescriptor.getBaseModuleExtensionInfo() != null && (ext = this.baseModuleProvider.getAvailableExtensions(baseModule.getInfo().getId()).stream().filter(e -> e.getInfo().getId().equals(moduleDescriptor.getBaseModuleExtensionInfo().getId())).findFirst()).isPresent()) {
            extension = ext.get();
        }
        boolean bl = extensionRemoved = moduleDescriptor.getBaseModuleExtensionInfo() != null && extension == null;
        if (extensionRemoved) {
            moduleLibrariesIssues.add(String.format(Messages.ModuleServiceComponent_22, m.getName()));
        }
        Collection providedFiles = this.baseModuleProvider.getProvidedFiles(baseModule, extension);
        for (String name : providedFiles) {
            Matcher matcher = PATTERN_LIBRARY_FILE_NAME.matcher(name);
            if (!matcher.matches()) continue;
            String libName = matcher.group(1);
            String libVersion = matcher.group(2);
            String libSuffix = matcher.group(3);
            String oldVersion = versionPerNameToInstall.put((CallSite)((Object)(libName + "/" + libSuffix)), libVersion);
            if (oldVersion == null) continue;
            moduleLibrariesIssues.add(String.format("The provided librarie %s may be in conflict with another version %s.", name, oldVersion));
        }
        HashMap userLibsVersion = new HashMap();
        for (File f2 : moduleFiles) {
            Matcher matcher;
            if (providedFiles.contains(f2.getName()) || !(matcher = PATTERN_LIBRARY_FILE_NAME.matcher(f2.getName())).matches()) continue;
            String libName = matcher.group(1);
            String libVersion = matcher.group(2);
            String libSuffix = matcher.group(3);
            String key = libName + "/" + libSuffix;
            String newVersion = (String)versionPerNameToInstall.get(key);
            if (newVersion == null) continue;
            if (userLibsVersion.get(key) == null) {
                userLibsVersion.put((CallSite)((Object)key), new HashSet());
            }
            if (!((Collection)userLibsVersion.get(key)).add(libVersion) || newVersion.equals(libVersion)) continue;
            String issue = String.format("The user library %s seems in conflict with a provided library by the module %s.", f2.getName(), m.getName());
            moduleLibrariesIssues.add(issue);
        }
        userLibsVersion.keySet().stream().filter(k -> ((Collection)userLibsVersion.get(k)).size() > 1).forEach(k -> {
            boolean bl = moduleLibrariesIssues.add(String.format("The module %s seems to contains multiple versions of the same library [%s:%s]", m.getName(), k, userLibsVersion.get(k)));
        });
        return moduleLibrariesIssues;
    }
}

