/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management.util;

import com.indy.engine.core.module.IModuleService;
import com.indy.engine.core.module.impl.ModuleServiceImpl;
import com.semarchy.xdi.designer.core.services.IBaseModuleProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class ModuleJDBCHelper {
    private List<ModuleDescription> modules = new ArrayList<ModuleDescription>();
    private IBaseModuleProvider provider;
    private IModuleService moduleService;

    public ModuleJDBCHelper(IBaseModuleProvider provider, IModuleService moduleService) {
        this.provider = provider;
        this.moduleService = moduleService;
    }

    public void refreshModules(Collection<String> baseModuleId) {
        this.modules.clear();
        try {
            for (IModuleService.IModule l : this.moduleService.getModules()) {
                if (!baseModuleId.contains(l.getDescriptor().getBaseModuleInfo().getId())) continue;
                this.modules.add(new ModuleDescription(l.getName(), l.getDescriptor()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<ModuleDescription> getModules() {
        return this.modules;
    }

    public class ModuleDescription {
        String name;
        IModuleService.IModuleDescriptor moduleDescriptor;
        List<IModuleService.IJDBCDriverDescriptor> jdbcDescriptors = new ArrayList<IModuleService.IJDBCDriverDescriptor>();
        int defaultDriverIndex = -1;

        private ModuleDescription(String name, IModuleService.IModuleDescriptor moduleDescriptor) {
            this.name = name;
            this.moduleDescriptor = moduleDescriptor;
            try {
                HashMap drivers = new HashMap();
                IModuleService.IBaseModule bm = ModuleJDBCHelper.this.provider.findBaseModule(moduleDescriptor.getBaseModuleInfo().getId());
                if (bm != null) {
                    bm.getJDBCProviders().forEach(d -> {
                        drivers.put(d.getDriverIndex(), d);
                        if (bm.getDefaultJDBCDriverDescriptorIndex() != null && d.getDriverIndex() == bm.getDefaultJDBCDriverDescriptorIndex().intValue()) {
                            this.defaultDriverIndex = d.getDriverIndex();
                        }
                    });
                    if (moduleDescriptor.getBaseModuleExtensionInfo() != null) {
                        for (IModuleService.IBaseModuleExtension e : ModuleJDBCHelper.this.provider.getAvailableExtensions(bm.getInfo().getId())) {
                            if (!e.getInfo().getId().equals(moduleDescriptor.getBaseModuleExtensionInfo().getId())) continue;
                            e.getJDBCProviders().forEach(d -> {
                                IModuleService.IJDBCDriverDescriptor cur = (IModuleService.IJDBCDriverDescriptor)drivers.get(d.getDriverIndex());
                                if (e.getDefaultJDBCDriverDescriptorIndex() != null && d.getDriverIndex() == e.getDefaultJDBCDriverDescriptorIndex().intValue()) {
                                    this.defaultDriverIndex = e.getDefaultJDBCDriverDescriptorIndex();
                                }
                                if (cur == null) {
                                    drivers.put(d.getDriverIndex(), d);
                                } else if (d.getDriverClassName() == null || d.getDriverClassName().isEmpty()) {
                                    drivers.remove(d.getDriverIndex());
                                } else {
                                    ModuleServiceImpl.JDBCDriverDescriptor m = new ModuleServiceImpl.JDBCDriverDescriptor(cur.getDriverClassName(), cur.getDriverIndex());
                                    m.getSamplesURLs().addAll(cur.getSamplesURLs());
                                    int i = 0;
                                    while (i < cur.getSamplesURLs().size()) {
                                        String urlP = (String)cur.getSamplesURLs().get(i);
                                        if (urlP == null || urlP.isEmpty()) {
                                            if (i < m.getSamplesURLs().size()) {
                                                m.getSamplesURLs().set(i, null);
                                            }
                                        } else if (i < m.getSamplesURLs().size()) {
                                            m.getSamplesURLs().set(i, urlP);
                                        } else {
                                            int k = m.getSamplesURLs().size();
                                            while (k < i) {
                                                m.getSamplesURLs().add(null);
                                                ++k;
                                            }
                                            m.getSamplesURLs().add(urlP);
                                        }
                                        ++i;
                                    }
                                }
                            });
                        }
                    }
                }
                this.jdbcDescriptors.addAll(drivers.values());
                this.jdbcDescriptors.forEach(d -> {
                    Iterator it = d.getSamplesURLs().iterator();
                    while (it.hasNext()) {
                        if (it.next() != null) continue;
                        it.remove();
                    }
                });
                this.jdbcDescriptors.sort(new Comparator<IModuleService.IJDBCDriverDescriptor>(){

                    @Override
                    public int compare(IModuleService.IJDBCDriverDescriptor o1, IModuleService.IJDBCDriverDescriptor o2) {
                        return Integer.valueOf(o1.getDriverIndex()).compareTo(o2.getDriverIndex());
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public String getName() {
            return this.name;
        }

        public List<IModuleService.IJDBCDriverDescriptor> getJDBCProviders() {
            return this.jdbcDescriptors;
        }

        public IModuleService.IJDBCDriverDescriptor getDefaultJDBCProvider() {
            Optional<IModuleService.IJDBCDriverDescriptor> res = this.jdbcDescriptors.stream().filter(d -> d.getDriverIndex() == this.defaultDriverIndex).findFirst();
            if (res.isPresent()) {
                return res.get();
            }
            if (!this.jdbcDescriptors.isEmpty()) {
                return this.jdbcDescriptors.get(0);
            }
            return null;
        }
    }
}

