/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.licence.manager.tools;

import com.semarchy.xdi.designer.core.http.ApacheHttpClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Connection {
    private static Logger logger = LogManager.getLogger(Connection.class);
    private static SSLContext sslContext = null;
    static Encryptor encryptor;

    public static <T> T invoke(String address, Map<String, String> params, HttpClientResponseHandler<T> responseHandler) throws Exception {
        if (sslContext == null) {
            String pwd1 = Connection.a("14A71F89ECCD3BC8E92924456CD9AEF16FB6D9367DB52BC12243ACD03281DAB182E6DCBAC641FC72BAE017F4AA94B6E411CAD3A7B44335D50072A10B65AD59AA1F851C18270C89E60B761EA19D39563C");
            try {
                File customStore;
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                InputStream keystoreStream = Connection.class.getResourceAsStream("ca_certserver.jks");
                keystore.load(keystoreStream, pwd1 != null ? pwd1.toCharArray() : new char[]{});
                String customTrustStorePath = JavaProp.readJavaProperty(JavaProp.KEYSTORE_PATH);
                if (customTrustStorePath != null && (customStore = new File(customTrustStorePath)).exists()) {
                    String customTrustStoreType = JavaProp.readJavaProperty(JavaProp.KEYSTORE_TYPE);
                    String customTrustStorePassword = JavaProp.readJavaProperty(JavaProp.KEYSTORE_PASSWORD);
                    KeyStore externalTrustStore = KeyStore.getInstance(customTrustStoreType);
                    Throwable throwable = null;
                    Object var13_16 = null;
                    try (FileInputStream externalKeystoreStream = new FileInputStream(customStore);){
                        externalTrustStore.load(externalKeystoreStream, customTrustStorePassword != null ? customTrustStorePassword.toCharArray() : new char[]{});
                        String customKeyAlias = JavaProp.readJavaProperty(JavaProp.KEYSTORE_KEY_ALIAS);
                        if (customKeyAlias != null) {
                            Certificate externalCertificate = externalTrustStore.getCertificate(customKeyAlias);
                            keystore.setCertificateEntry(customKeyAlias, externalCertificate);
                        } else {
                            Connection.loadTrustStoreCertificatesToOtherTruststore(externalTrustStore, keystore);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                try {
                    KeyStore jvmInternalTrustStore = JvmTrustStoreManager.getJvmTrustStore();
                    if (jvmInternalTrustStore != null) {
                        Connection.loadTrustStoreCertificatesToOtherTruststore(jvmInternalTrustStore, keystore);
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to load trutstore from java properties", (Throwable)e);
                }
                trustManagerFactory.init(keystore);
                TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
                sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, trustManagers, null);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return Connection.invoke(sslContext, address, params, responseHandler);
    }

    public static <T> T invoke(SSLContext context, String address, Map<String, String> params, HttpClientResponseHandler<T> responseHandler) throws Exception {
        boolean disableHostnameVerifier = "false".equals(JavaProp.readJavaProperty(JavaProp.CERTIFICATE_HOSTNAME_VERIFICATION));
        Throwable throwable = null;
        Object var6_7 = null;
        try (ApacheHttpClient client = ApacheHttpClient.build((ApacheHttpClient.SslConfig)new ApacheHttpClient.SslConfig(context, disableHostnameVerifier));){
            return (T)client.get(address, params, Collections.singletonMap("Accept", ContentType.TEXT_XML), null, true, responseHandler);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void loadTrustStoreCertificatesToOtherTruststore(KeyStore sourceTrustStore, KeyStore targetTrustStore) throws KeyStoreException {
        Enumeration<String> enumeration = sourceTrustStore.aliases();
        while (enumeration.hasMoreElements()) {
            String alias = enumeration.nextElement();
            Certificate externalCertificate = sourceTrustStore.getCertificate(alias);
            targetTrustStore.setCertificateEntry(alias, externalCertificate);
        }
    }

    private static Encryptor getDefault() throws IOException, ClassNotFoundException {
        if (encryptor == null) {
            encryptor = new Encryptor(Connection.class.getResourceAsStream("a"));
        }
        return encryptor;
    }

    static String a(String str) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, ClassNotFoundException, IOException {
        return Connection.getDefault().decryptString(str);
    }

    private static class Encryptor {
        private SecretKey key;
        private String algorithm;

        public String decryptString(String pass) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException {
            return this.decryptString(pass, StandardCharsets.UTF_8);
        }

        private String decryptString(String pass, Charset charset) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException {
            String ret = null;
            byte[] b2 = this.decryptBytes(this.hexStringToArrayByte(pass));
            ret = new String(b2, charset);
            return ret;
        }

        private Encryptor(InputStream fis) throws IOException, ClassNotFoundException {
            ObjectInputStream in = new ObjectInputStream(fis);
            this.key = (SecretKey)in.readObject();
            this.algorithm = this.key.getAlgorithm();
            in.close();
        }

        private void decryptStream(InputStream in, OutputStream out) throws NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException, InvalidKeyException {
            Cipher cipher = null;
            cipher = Cipher.getInstance(this.algorithm);
            cipher.init(2, this.key);
            this.crypt(in, out, cipher);
            in.close();
            out.close();
        }

        private byte[] decryptBytes(byte[] ciphered) throws NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException, InvalidKeyException {
            ByteArrayInputStream in = new ByteArrayInputStream(ciphered);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.decryptStream(in, out);
            return out.toByteArray();
        }

        private void crypt(InputStream in, OutputStream out, Cipher cipher) throws IOException, IllegalBlockSizeException, BadPaddingException {
            int blockSize = cipher.getBlockSize();
            int outputSize = cipher.getOutputSize(blockSize);
            byte[] inBytes = new byte[blockSize];
            byte[] outBytes = new byte[outputSize];
            int inLength = 0;
            boolean done = false;
            while (!done) {
                inLength = in.read(inBytes);
                if (inLength == blockSize) {
                    try {
                        int outLength = cipher.update(inBytes, 0, blockSize, outBytes);
                        out.write(outBytes, 0, outLength);
                    }
                    catch (ShortBufferException e) {
                        logger.error("unexpected", (Throwable)e);
                    }
                    continue;
                }
                done = true;
            }
            outBytes = inLength > 0 ? cipher.doFinal(inBytes, 0, inLength) : cipher.doFinal();
            out.write(outBytes);
        }

        private byte[] hexStringToArrayByte(String hexStr) {
            byte[] bArray = new byte[hexStr.length() / 2];
            int i = 0;
            while (i < hexStr.length() / 2) {
                byte firstNibble = Byte.parseByte(hexStr.substring(2 * i, 2 * i + 1), 16);
                byte secondNibble = Byte.parseByte(hexStr.substring(2 * i + 1, 2 * i + 2), 16);
                int finalByte = secondNibble & 0xFF | firstNibble << 4;
                bArray[i] = (byte)finalByte;
                ++i;
            }
            return bArray;
        }
    }

    private static enum JavaProp {
        KEYSTORE_KEY_ALIAS("xdi.designer.license.server.keystore.key.alias", "license.service.keystore.key.alias"),
        KEYSTORE_PASSWORD("xdi.designer.license.server.keystore.password", "license.service.keystore.password"),
        KEYSTORE_TYPE("xdi.designer.license.server.keystore.type", "license.service.keystore.type"),
        KEYSTORE_PATH("xdi.designer.license.server.keystore.path", "license.service.keystore.path"),
        CERTIFICATE_HOSTNAME_VERIFICATION("xdi.designer.license.server.certificate.hostname.verification", null);

        private String propName;
        private String alias;

        private JavaProp(String name, String alias) {
            this.propName = name;
            this.alias = alias;
        }

        public String getPropName() {
            return this.propName;
        }

        public String getAlias() {
            return this.alias;
        }

        public static String readJavaProperty(JavaProp prop) {
            String s = System.getProperty(prop.getPropName());
            if (s == null && prop.getAlias() != null) {
                s = System.getProperty(prop.getAlias());
            }
            return s;
        }
    }

    private static class JvmTrustStoreManager {
        private JvmTrustStoreManager() {
        }

        private static KeyStore getJvmTrustStore() throws Exception {
            File storeFile = null;
            String sep = File.separator;
            KeyStore ks = null;
            String storeFileName = System.getProperty("javax.net.ssl.trustStore");
            if (storeFileName != null) {
                storeFile = new File(storeFileName);
            } else {
                String javaHome = System.getProperty("java.home");
                storeFile = new File(javaHome + sep + "lib" + sep + "security" + sep + "jssecacerts");
                if (!storeFile.exists()) {
                    storeFile = new File(javaHome + sep + "lib" + sep + "security" + sep + "cacerts");
                }
            }
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileInputStream fis = new FileInputStream(storeFile);){
                storeFileName = storeFile.getPath();
                String defaultTrustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
                String defaultTrustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider", "");
                if (defaultTrustStoreType.length() != 0) {
                    ks = defaultTrustStoreProvider.length() == 0 ? KeyStore.getInstance(defaultTrustStoreType) : KeyStore.getInstance(defaultTrustStoreType, defaultTrustStoreProvider);
                    char[] passwd = null;
                    String defaultTrustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", "");
                    if (defaultTrustStorePassword.length() != 0) {
                        passwd = defaultTrustStorePassword.toCharArray();
                    }
                    ks.load(fis, passwd);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return ks;
        }
    }
}

