/*
 * Decompiled with CFR 0.152.
 */
package com.indy.osgihook;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FilteredBundleCopier {
    private static final String FILTERED = ".jar";
    private Path inputLocation;
    private Path outputLocation;
    private Mode mode = Mode.ZIP;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Comparator<ZipEntry> pathComparator = new Comparator<ZipEntry>(){

        @Override
        public int compare(ZipEntry o1, ZipEntry o2) {
            if (o1.isDirectory()) {
                if (o2.isDirectory()) {
                    return o1.getName().compareTo(o2.getName());
                }
                return -1;
            }
            if (o2.isDirectory()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };

    public FilteredBundleCopier(Path inputLocation, Path outputLocation) {
        this.inputLocation = inputLocation;
        this.outputLocation = outputLocation;
        this.mode = this.inputLocation.toFile().isDirectory() ? Mode.FOLDER : Mode.ZIP;
    }

    public void copy() throws IOException {
        URI uri = URI.create("jar:" + String.valueOf(this.outputLocation.toUri()));
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("create", "true");
        env.put("useTempFile", Boolean.TRUE);
        Files.deleteIfExists(this.outputLocation);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileSystem zipFs = FileSystems.newFileSystem(uri, env);){
            if (this.mode == Mode.ZIP) {
                this.readZipEntries(zipFs);
            } else if (this.mode == Mode.FOLDER) {
                this.readFolderEntries(zipFs);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void readFolderEntries(FileSystem zipFs) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<Path> walk = Files.walk(this.inputLocation, new FileVisitOption[0]);){
            walk.filter(p -> p != this.inputLocation).forEach(p -> {
                Path relativePath = this.inputLocation.relativize((Path)p);
                Path outputPath = zipFs.getPath(relativePath.toString(), new String[0]);
                try {
                    this.copyFileEntry((Path)p, outputPath);
                }
                catch (IOException e) {
                    this.logger.log(Level.WARNING, "Unexpected", e);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void readZipEntries(FileSystem zipFs) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zipFile = new ZipFile(this.inputLocation.toFile());){
            Predicate<ZipEntry> isFile = ze -> !ze.isDirectory();
            Predicate<ZipEntry> isLib = ze -> ze.getName().endsWith(FILTERED);
            zipFile.stream().filter(isFile.negate().or(isFile.and(isLib.negate()))).sorted(this.pathComparator).forEach(ze -> {
                Path outputPath = zipFs.getPath(ze.getName(), new String[0]);
                try {
                    this.copyZipEntry(zipFile, (ZipEntry)ze, outputPath);
                }
                catch (IOException e) {
                    this.logger.log(Level.WARNING, "Unexpected", e);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void copyFileEntry(Path input, Path outputPath) throws IOException {
        if (Files.isDirectory(input, new LinkOption[0])) {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        } else if (!input.getName(input.getNameCount() - 1).toString().endsWith(FILTERED)) {
            Files.copy(input, outputPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void copyZipEntry(ZipFile zipFile, ZipEntry ze, Path outputPath) throws IOException {
        if (ze.isDirectory()) {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        } else {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream is = zipFile.getInputStream(ze);){
                Files.copy(is, outputPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    static enum Mode {
        FOLDER,
        ZIP;

    }
}

