/*
 * Decompiled with CFR 0.152.
 */
package com.indy.osgihook;

import com.indy.osgihook.CopyFilesTask;
import com.indy.osgihook.ExternalJarHook;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.osgi.internal.hookregistry.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.eclipse.osgi.storage.bundlefile.DirBundleFile;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Version;

public class RuntimeDeployer
implements BundleFileWrapperFactoryHook {
    private static final String OSGI_BUNDLE_NAME = "org.eclipse.osgi";
    private static final Collection<String> GEN_LIBS_BUNDLE_NAME = Arrays.asList("org.eclipse.osgi", "org.eclipse.emf.common", "org.eclipse.emf.ecore", "org.eclipse.emf.ecore.xmi");
    private Map<String, Version> versionByBundleNameToDeploy = new HashMap<String, Version>();
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    private void handleBundlesRequiredForGeneration(BundleFile bundleFile) {
        Optional<String> opt = GEN_LIBS_BUNDLE_NAME.stream().filter(fName -> !(bundleFile instanceof DirBundleFile) && (bundleFile.getBaseFile().getName().startsWith(String.format("%s_", fName)) || bundleFile.getBaseFile().getName().startsWith(String.format("%s-", fName)))).findFirst();
        if (!opt.isPresent()) {
            return;
        }
        String bundleName = bundleFile.getBaseFile().getName();
        ExternalJarHook.logln(String.format("\tLine \"%s\" detected", bundleName));
        try {
            this.doExtractBundle(this.getManifestInfo(bundleFile), bundleName, bundleFile, "-todir build/lib -name " + opt.get(), true);
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error while extracting bundle", ex);
        }
    }

    public BundleFileWrapper wrapBundleFile(BundleFile bundleFile, BundleInfo.Generation generation, boolean base) {
        this.handleBundlesRequiredForGeneration(bundleFile);
        HashSet<CallSite> keys = new HashSet<CallSite>();
        HashSet classpasth = new HashSet();
        BundleEntry hookProprtiesEntry = bundleFile.getEntry("hook.properties");
        if (hookProprtiesEntry != null) {
            Properties properties = new Properties();
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (BufferedInputStream is = new BufferedInputStream(hookProprtiesEntry.getFileURL().openStream());){
                    properties.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ExternalJarHook.logln(bundleFile.getBaseFile().getName() + ": Hook file found");
                ArrayList<Object> orderedKeys = new ArrayList<Object>(properties.keySet());
                Collections.sort(orderedKeys, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        String s1 = o1.toString();
                        String s2 = o2.toString();
                        if (s1.startsWith("remove")) {
                            return -1;
                        }
                        if (s2.startsWith("remove")) {
                            return 1;
                        }
                        return s1.compareTo(s2);
                    }
                });
                for (Object e : orderedKeys) {
                    String params;
                    String key = (String)e;
                    if (keys.contains(key + "=" + (params = properties.getProperty(key)))) continue;
                    if (key.startsWith("extract.")) {
                        if (key.startsWith("extract./") || key.startsWith("extract.lib")) {
                            ExternalJarHook.logln("\tSTOP");
                        }
                        ExternalJarHook.logln("\tLine \"" + key + "\" detected");
                        keys.add((CallSite)((Object)(key + "=" + params)));
                        String fromDir = key.substring(key.indexOf(".") + 1);
                        String[] lines = params.split(",");
                        int i = 0;
                        while (i < lines.length) {
                            CopyFilesTask cft = new CopyFilesTask(bundleFile, fromDir, lines[i]);
                            cft.run();
                            ++i;
                        }
                        continue;
                    }
                    if (key.startsWith("remove")) {
                        ExternalJarHook.logln("\tLine \"" + key + "\" detected");
                        keys.add((CallSite)((Object)(key + "=" + params)));
                        String _file = key.substring(key.indexOf(".") + 1);
                        File file = new File(ExternalJarHook.stambiaRuntimeDir + File.separator + _file);
                        ExternalJarHook.logln("\tFile to delete \"" + file.getAbsolutePath() + "\"");
                        if (!file.exists()) continue;
                        ExternalJarHook.logln("\tFile existed \"" + file.getAbsolutePath() + "\"");
                        if (ExternalJarHook.deleteFile(file)) {
                            ExternalJarHook.logln("\tFile deleted \"" + file.getAbsolutePath() + "\"");
                            continue;
                        }
                        ExternalJarHook.logln("\tFile not deleted \"" + file.getAbsolutePath() + "\"");
                        continue;
                    }
                    if (!key.startsWith("extractBundle")) continue;
                    ExternalJarHook.logln("\tLine \"" + key + "\" detected");
                    String bundleName = bundleFile.getBaseFile().getName();
                    try {
                        this.doExtractBundle(this.getManifestInfo(bundleFile), bundleName, bundleFile, params, true);
                    }
                    catch (Exception ex) {
                        this.logger.log(Level.WARNING, String.format("Failed to extractBundle %s", bundleName), ex);
                    }
                }
            }
            catch (Exception t) {
                this.logger.log(Level.WARNING, "Unexpected", t);
            }
        }
        return null;
    }

    private ManifestInfo getManifestInfo(BundleFile file) {
        try {
            BundleEntry manifest = file.getEntry("META-INF/MANIFEST.MF");
            if (manifest != null) {
                Map merged = ManifestElement.parseBundleManifest((InputStream)manifest.getInputStream(), new HashMap());
                String version = (String)merged.get("Bundle-Version");
                String name = (String)merged.get("Bundle-SymbolicName");
                if (version != null) {
                    return ManifestInfo.of(name, version);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Unexpected", e);
        }
        return null;
    }

    private void doExtractBundle(ManifestInfo manifestInfo, String bundleName, BundleFile bundleFile, String parameters, boolean useProtectionRules) throws Exception {
        Version currentVersion = this.versionByBundleNameToDeploy.get(manifestInfo.bundleName);
        if (currentVersion != null && currentVersion.compareTo(manifestInfo.version) > 0) {
            ExternalJarHook.logln(String.format("skip extracting %s (%s) because version %s already extracted", bundleName, manifestInfo.version.toString(), currentVersion.toString()));
            return;
        }
        this.versionByBundleNameToDeploy.put(manifestInfo.bundleName, manifestInfo.version);
        ExternalJarHook.extractBundle(bundleName, bundleFile, parameters, useProtectionRules);
    }

    private static class ManifestInfo {
        String bundleName;
        Version version;

        private ManifestInfo() {
        }

        static ManifestInfo of(String name, String version) {
            ManifestInfo m = new ManifestInfo();
            m.bundleName = name;
            m.version = Version.parseVersion((String)version);
            return m;
        }
    }
}

