/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.tokenBearer.wizard;

import com.indy.addons.tokenBearer.wizard.BearerTokenControler;
import com.indy.addons.tokenBearer.wizard.Messages;
import com.indy.md.ui.editor.ui.MdWizard;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public class BearerTokenWizard
extends MdWizard {
    private static final Logger LOGGER = LogManager.getLogger(BearerTokenWizard.class);
    private BearerTokenControler controler;
    Map<String, Boolean> reverseOptions = new HashMap<String, Boolean>();
    MainPage mainPage;

    public void addPages() {
        this.mainPage = new MainPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public void setNode(MdNode node) {
        super.setNode(node);
        this.controler = new BearerTokenControler(node, (MdNode)node.getSubstituteContainer());
    }

    public boolean performFinish() {
        try {
            HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
            MdNode newNode = this.controler.createNewMdNode();
            newNode.setId(this.getNode().getId());
            reversedMap.put(newNode, this.getNode());
            HashMap<String, IncrementalReverser.IReverseMatchingStrategy> reverseModes = new HashMap<String, IncrementalReverser.IReverseMatchingStrategy>();
            IncrementalReverser.IReverseMatchingStrategy modeById = () -> (n1, n2) -> n1.getId().equals(n2.getId());
            reverseModes.put("com.stambia.security.bearerToken", modeById);
            IncrementalReverser reverser = new IncrementalReverser(this.getNode().getSubstituteContainer(), reversedMap, Collections.emptyList(), true, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, reverseModes, true);
            reverser.reverse();
        }
        catch (Exception ex) {
            LOGGER.error(Messages.tokenBearerWizardError, (Throwable)ex);
            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.addons.httprest", Messages.tokenBearerWizardError, (Throwable)ex), 1);
            return false;
        }
        return true;
    }

    class MainPage
    extends WizardPage {
        private Text name;
        private Text bearerToken;

        protected MainPage() {
            super(Messages.tokenBearerWizardTitle);
            this.setTitle(this.getName());
        }

        public void createControl(Composite parent) {
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)new GridLayout(2, false));
            main.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(main, 0);
            label.setText(Messages.tokenBearerWizardName);
            label.setLayoutData((Object)new GridData());
            this.name = new Text(main, 2048);
            this.name.setLayoutData((Object)new GridData(4, 1, true, false));
            this.name.addModifyListener(e -> BearerTokenWizard.this.controler.getBean().setName(this.name.getText()));
            label = new Label(main, 0);
            label.setText(Messages.tokenBearerWizardTokenBearer);
            label.setLayoutData((Object)new GridData());
            this.bearerToken = new Text(main, 0x400800);
            this.bearerToken.setLayoutData((Object)new GridData(4, 1, true, false));
            this.bearerToken.addModifyListener(e -> BearerTokenWizard.this.controler.getBean().setBearerToken(this.bearerToken.getText()));
            this.setControl((Control)main);
            this.fillData();
        }

        private void fillData() {
            this.name.setText(BearerTokenWizard.this.controler.getBean().getName());
            this.bearerToken.setText(BearerTokenWizard.this.controler.getBean().getBearerToken());
        }
    }
}

