/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum JoinLocation implements Enumerator
{
    SRC(0, "SRC", "SRC"),
    WRK(1, "WRK", "WRK"),
    MEM(2, "MEM", "MEM"),
    TRG(3, "TRG", "TRG");

    public static final int SRC_VALUE = 0;
    public static final int WRK_VALUE = 1;
    public static final int MEM_VALUE = 2;
    public static final int TRG_VALUE = 3;
    private static final JoinLocation[] VALUES_ARRAY;
    public static final List<JoinLocation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new JoinLocation[]{SRC, WRK, MEM, TRG};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static JoinLocation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JoinLocation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JoinLocation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JoinLocation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JoinLocation get(int value) {
        switch (value) {
            case 0: {
                return SRC;
            }
            case 1: {
                return WRK;
            }
            case 2: {
                return MEM;
            }
            case 3: {
                return TRG;
            }
        }
        return null;
    }

    private JoinLocation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

