/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.api;

import com.indy.map.ILogicalField;
import com.indy.map.ref.RComputedField;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RUsage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RefRelationHelper {
    private Map<RUsage, UsageInfo> usageMap = new HashMap<RUsage, UsageInfo>();
    private Map<RSourceItem, Set<RUsage>> sourceMap = new HashMap<RSourceItem, Set<RUsage>>();

    public Collection<RUsage> getUsage(RSourceItem src) {
        return this.internalGetOrCreate(src, this.sourceMap, this::createUsageSource);
    }

    public Collection<RSourceItem> getSourceItem(RUsage usage) {
        UsageInfo r = this.internalGetOrCreate(usage, this.usageMap, this::createUsageInfo);
        return r.getSources();
    }

    public String getInternalExpression(RUsage usage) {
        UsageInfo s = this.internalGetOrCreate(usage, this.usageMap, this::createUsageInfo);
        return s.getInternalExpression();
    }

    private <T, E> E internalGetOrCreate(T key, Map<T, E> map, Function<T, E> createFunction) {
        E current = map.get(key);
        if (current != null) {
            return current;
        }
        current = createFunction.apply(key);
        map.put(key, current);
        return current;
    }

    private Set<RUsage> createUsageSource(RSourceItem src) {
        HashSet<RUsage> s = new HashSet<RUsage>();
        for (RUsage u : src.getUsage()) {
            if (u instanceof RComputedField) {
                s.addAll(this.getUsage((RComputedField)u));
                continue;
            }
            s.add(u);
        }
        return s;
    }

    private UsageInfo createUsageInfo(RUsage usage) {
        UsageInfo inf = new UsageInfo();
        inf.setInternalExpression(usage.getInternalExpression());
        for (RSourceItem src : usage.getSourceRef()) {
            if (src instanceof RComputedField) {
                inf.sources.addAll(this.getSourceItem((RComputedField)src));
                inf.setInternalExpression(inf.getInternalExpression().replace("${" + ((ILogicalField)((Object)src.getDataModel())).getFullPath() + "}$", this.getInternalExpression((RComputedField)src)));
                continue;
            }
            inf.sources.add(src);
        }
        return inf;
    }

    private class UsageInfo {
        private String internalExpression;
        private Set<RSourceItem> sources = new HashSet<RSourceItem>();

        private UsageInfo() {
        }

        public String getInternalExpression() {
            if (this.internalExpression == null) {
                return "";
            }
            return this.internalExpression;
        }

        public void setInternalExpression(String internalExpression) {
            this.internalExpression = internalExpression;
        }

        public Set<RSourceItem> getSources() {
            return this.sources;
        }
    }
}

