/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.api.internal;

import com.indy.map.Constraint;
import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.IMetaData;
import com.indy.map.ISerde;
import com.indy.map.QueryField;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.api.internal.MdEvaluator;
import com.indy.map.api.internal.Messages;
import com.indy.map.api.internal.MetaDataInformationsProviderFactoryImpl;
import com.semarchy.xdi.designer.core.models.IMetaDataInformationsProviderFactory;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;

public class CachedMetaDataInformationsProvider
implements IMetaDataInformationsProvider,
IMetaDataInformationsProviderFactory.Clearable {
    private ResourceSet resourceSet;
    private MetaDataInformationsProviderFactoryImpl factoryHelper;

    public CachedMetaDataInformationsProvider(ResourceSet rs, MetaDataInformationsProviderFactoryImpl factoryHelper) {
        this.resourceSet = rs;
        this.factoryHelper = factoryHelper;
    }

    public void clear() {
        this.factoryHelper.clear();
    }

    private String readProperty(String key, String fileId) {
        return this.factoryHelper.readProperty(this.resourceSet, key, fileId);
    }

    private String getKey(EObject obj, String ctx, String entry) {
        String eltId = CacheHelper.extractEltID((EObject)obj);
        return eltId + "." + ctx + "." + entry;
    }

    private String getKey(String fileId, String ctx, String entry) {
        return fileId + "." + ctx + "." + entry;
    }

    @Override
    public String evaluateConstraintType(Constraint c) {
        String fileId = CacheHelper.extractFileID((EObject)c.basicGetRef());
        String key = this.getKey(c.basicGetRef(), "constraint", "type");
        return this.readProperty(key, fileId);
    }

    @Override
    public String evaluateMandatory(Field f) {
        String fileId = CacheHelper.extractFileID((EObject)f.basicGetRef());
        String key = this.getKey(f.basicGetRef(), "field", "mandatory");
        return this.readProperty(key, fileId);
    }

    @Override
    public String evaluatePrecision(Field f) {
        String fileId = CacheHelper.extractFileID((EObject)f.basicGetRef());
        String key = this.getKey(f.basicGetRef(), "field", "precision");
        return this.readProperty(key, fileId);
    }

    @Override
    public String evaluateSize(Field f) {
        String fileId = CacheHelper.extractFileID((EObject)f.basicGetRef());
        String key = this.getKey(f.basicGetRef(), "field", "size");
        return this.readProperty(key, fileId);
    }

    @Override
    public EObject evaluateConnection(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "connection");
        String val = this.readProperty(key, fileId);
        if (val == null) {
            return null;
        }
        AnyType proxy = XMLTypeFactory.eINSTANCE.createAnyType();
        ((InternalEObject)proxy).eSetProxyURI(((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(CacheHelper.extractFileID((String)val)).appendFragment(val));
        return proxy;
    }

    @Override
    public String evaluateObjectDelimiterMask(Datastore datastore) {
        String fileId = CacheHelper.extractFileID((EObject)datastore.basicGetRef());
        String key = this.getKey(datastore.basicGetRef(), "datastore", "objectDelimiterMask");
        return this.readProperty(key, fileId);
    }

    @Override
    public String evaluateObjectDelimiterRegexp(Datastore datastore) {
        String fileId = CacheHelper.extractFileID((EObject)datastore.basicGetRef());
        String key = this.getKey(datastore.basicGetRef(), "datastore", "objectDelimiterRegexp");
        return this.readProperty(key, fileId);
    }

    @Override
    public String evaluateName(Field field) {
        String fileId = CacheHelper.extractFileID((EObject)field.basicGetRef());
        String key = this.getKey(field.basicGetRef(), "field", "name");
        return this.readProperty(key, fileId);
    }

    @Override
    public boolean evaluateStageable(Field field) {
        String fileId = CacheHelper.extractFileID((EObject)field.basicGetRef());
        String key = this.getKey(field.basicGetRef(), "field", "stageable");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public String evaluateProductCode(IContainer c, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = CacheHelper.extractFileID((EObject)((IMetaData)((Object)c)).basicGetRef());
        String key = this.getKey(fileId, "all", "productCode");
        return this.readProperty(key, fileId);
    }

    @Override
    public String evaluateConnectionId(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "connection");
        String val = this.readProperty(key, fileId);
        if (val == null) {
            return null;
        }
        return CacheHelper.extractEltID((String)val.replace("#", ""));
    }

    @Override
    public String evaluateConnectionId(MdNode mdNode) {
        String fileId = CacheHelper.extractFileID((EObject)mdNode);
        String key = this.getKey((EObject)mdNode, "container", "connection");
        String val = this.readProperty(key, fileId);
        if (val == null) {
            return null;
        }
        return CacheHelper.extractEltID((String)val.replace("#", ""));
    }

    @Override
    public String evaluateDataType(Field dataModel) {
        String fileId = CacheHelper.extractFileID((EObject)dataModel.basicGetRef());
        String key = this.getKey(dataModel.basicGetRef(), "field", "dataType");
        return this.readProperty(key, fileId);
    }

    @Override
    public boolean hasFilterCapability(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "supportFilter");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean hasWarningOnFilter(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "warningOnFilter");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean hasJoinCapability(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "supportJoin");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean hasWorkspaceCapability(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "wkspCapability");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public String evaluateTechCode(IContainer target, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = CacheHelper.extractFileID((EObject)((IMetaData)((Object)target)).basicGetRef());
        String key = this.getKey(fileId, "all", "techCode");
        return this.readProperty(key, fileId);
    }

    @Override
    public boolean supportTargetMapping(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "targetSupport");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean supportSourceMapping(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "sourceSupport");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean hasTransformCapability(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "transformCapability");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean hasWarningOnTransform(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "warningOnTransform");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean supportTargetMapping(Field field) {
        String fileId = CacheHelper.extractFileID((EObject)field.basicGetRef());
        String key = this.getKey(field.basicGetRef(), "field", "targetSupport");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean hasLevel(IMetaData met) {
        String fileId = CacheHelper.extractFileID((EObject)met.basicGetRef());
        String key = this.getKey(met.basicGetRef(), "any", "levelCode");
        String val = this.readProperty(key, fileId);
        return val != null;
    }

    @Override
    public String evaluateStageFieldType(QueryField met) {
        try {
            return met.getMdNode().evaluateXpathExpressionCached("INTERNAL_STAGE_FIELD_TYPE", null);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    @Override
    public boolean evaluateIsStageFieldTypeValid(QueryField met) {
        try {
            Boolean b = met.getMdNode().evaluateXpathExpressionBooleanCached(new String[]{"INTERNAL_STAGE_FIELD_VALID_TYPE"});
            return Boolean.TRUE.equals(b);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return false;
        }
    }

    @Override
    public MdNode toSubMdParent(EObject n) {
        String fileId = CacheHelper.extractFileID((EObject)n);
        String key = this.getKey(fileId, "all", "subMdParent");
        String val = this.readProperty(key, fileId);
        if (val == null) {
            return null;
        }
        MdNode res = MdFactory.eINSTANCE.createMdNode();
        ((InternalEObject)res).eSetProxyURI(((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(CacheHelper.extractFileID((String)val)).appendFragment(val));
        res.setId(CacheHelper.extractEltID((EObject)res));
        res.setName(CacheHelper.extractEltName((String)((InternalEObject)res).eProxyURI().fragment()));
        return res;
    }

    @Override
    public String evaluateFieldSeparator(IContainer ds, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = CacheHelper.extractFileID((EObject)((IMetaData)((Object)ds)).basicGetRef());
        String key = this.getKey(((IMetaData)((Object)ds)).basicGetRef(), "container", "fieldSeparator");
        return this.readProperty(key, fileId);
    }

    @Override
    public Collection<String> evaluateCriteriaCompatibleTechList(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "compatibleTechList");
        String val = this.readProperty(key, fileId);
        if (val instanceof String && !val.trim().isEmpty()) {
            return Arrays.asList(val.split(";"));
        }
        return null;
    }

    @Override
    public boolean hasFilterOrWorkspaceCapability(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "supportFilterOrWkps");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean hasJoinOrWorkspaceCapability(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "supportJoinOrWksp");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean hasTransformOrWorkspaceCapability(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "transformOrWkspCapability");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean supportSourceMapping(Field field) {
        String fileId = CacheHelper.extractFileID((EObject)field.basicGetRef());
        String key = this.getKey(field.basicGetRef(), "field", "sourceSupport");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public String evaluateObjectMask(Field field) {
        String fileId = CacheHelper.extractFileID((EObject)field.basicGetRef());
        String key = this.getKey(field.basicGetRef(), "field", "objectMask");
        return this.readProperty(key, fileId);
    }

    @Override
    public String evaluateFullPath(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "fullPath");
        return this.readProperty(key, fileId);
    }

    @Override
    public boolean evaluateDisjointedDataSetError(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "errorOnDisjointedDataset");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean evaluateDisjointedDataSetWarning(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "warningOnDisjointedDataset");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean evaluateErrorWhenDisjointedDataSetHaveCommonMappedAncestor(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "errorWhenDisjointedDatasetHaveCommonMappedAncestor");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean evaluateErrorOnLoadSetWhenNoDirectPath(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "errorOnLoadSetWhenDirectPath");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public boolean validateExistance(IMetaData met) {
        String fileId = CacheHelper.extractFileID((EObject)met.basicGetRef());
        String key = this.getKey(met.basicGetRef(), "any", "levelCode");
        String val = this.readProperty(key, fileId);
        return val != null;
    }

    @Override
    public String getLevelDefType(IMetaData met) {
        String fileId = CacheHelper.extractFileID((EObject)met.basicGetRef());
        String key = this.getKey(met.basicGetRef(), "any", "levelCode");
        return this.readProperty(key, fileId);
    }

    @Override
    public String evaluateStageFieldContainerLevel(IContainer query) {
        String fileId = CacheHelper.extractFileID((EObject)((IMetaData)((Object)query)).basicGetRef());
        String key = this.getKey(((IMetaData)((Object)query)).basicGetRef(), "container", "stageFieldContainerLevel");
        return this.readProperty(key, fileId);
    }

    @Override
    public String evaluateStageFieldLevel(IContainer query) {
        String fileId = CacheHelper.extractFileID((EObject)((IMetaData)((Object)query)).basicGetRef());
        String key = this.getKey(((IMetaData)((Object)query)).basicGetRef(), "container", "stageFieldLevel");
        return this.readProperty(key, fileId);
    }

    String getFileId(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        if (mode == IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING) {
            EObject proxy = container.basicGetStagingArea();
            if (proxy != null) {
                return CacheHelper.extractFileID((EObject)proxy);
            }
            return CacheHelper.extractFileID((EObject)((IMetaData)((Object)container)).basicGetRef());
        }
        if (mode == IMetaDataInformationsProvider.EvaluationLocation.ON_REF) {
            return CacheHelper.extractFileID((EObject)((IMetaData)((Object)container)).basicGetRef());
        }
        throw new RuntimeException(String.format(Messages.DesignMetaDataInformationsProvider_wrongEveluationMode, new Object[]{mode}));
    }

    EObject getRefProxy(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        if (mode == IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING) {
            EObject proxy = container.basicGetStagingArea();
            if (proxy != null) {
                return proxy;
            }
            return ((IMetaData)((Object)container)).basicGetRef();
        }
        if (mode == IMetaDataInformationsProvider.EvaluationLocation.ON_REF) {
            return ((IMetaData)((Object)container)).basicGetRef();
        }
        throw new RuntimeException(String.format(Messages.DesignMetaDataInformationsProvider_wrongEveluationMode, new Object[]{mode}));
    }

    @Override
    public boolean supportExtraStaticFieldUsageOnWrk(Datastore container) {
        String fileId = CacheHelper.extractFileID((EObject)container.basicGetRef());
        String key = this.getKey(container.basicGetRef(), "datastore", "supportExtraFieldUsageOnWrk");
        String val = this.readProperty(key, fileId);
        return Boolean.valueOf(val);
    }

    @Override
    public Map<IMetaDataInformationsProvider.ICriteria, String> evaluateDynamicCriterias(IContainer container, IMetaDataInformationsProvider.EvaluationLocation mode) {
        String fileId = this.getFileId(container, mode);
        String key = this.getKey(this.getRefProxy(container, mode), "container", "dynamicCriteria");
        String val = this.readProperty(key, fileId);
        if (val != null && !val.trim().isEmpty()) {
            String[] entries;
            HashMap<IMetaDataInformationsProvider.ICriteria, String> res = new HashMap<IMetaDataInformationsProvider.ICriteria, String>();
            String[] stringArray = entries = val.split(";");
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                String[] p = e.split("=");
                res.put(new MdEvaluator.Criteria(p[0]), p[1]);
                ++n2;
            }
            return res;
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public String evaluateSerdeObjectDelimiterMask(ISerde outliner) {
        String fileId = CacheHelper.extractFileID((EObject)outliner.basicGetFieldsReference());
        String key = this.getKey(outliner.basicGetFieldsReference(), "datastore", "objectDelimiterMask");
        return this.readProperty(key, fileId);
    }

    @Override
    public String evaluateSerdeObjectDelimiterRegexp(ISerde outliner) {
        String fileId = CacheHelper.extractFileID((EObject)outliner.basicGetFieldsReference());
        String key = this.getKey(outliner.basicGetFieldsReference(), "datastore", "objectDelimiterRegexp");
        return this.readProperty(key, fileId);
    }
}

