/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.api.internal;

import com.indy.map.Clause;
import com.indy.map.ComputedField;
import com.indy.map.Constraint;
import com.indy.map.DataSet;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.Filter;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.Join;
import com.indy.map.JoinLocation;
import com.indy.map.Map;
import com.indy.map.Template;
import com.indy.map.UDFRef;
import com.indy.map.api.IMapAPI;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RConstraint;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RField;
import com.indy.map.ref.RLoadSet;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RSourceSet;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RUDFRef;
import com.indy.map.ref.RUsage;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class DesignMapAPI
implements IMapAPI {
    private IMetaDataInformationsProvider mdHelper;

    public DesignMapAPI(IMetaDataInformationsProvider mdHelper) {
        this.mdHelper = mdHelper;
    }

    @Override
    public List<IContainer> getSrcContainers(IContainer container) {
        ArrayList<IContainer> res = new ArrayList<IContainer>();
        for (ILogicalField f : container.getLogicalField()) {
            for (Expression ex : f.getExpression()) {
                for (RSourceItem it : ((RExpression)ex.getMapReference()).getSourceRef()) {
                    IContainer c;
                    if (!(it instanceof RLogicalField) || (c = (IContainer)it.getDataModel().eContainer()) == null || res.contains(c)) continue;
                    res.add(c);
                }
            }
        }
        return res;
    }

    @Override
    public RLoadSet getLoadSet(Template t) {
        return ((RTemplate)t.getMapReference()).getLoad();
    }

    @Override
    public Collection<RSourceItem> getSourceItems(Expression ex) {
        return this.getSourceItems((RUsage)ex.getMapReference());
    }

    @Override
    public BigInteger getPosition(ILogicalField field) {
        return ((RLogicalField)((IReferencable)((Object)field)).getMapReference()).getPosition();
    }

    @Override
    public List<IContainer> getTargetRef(Template tpl) {
        return ((RTemplate)tpl.getMapReference()).getTargetRef();
    }

    @Override
    public String getTemplateCriteria(Template tpl) {
        return ((RTemplate)tpl.getMapReference()).getTemplateCriteria();
    }

    @Override
    public List<IContainer> getRef(Template tpl) {
        return ((RTemplate)tpl.getMapReference()).getRef();
    }

    @Override
    public RTemplate.Type getTemplateType(Template tpl) {
        return ((RTemplate)tpl.getMapReference()).getTemplateType();
    }

    @Override
    public String getConstraintType(Constraint cons) {
        return ((RConstraint)cons.getMapReference()).getType();
    }

    @Override
    public boolean isMandatory(Field field) {
        return ((RField)field.getMapReference()).isMandatory();
    }

    @Override
    public IRegistryService.IRegistryMatcher getUDFIndentifier(UDFRef r) {
        return ((RUDFRef)r.getMapReference()).getIdentifier();
    }

    @Override
    public boolean hasNoLoad(Template tpl) {
        RTemplate ref = (RTemplate)tpl.getMapReference();
        return ref.getTemplateType().isIntegration() && !ref.hasLoad();
    }

    @Override
    public String getInternalExpression(Clause clause) {
        return this.getInternalExpression((RUsage)clause.getMapReference());
    }

    protected String getInternalExpression(RUsage usage) {
        return usage.getInternalExpression();
    }

    @Override
    public String getInternalExpression(Expression exp) {
        return this.getInternalExpression((RUsage)exp.getMapReference());
    }

    @Override
    public List<IContainer> getInvolvedContainers(Clause clause) {
        ArrayList<IContainer> l = new ArrayList<IContainer>();
        if (clause instanceof Join) {
            if (((Join)clause).getLeft() != null) {
                l.add(((Join)clause).getLeft());
            }
            if (((Join)clause).getRight() != null) {
                l.add(((Join)clause).getRight());
            }
        }
        for (RSourceItem it : ((RClause)clause.getMapReference()).getSourceRef()) {
            if (!(it.getDataModel() instanceof ILogicalField) || it.getDataModel().eContainer() == null || l.contains(it.getDataModel().eContainer())) continue;
            l.add((IContainer)it.getDataModel().eContainer());
        }
        return l;
    }

    @Override
    public IMetaDataInformationsProvider getMdEvaluator() {
        return this.mdHelper;
    }

    @Override
    public List<Join> getJoins(DataSet ds) {
        ArrayList<Join> joins = new ArrayList<Join>();
        for (IContainer c : ds.getContainer()) {
            for (ILogicalField f : c.getAllLogicalField()) {
                for (RUsage usage : ds.getAPI().getUsage(f)) {
                    if (!(usage.getDataModel() instanceof Join) || joins.contains(usage.getDataModel())) continue;
                    joins.add((Join)usage.getDataModel());
                }
            }
        }
        if (ds.eContainer() instanceof Map) {
            for (Join j : ((Map)ds.eContainer()).getJoin()) {
                if (joins.contains(j) || j.getLeft() == null || j.getRight() == null || j.getLeft().getDataset() != j.getRight().getDataset() || j.getLeft().getDataset() != ds) continue;
                joins.add(j);
            }
        }
        return joins;
    }

    protected Collection<RSourceItem> getSourceItems(RUsage usage) {
        return usage.getSourceRef();
    }

    @Override
    public Collection<RSourceItem> getSourceItems(Clause clause) {
        return this.getSourceItems((RUsage)clause.getMapReference());
    }

    @Override
    public Collection<RSourceItem> getSourceItems(ComputedField computedField) {
        return this.getSourceItems((RUsage)computedField.getMapReference());
    }

    @Override
    public List<RUsage> getUsage(ILogicalField srcField) {
        return ((RLogicalField)((IReferencable)((Object)srcField)).getMapReference()).getUsage();
    }

    @Override
    public void clearCache() {
    }

    @Override
    public List<Template> getTemplates(Filter f) {
        ArrayList<Template> res = new ArrayList<Template>();
        Map map = (Map)f.eContainer();
        RMap refMap = (RMap)map.getMapReference();
        List filterSources = f.getInvolvedContainers();
        Collection sourceSets = filterSources.stream().map(c -> c.getDataset()).collect(Collectors.toSet()).stream().map(d -> refMap.getSourceSetRef((DataSet)d)).flatMap(Collection::stream).collect(Collectors.toSet());
        for (RSourceSet ss : sourceSets) {
            List tpls = map.getTemplateForTarget(ss.getTargetSet().getContainerModel().get(0));
            tpls.sort(Comparator.comparing(Template::getName).reversed());
            boolean handledByLoad = false;
            for (Template t : tpls) {
                RTemplate ref = (RTemplate)t.getMapReference();
                if (f.getLocation() == JoinLocation.SRC) {
                    String filterConnectionId;
                    if (ref.getTemplateType() == RTemplate.Type.LOAD) {
                        if (Collections.disjoint(ref.getLoad().getContainer(), filterSources)) continue;
                        handledByLoad = true;
                        res.add(t);
                        continue;
                    }
                    if (handledByLoad || !ref.getTemplateType().isIntegration()) continue;
                    IMetaDataInformationsProvider.EvaluationLocation mode = f.getLocation() == JoinLocation.WRK ? IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING : IMetaDataInformationsProvider.EvaluationLocation.ON_REF;
                    String targetConnectionId = map.getAPI().getMdEvaluator().evaluateConnectionId(ss.getTargetSet().getContainerModel().get(0), mode);
                    if (!targetConnectionId.equals(filterConnectionId = map.getAPI().getMdEvaluator().evaluateConnectionId((IContainer)filterSources.get(0), mode)) || Collections.disjoint(ref.getRef(), filterSources)) continue;
                    res.add(t);
                    continue;
                }
                if (f.getLocation() != JoinLocation.WRK || !ref.getTemplateType().isIntegration()) continue;
                res.add(t);
            }
        }
        return res;
    }
}

