/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.compute.graph.builder;

import com.indy.map.compute.graph.Edge;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.IGraphBuilder;
import com.indy.map.compute.graph.ISortedGraph;
import com.indy.map.compute.graph.Vertice;
import com.indy.map.messages.Messages;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;

public class ResourceDependanciesGraphBuilder
implements IGraphBuilder {
    @Override
    public Graph buildGraph(Object modelObject) {
        Collection resources = (Collection)modelObject;
        DependancyGraph graph = new DependancyGraph();
        for (URI r : resources) {
            if (r == null) continue;
            this.addResourceVertice(graph, r);
        }
        return graph;
    }

    private void addResourceVertice(Graph graph, URI uri) {
        Vertice v = graph.createVertice(uri);
        for (URI r2 : this.getDependancies(uri)) {
            Vertice v2 = graph.getVertice(r2);
            boolean newVertice = false;
            if (v2 == null) {
                v2 = graph.createVertice(r2);
                newVertice = true;
            }
            graph.createEdge(v2, v);
            if (!newVertice) continue;
            this.addResourceVertice(graph, r2);
        }
    }

    private List<URI> getDependancies(URI object) {
        return ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getReferencedResources(object);
    }

    public class DependancyGraph
    extends Graph
    implements ISortedGraph<URI> {
        HashMap<Vertice, Object> modelMap = new HashMap();

        @Override
        public Vertice createVertice(Object modelObject) {
            Vertice v = super.createVertice(modelObject);
            this.modelMap.put(v, modelObject);
            return v;
        }

        @Override
        public void dump() {
            System.out.println("*****");
            for (Vertice v : this.getRootVertice()) {
                System.out.println("- " + String.valueOf(this.modelMap.get(v)));
                for (Edge e : this.getEdges()) {
                    if (e.getEnd() != v) continue;
                    System.out.println("\t- " + String.valueOf(this.modelMap.get(e.getStart())));
                }
            }
        }

        private List<Object> topologicalOrderMap() throws Exception {
            TopologicalSorter sorter = new TopologicalSorter();
            return sorter.getSortedVertex(this);
        }

        @Override
        public List<URI> getSortedModelItem() throws Exception {
            ArrayList<URI> l = new ArrayList<URI>();
            for (Object o : this.topologicalOrderMap()) {
                if (!(o instanceof URI) || !"map".equals(((URI)o).fileExtension())) continue;
                l.add((URI)o);
            }
            return l;
        }

        @Override
        public Collection<URI> getAllSortedModelItem() {
            return this.modelMap.values();
        }
    }

    private class TopologicalSorter {
        private List<Vertice> sortedVertex;
        private Graph graph;

        private TopologicalSorter() {
        }

        private Vertice getUnmarked() {
            for (Vertice v : this.graph.getVertex()) {
                if (v.getState() != Vertice.State.INITED) continue;
                return v;
            }
            return null;
        }

        private void visit(Vertice v) throws Exception {
            if (v.getState() == Vertice.State.VISITING) {
                throw new Exception(Messages.ResourceDependanciesGraphBuilder_4);
            }
            if (v.getState() == Vertice.State.INITED) {
                v.setState(Vertice.State.VISITING);
                for (Edge e : this.graph.getEdges()) {
                    if (e.getStart() == v) {
                        this.visit(e.getEnd());
                    }
                    v.setState(Vertice.State.VISITED);
                    this.sortedVertex.add(v);
                }
            }
        }

        public List<Object> getSortedVertex(DependancyGraph g) throws Exception {
            this.graph = g;
            this.sortedVertex = new ArrayList<Vertice>();
            Vertice cur = null;
            while ((cur = this.getUnmarked()) != null) {
                this.visit(cur);
            }
            ArrayList<Object> val = new ArrayList<Object>();
            for (Vertice v : this.graph.getVertex()) {
                val.add(((DependancyGraph)this.graph).modelMap.get(v));
            }
            return val;
        }
    }
}

