/*
 * Decompiled with CFR 0.152.
 */
package com.indy.map.custom.commands;

import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.ref.RField;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.tech.Level;
import com.stambia.tech.MappingType;
import com.stambia.tech.XpathExpression;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;

public class FieldUpdaterUtils {
    static boolean compareName(Field field1, Field field2) {
        if (field1 == null || field2 == null) {
            return false;
        }
        if (field1.getName().equals(field2.getName())) {
            if (field1.getParent() == null && field2.getParent() == null) {
                return true;
            }
            return FieldUpdaterUtils.compareName(field1.getParent(), field2.getParent());
        }
        return false;
    }

    static boolean isUsed(Field srcField) {
        return ((RField)srcField.getMapReference()).getUsage().size() > 0;
    }

    static boolean mappedDescendant(Field field) {
        if (field.getChildren().isEmpty()) {
            return FieldUpdaterUtils.isMapped(field);
        }
        for (Field f : field.getChildren()) {
            if (!FieldUpdaterUtils.mappedDescendant(f)) continue;
            return true;
        }
        return false;
    }

    static boolean isMapped(Field field) {
        for (Expression ex : field.getExpression()) {
            if (ex.getExpression() == null || ex.getExpression().trim().isEmpty()) continue;
            return true;
        }
        return false;
    }

    static boolean addAsChildren(MdNode mdNode2) {
        Level level = mdNode2.getLevel();
        if (level == null) {
            return false;
        }
        return level != null && (mdNode2.getMappingType().contains(MappingType.MAPPING) || mdNode2.getMappingType().contains(MappingType.TARGET_MAPPING) || mdNode2.getMappingType().contains(MappingType.SOURCE_MAPPING));
    }

    static void getMappingChildren(MdNode parent, Collection<MdNode> list) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        XpathExpression xPath = parent.getXPathExpression("INTERNAL_MAPPING_FIELDS_REF");
        if (xPath != null) {
            try {
                Object object = parent.evaluateMdSet(xPath.getExpression());
                if (object instanceof MdNode) {
                    nodes.add(object);
                } else if (object instanceof Collection) {
                    for (Object i : (Collection)object) {
                        if (!(i instanceof MdNode)) continue;
                        nodes.add(i);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            nodes.addAll((Collection<Object>)parent.getNode());
        }
        Collections.sort(nodes, Configuration.comparator);
        for (MdNode mdNode : nodes) {
            if (FieldUpdaterUtils.addAsChildren(mdNode)) {
                list.add(mdNode);
                continue;
            }
            FieldUpdaterUtils.getMappingChildren(mdNode, list);
        }
    }

    public static class Position {
        int value = 0;

        public void increment() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }
    }

    static class SetFieldPositionCommand
    extends AbstractCommand {
        private Field f;
        private BigInteger pos;
        private BigInteger oldValue;

        SetFieldPositionCommand(Field f, BigInteger pos) {
            this.f = f;
            this.pos = pos;
        }

        public boolean canExecute() {
            return true;
        }

        public void execute() {
            this.oldValue = ((RField)this.f.getMapReference()).getPosition();
            ((RField)this.f.getMapReference()).setPosition(this.pos);
        }

        public void undo() {
            ((RField)this.f.getMapReference()).setPosition(this.oldValue);
        }

        public boolean canUndo() {
            return true;
        }

        public void redo() {
            this.execute();
        }
    }
}

